/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.ClearanceSystem;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.ExchangeIdentifierModel;
import fpml.confirmation.ExchangeTradedContractUnderlyer;
import fpml.confirmation.ExchangeTradedOption;
import fpml.confirmation.ExchangeTradedOptionSequence;
import fpml.confirmation.ExerciseStyleEnum;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.InstrumentType;
import fpml.confirmation.ProductReference;
import fpml.confirmation.PutCallEnum;
import fpml.confirmation.SettlementTypeEnum;
import fpml.confirmation.meta.OptionElementMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="OptionElement", builder=OptionElementBuilderImpl.class, version="0.17.2")
@RuneDataType(value="OptionElement", model="fpml", builder=OptionElementBuilderImpl.class, version="0.17.2")
public interface OptionElement
extends ExchangeTradedOption {
    public static final OptionElementMeta metaData = new OptionElementMeta();

    @Override
    public OptionElement build();

    @Override
    public OptionElementBuilder toBuilder();

    public static OptionElementBuilder builder() {
        return new OptionElementBuilderImpl();
    }

    default public RosettaMetaData<? extends OptionElement> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends OptionElement> getType() {
        return OptionElement.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeTradedOptionSequence"), processor, ExchangeTradedOptionSequence.class, this.getExchangeTradedOptionSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("exerciseStyle"), ExerciseStyleEnum.class, (Object)this.getExerciseStyle(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.class, this.getUnderlyer(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class OptionElementBuilderImpl
    extends ExchangeTradedOption.ExchangeTradedOptionBuilderImpl
    implements OptionElementBuilder {
        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public OptionElementBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public OptionElementBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public OptionElementBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public OptionElementBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public OptionElementBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public OptionElementBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public OptionElementBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public OptionElementBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public OptionElementBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public OptionElementBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public OptionElementBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public OptionElementBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public OptionElementBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public OptionElementBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public OptionElementBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public OptionElementBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractReference")
        @RuneAttribute(value="contractReference")
        public OptionElementBuilder setContractReference(String _contractReference) {
            this.contractReference = _contractReference == null ? null : _contractReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public OptionElementBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeTradedOptionSequence")
        @RuneAttribute(value="exchangeTradedOptionSequence")
        public OptionElementBuilder setExchangeTradedOptionSequence(ExchangeTradedOptionSequence _exchangeTradedOptionSequence) {
            this.exchangeTradedOptionSequence = _exchangeTradedOptionSequence == null ? null : _exchangeTradedOptionSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="optionType")
        @RuneAttribute(value="optionType")
        public OptionElementBuilder setOptionType(PutCallEnum _optionType) {
            this.optionType = _optionType == null ? null : _optionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseStyle")
        @RuneAttribute(value="exerciseStyle")
        public OptionElementBuilder setExerciseStyle(ExerciseStyleEnum _exerciseStyle) {
            this.exerciseStyle = _exerciseStyle == null ? null : _exerciseStyle;
            return this;
        }

        @Override
        @RosettaAttribute(value="underlyer")
        @RuneAttribute(value="underlyer")
        public OptionElementBuilder setUnderlyer(ExchangeTradedContractUnderlyer _underlyer) {
            this.underlyer = _underlyer == null ? null : _underlyer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="settlementType")
        @RuneAttribute(value="settlementType")
        public OptionElementBuilder setSettlementType(SettlementTypeEnum _settlementType) {
            this.settlementType = _settlementType == null ? null : _settlementType;
            return this;
        }

        @Override
        public OptionElement build() {
            return new OptionElementImpl(this);
        }

        @Override
        public OptionElementBuilder toBuilder() {
            return this;
        }

        @Override
        public OptionElementBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public OptionElementBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            OptionElementBuilder o = (OptionElementBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "OptionElementBuilder {} " + super.toString();
        }
    }

    public static interface OptionElementBuilder
    extends OptionElement,
    ExchangeTradedOption.ExchangeTradedOptionBuilder {
        @Override
        public OptionElementBuilder setId(String var1);

        @Override
        public OptionElementBuilder addInstrumentId(InstrumentId var1);

        @Override
        public OptionElementBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public OptionElementBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public OptionElementBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public OptionElementBuilder addInstrumentType(InstrumentType var1);

        @Override
        public OptionElementBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public OptionElementBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public OptionElementBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public OptionElementBuilder setDescription(String var1);

        @Override
        public OptionElementBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public OptionElementBuilder setExchangeId(ExchangeId var1);

        @Override
        public OptionElementBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public OptionElementBuilder setDefinition(ProductReference var1);

        @Override
        public OptionElementBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        @Override
        public OptionElementBuilder setMultiplier(BigDecimal var1);

        @Override
        public OptionElementBuilder setContractReference(String var1);

        @Override
        public OptionElementBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        @Override
        public OptionElementBuilder setExchangeTradedOptionSequence(ExchangeTradedOptionSequence var1);

        @Override
        public OptionElementBuilder setOptionType(PutCallEnum var1);

        @Override
        public OptionElementBuilder setExerciseStyle(ExerciseStyleEnum var1);

        @Override
        public OptionElementBuilder setUnderlyer(ExchangeTradedContractUnderlyer var1);

        @Override
        public OptionElementBuilder setSettlementType(SettlementTypeEnum var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, (RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, (RosettaModelObjectBuilder)this.getExpirationDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeTradedOptionSequence"), processor, ExchangeTradedOptionSequence.ExchangeTradedOptionSequenceBuilder.class, (RosettaModelObjectBuilder)this.getExchangeTradedOptionSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("optionType"), PutCallEnum.class, (Object)this.getOptionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("exerciseStyle"), ExerciseStyleEnum.class, (Object)this.getExerciseStyle(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("underlyer"), processor, ExchangeTradedContractUnderlyer.ExchangeTradedContractUnderlyerBuilder.class, (RosettaModelObjectBuilder)this.getUnderlyer(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("settlementType"), SettlementTypeEnum.class, (Object)this.getSettlementType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public OptionElementBuilder prune();
    }

    public static class OptionElementImpl
    extends ExchangeTradedOption.ExchangeTradedOptionImpl
    implements OptionElement {
        protected OptionElementImpl(OptionElementBuilder builder) {
            super(builder);
        }

        @Override
        public OptionElement build() {
            return this;
        }

        @Override
        public OptionElementBuilder toBuilder() {
            OptionElementBuilder builder = OptionElement.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(OptionElementBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "OptionElement {} " + super.toString();
        }
    }
}

