/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AbstractEvent;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.ObservationSource;
import fpml.confirmation.QuotationRateTypeEnum;
import fpml.confirmation.TimeZone;
import fpml.confirmation.meta.ObservationEventMeta;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ObservationEvent", builder=ObservationEventBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ObservationEvent", model="fpml", builder=ObservationEventBuilderImpl.class, version="0.17.2")
public interface ObservationEvent
extends AbstractEvent {
    public static final ObservationEventMeta metaData = new ObservationEventMeta();

    public ZonedDateTime getDate();

    public TimeZone getTime();

    public QuotationRateTypeEnum getSide();

    public BigDecimal getObservedValue();

    public ObservationSource getSource();

    @Override
    public ObservationEvent build();

    @Override
    public ObservationEventBuilder toBuilder();

    public static ObservationEventBuilder builder() {
        return new ObservationEventBuilderImpl();
    }

    default public RosettaMetaData<? extends ObservationEvent> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ObservationEvent> getType() {
        return ObservationEvent.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("time"), processor, TimeZone.class, this.getTime(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("side"), QuotationRateTypeEnum.class, (Object)this.getSide(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("observedValue"), BigDecimal.class, (Object)this.getObservedValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("source"), processor, ObservationSource.class, this.getSource(), new AttributeMeta[0]);
    }

    public static class ObservationEventBuilderImpl
    extends AbstractEvent.AbstractEventBuilderImpl
    implements ObservationEventBuilder {
        protected ZonedDateTime date;
        protected TimeZone.TimeZoneBuilder time;
        protected QuotationRateTypeEnum side;
        protected BigDecimal observedValue;
        protected ObservationSource.ObservationSourceBuilder source;

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public TimeZone.TimeZoneBuilder getTime() {
            return this.time;
        }

        @Override
        public TimeZone.TimeZoneBuilder getOrCreateTime() {
            TimeZone.TimeZoneBuilder result = this.time != null ? this.time : (this.time = TimeZone.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public QuotationRateTypeEnum getSide() {
            return this.side;
        }

        @Override
        @RosettaAttribute(value="observedValue", isRequired=true)
        @RuneAttribute(value="observedValue", isRequired=true)
        public BigDecimal getObservedValue() {
            return this.observedValue;
        }

        @Override
        @RosettaAttribute(value="source", isRequired=true)
        @RuneAttribute(value="source", isRequired=true)
        public ObservationSource.ObservationSourceBuilder getSource() {
            return this.source;
        }

        @Override
        public ObservationSource.ObservationSourceBuilder getOrCreateSource() {
            ObservationSource.ObservationSourceBuilder result = this.source != null ? this.source : (this.source = ObservationSource.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public ObservationEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ObservationEventBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public ObservationEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public ObservationEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ObservationEventBuilder setDate(ZonedDateTime _date) {
            this.date = _date == null ? null : _date;
            return this;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public ObservationEventBuilder setTime(TimeZone _time) {
            this.time = _time == null ? null : _time.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public ObservationEventBuilder setSide(QuotationRateTypeEnum _side) {
            this.side = _side == null ? null : _side;
            return this;
        }

        @Override
        @RosettaAttribute(value="observedValue", isRequired=true)
        @RuneAttribute(value="observedValue", isRequired=true)
        public ObservationEventBuilder setObservedValue(BigDecimal _observedValue) {
            this.observedValue = _observedValue == null ? null : _observedValue;
            return this;
        }

        @Override
        @RosettaAttribute(value="source", isRequired=true)
        @RuneAttribute(value="source", isRequired=true)
        public ObservationEventBuilder setSource(ObservationSource _source) {
            this.source = _source == null ? null : _source.toBuilder();
            return this;
        }

        @Override
        public ObservationEvent build() {
            return new ObservationEventImpl(this);
        }

        @Override
        public ObservationEventBuilder toBuilder() {
            return this;
        }

        @Override
        public ObservationEventBuilder prune() {
            super.prune();
            if (this.time != null && !this.time.prune().hasData()) {
                this.time = null;
            }
            if (this.source != null && !this.source.prune().hasData()) {
                this.source = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getDate() != null) {
                return true;
            }
            if (this.getTime() != null && this.getTime().hasData()) {
                return true;
            }
            if (this.getSide() != null) {
                return true;
            }
            if (this.getObservedValue() != null) {
                return true;
            }
            return this.getSource() != null && this.getSource().hasData();
        }

        @Override
        public ObservationEventBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ObservationEventBuilder o = (ObservationEventBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTime(), (RosettaModelObjectBuilder)o.getTime(), this::setTime);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getSource(), (RosettaModelObjectBuilder)o.getSource(), this::setSource);
            merger.mergeBasic((Object)this.getDate(), (Object)o.getDate(), this::setDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSide(), (Object)o.getSide(), this::setSide, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getObservedValue(), (Object)o.getObservedValue(), this::setObservedValue, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ObservationEvent _that = (ObservationEvent)this.getType().cast(o);
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.side, (Object)_that.getSide())) {
                return false;
            }
            if (!Objects.equals(this.observedValue, _that.getObservedValue())) {
                return false;
            }
            return Objects.equals(this.source, _that.getSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.side != null ? ((Object)((Object)this.side)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.observedValue != null ? this.observedValue.hashCode() : 0);
            _result = 31 * _result + (this.source != null ? this.source.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ObservationEventBuilder {date=" + this.date + ", time=" + this.time + ", side=" + (Object)((Object)this.side) + ", observedValue=" + this.observedValue + ", source=" + this.source + '}' + " " + super.toString();
        }
    }

    public static interface ObservationEventBuilder
    extends ObservationEvent,
    AbstractEvent.AbstractEventBuilder {
        public TimeZone.TimeZoneBuilder getOrCreateTime();

        @Override
        public TimeZone.TimeZoneBuilder getTime();

        public ObservationSource.ObservationSourceBuilder getOrCreateSource();

        @Override
        public ObservationSource.ObservationSourceBuilder getSource();

        @Override
        public ObservationEventBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public ObservationEventBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public ObservationEventBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public ObservationEventBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        public ObservationEventBuilder setDate(ZonedDateTime var1);

        public ObservationEventBuilder setTime(TimeZone var1);

        public ObservationEventBuilder setSide(QuotationRateTypeEnum var1);

        public ObservationEventBuilder setObservedValue(BigDecimal var1);

        public ObservationEventBuilder setSource(ObservationSource var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("date"), ZonedDateTime.class, (Object)this.getDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("time"), processor, TimeZone.TimeZoneBuilder.class, this.getTime(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("side"), QuotationRateTypeEnum.class, (Object)this.getSide(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("observedValue"), BigDecimal.class, (Object)this.getObservedValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("source"), processor, ObservationSource.ObservationSourceBuilder.class, this.getSource(), new AttributeMeta[0]);
        }

        @Override
        public ObservationEventBuilder prune();
    }

    public static class ObservationEventImpl
    extends AbstractEvent.AbstractEventImpl
    implements ObservationEvent {
        private final ZonedDateTime date;
        private final TimeZone time;
        private final QuotationRateTypeEnum side;
        private final BigDecimal observedValue;
        private final ObservationSource source;

        protected ObservationEventImpl(ObservationEventBuilder builder) {
            super(builder);
            this.date = builder.getDate();
            this.time = Optional.ofNullable(builder.getTime()).map(f -> f.build()).orElse(null);
            this.side = builder.getSide();
            this.observedValue = builder.getObservedValue();
            this.source = Optional.ofNullable(builder.getSource()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="date", isRequired=true)
        @RuneAttribute(value="date", isRequired=true)
        public ZonedDateTime getDate() {
            return this.date;
        }

        @Override
        @RosettaAttribute(value="time")
        @RuneAttribute(value="time")
        public TimeZone getTime() {
            return this.time;
        }

        @Override
        @RosettaAttribute(value="side")
        @RuneAttribute(value="side")
        public QuotationRateTypeEnum getSide() {
            return this.side;
        }

        @Override
        @RosettaAttribute(value="observedValue", isRequired=true)
        @RuneAttribute(value="observedValue", isRequired=true)
        public BigDecimal getObservedValue() {
            return this.observedValue;
        }

        @Override
        @RosettaAttribute(value="source", isRequired=true)
        @RuneAttribute(value="source", isRequired=true)
        public ObservationSource getSource() {
            return this.source;
        }

        @Override
        public ObservationEvent build() {
            return this;
        }

        @Override
        public ObservationEventBuilder toBuilder() {
            ObservationEventBuilder builder = ObservationEvent.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ObservationEventBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getDate()).ifPresent(builder::setDate);
            Optional.ofNullable(this.getTime()).ifPresent(builder::setTime);
            Optional.ofNullable(this.getSide()).ifPresent(builder::setSide);
            Optional.ofNullable(this.getObservedValue()).ifPresent(builder::setObservedValue);
            Optional.ofNullable(this.getSource()).ifPresent(builder::setSource);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ObservationEvent _that = (ObservationEvent)this.getType().cast(o);
            if (!Objects.equals(this.date, _that.getDate())) {
                return false;
            }
            if (!Objects.equals(this.time, _that.getTime())) {
                return false;
            }
            if (!Objects.equals((Object)this.side, (Object)_that.getSide())) {
                return false;
            }
            if (!Objects.equals(this.observedValue, _that.getObservedValue())) {
                return false;
            }
            return Objects.equals(this.source, _that.getSource());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.date != null ? this.date.hashCode() : 0);
            _result = 31 * _result + (this.time != null ? this.time.hashCode() : 0);
            _result = 31 * _result + (this.side != null ? ((Object)((Object)this.side)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.observedValue != null ? this.observedValue.hashCode() : 0);
            _result = 31 * _result + (this.source != null ? this.source.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ObservationEvent {date=" + this.date + ", time=" + this.time + ", side=" + (Object)((Object)this.side) + ", observedValue=" + this.observedValue + ", source=" + this.source + '}' + " " + super.toString();
        }
    }
}

