/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.FacilityReference;
import fpml.confirmation.IssuerTradeIdModel;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.TradeIdentifier;
import fpml.confirmation.TradeIdentifierSequence;
import fpml.confirmation.meta.LoanTradeSummaryMeta;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="LoanTradeSummary", builder=LoanTradeSummaryBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanTradeSummary", model="fpml", builder=LoanTradeSummaryBuilderImpl.class, version="0.17.2")
public interface LoanTradeSummary
extends TradeIdentifier {
    public static final LoanTradeSummaryMeta metaData = new LoanTradeSummaryMeta();

    public FacilityReference getFacilityReference();

    public NonNegativeMoney getAmount();

    public String getComment();

    @Override
    public LoanTradeSummary build();

    @Override
    public LoanTradeSummaryBuilder toBuilder();

    public static LoanTradeSummaryBuilder builder() {
        return new LoanTradeSummaryBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanTradeSummary> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanTradeSummary> getType() {
        return LoanTradeSummary.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.class, this.getIssuerTradeIdModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.class, this.getTradeIdentifierSequence(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.class, this.getAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class LoanTradeSummaryBuilderImpl
    extends TradeIdentifier.TradeIdentifierBuilderImpl
    implements LoanTradeSummaryBuilder {
        protected FacilityReference.FacilityReferenceBuilder facilityReference;
        protected NonNegativeMoney.NonNegativeMoneyBuilder amount;
        protected String comment;

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference.FacilityReferenceBuilder getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference() {
            FacilityReference.FacilityReferenceBuilder result = this.facilityReference != null ? this.facilityReference : (this.facilityReference = FacilityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount() {
            return this.amount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.amount != null ? this.amount : (this.amount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        @RosettaAttribute(value="issuerTradeIdModel")
        @RuneAttribute(value="issuerTradeIdModel")
        public LoanTradeSummaryBuilder setIssuerTradeIdModel(IssuerTradeIdModel _issuerTradeIdModel) {
            this.issuerTradeIdModel = _issuerTradeIdModel == null ? null : _issuerTradeIdModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tradeIdentifierSequence")
        @RuneAttribute(value="tradeIdentifierSequence")
        public LoanTradeSummaryBuilder setTradeIdentifierSequence(TradeIdentifierSequence _tradeIdentifierSequence) {
            this.tradeIdentifierSequence = _tradeIdentifierSequence == null ? null : _tradeIdentifierSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public LoanTradeSummaryBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public LoanTradeSummaryBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LoanTradeSummaryBuilder setAmount(NonNegativeMoney _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LoanTradeSummaryBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        public LoanTradeSummary build() {
            return new LoanTradeSummaryImpl(this);
        }

        @Override
        public LoanTradeSummaryBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanTradeSummaryBuilder prune() {
            super.prune();
            if (this.facilityReference != null && !this.facilityReference.prune().hasData()) {
                this.facilityReference = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFacilityReference() != null && this.getFacilityReference().hasData()) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getComment() != null;
        }

        @Override
        public LoanTradeSummaryBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LoanTradeSummaryBuilder o = (LoanTradeSummaryBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityReference(), (RosettaModelObjectBuilder)o.getFacilityReference(), this::setFacilityReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeBasic((Object)this.getComment(), (Object)o.getComment(), this::setComment, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradeSummary _that = (LoanTradeSummary)this.getType().cast(o);
            if (!Objects.equals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeSummaryBuilder {facilityReference=" + this.facilityReference + ", amount=" + this.amount + ", comment=" + this.comment + '}' + " " + super.toString();
        }
    }

    public static interface LoanTradeSummaryBuilder
    extends LoanTradeSummary,
    TradeIdentifier.TradeIdentifierBuilder {
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference();

        @Override
        public FacilityReference.FacilityReferenceBuilder getFacilityReference();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getAmount();

        @Override
        public LoanTradeSummaryBuilder setIssuerTradeIdModel(IssuerTradeIdModel var1);

        @Override
        public LoanTradeSummaryBuilder setTradeIdentifierSequence(TradeIdentifierSequence var1);

        @Override
        public LoanTradeSummaryBuilder setId(String var1);

        public LoanTradeSummaryBuilder setFacilityReference(FacilityReference var1);

        public LoanTradeSummaryBuilder setAmount(NonNegativeMoney var1);

        public LoanTradeSummaryBuilder setComment(String var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("issuerTradeIdModel"), processor, IssuerTradeIdModel.IssuerTradeIdModelBuilder.class, (RosettaModelObjectBuilder)this.getIssuerTradeIdModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tradeIdentifierSequence"), processor, TradeIdentifierSequence.TradeIdentifierSequenceBuilder.class, (RosettaModelObjectBuilder)this.getTradeIdentifierSequence(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        @Override
        public LoanTradeSummaryBuilder prune();
    }

    public static class LoanTradeSummaryImpl
    extends TradeIdentifier.TradeIdentifierImpl
    implements LoanTradeSummary {
        private final FacilityReference facilityReference;
        private final NonNegativeMoney amount;
        private final String comment;

        protected LoanTradeSummaryImpl(LoanTradeSummaryBuilder builder) {
            super(builder);
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).map(f -> f.build()).orElse(null);
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.comment = builder.getComment();
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public NonNegativeMoney getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public String getComment() {
            return this.comment;
        }

        @Override
        public LoanTradeSummary build() {
            return this;
        }

        @Override
        public LoanTradeSummaryBuilder toBuilder() {
            LoanTradeSummaryBuilder builder = LoanTradeSummary.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanTradeSummaryBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getComment()).ifPresent(builder::setComment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LoanTradeSummary _that = (LoanTradeSummary)this.getType().cast(o);
            if (!Objects.equals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.comment, _that.getComment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.comment != null ? this.comment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LoanTradeSummary {facilityReference=" + this.facilityReference + ", amount=" + this.amount + ", comment=" + this.comment + '}' + " " + super.toString();
        }
    }
}

