/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.LoanContract;
import fpml.confirmation.meta.LoanContractListMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LoanContractList", builder=LoanContractListBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LoanContractList", model="fpml", builder=LoanContractListBuilderImpl.class, version="0.17.2")
public interface LoanContractList
extends RosettaModelObject {
    public static final LoanContractListMeta metaData = new LoanContractListMeta();

    public List<? extends LoanContract> getContract();

    public LoanContractList build();

    public LoanContractListBuilder toBuilder();

    public static LoanContractListBuilder builder() {
        return new LoanContractListBuilderImpl();
    }

    default public RosettaMetaData<? extends LoanContractList> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LoanContractList> getType() {
        return LoanContractList.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("contract"), processor, LoanContract.class, this.getContract(), new AttributeMeta[0]);
    }

    public static class LoanContractListBuilderImpl
    implements LoanContractListBuilder {
        protected List<LoanContract.LoanContractBuilder> contract = new ArrayList<LoanContract.LoanContractBuilder>();

        @Override
        @RosettaAttribute(value="contract", isRequired=true)
        @RuneAttribute(value="contract", isRequired=true)
        public List<? extends LoanContract.LoanContractBuilder> getContract() {
            return this.contract;
        }

        @Override
        public LoanContract.LoanContractBuilder getOrCreateContract(int index) {
            if (this.contract == null) {
                this.contract = new ArrayList<LoanContract.LoanContractBuilder>();
            }
            return (LoanContract.LoanContractBuilder)this.getIndex(this.contract, index, () -> {
                LoanContract.LoanContractBuilder newContract = LoanContract.builder();
                return newContract;
            });
        }

        @Override
        @RosettaAttribute(value="contract", isRequired=true)
        @RuneAttribute(value="contract", isRequired=true)
        public LoanContractListBuilder addContract(LoanContract _contract) {
            if (_contract != null) {
                this.contract.add(_contract.toBuilder());
            }
            return this;
        }

        @Override
        public LoanContractListBuilder addContract(LoanContract _contract, int idx) {
            this.getIndex(this.contract, idx, () -> _contract.toBuilder());
            return this;
        }

        @Override
        public LoanContractListBuilder addContract(List<? extends LoanContract> contracts) {
            if (contracts != null) {
                for (LoanContract loanContract : contracts) {
                    this.contract.add(loanContract.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="contract")
        public LoanContractListBuilder setContract(List<? extends LoanContract> contracts) {
            this.contract = contracts == null ? new ArrayList<LoanContract.LoanContractBuilder>() : (List)contracts.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public LoanContractList build() {
            return new LoanContractListImpl(this);
        }

        @Override
        public LoanContractListBuilder toBuilder() {
            return this;
        }

        @Override
        public LoanContractListBuilder prune() {
            this.contract = this.contract.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            return this.getContract() != null && this.getContract().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public LoanContractListBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            LoanContractListBuilder o = (LoanContractListBuilder)other;
            merger.mergeRosetta(this.getContract(), o.getContract(), this::getOrCreateContract);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanContractList _that = this.getType().cast(o);
            return ListEquals.listEquals(this.contract, _that.getContract());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contract != null ? this.contract.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanContractListBuilder {contract=" + this.contract + '}';
        }
    }

    public static interface LoanContractListBuilder
    extends LoanContractList,
    RosettaModelObjectBuilder {
        public LoanContract.LoanContractBuilder getOrCreateContract(int var1);

        public List<? extends LoanContract.LoanContractBuilder> getContract();

        public LoanContractListBuilder addContract(LoanContract var1);

        public LoanContractListBuilder addContract(LoanContract var1, int var2);

        public LoanContractListBuilder addContract(List<? extends LoanContract> var1);

        public LoanContractListBuilder setContract(List<? extends LoanContract> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("contract"), processor, LoanContract.LoanContractBuilder.class, this.getContract(), new AttributeMeta[0]);
        }

        public LoanContractListBuilder prune();
    }

    public static class LoanContractListImpl
    implements LoanContractList {
        private final List<? extends LoanContract> contract;

        protected LoanContractListImpl(LoanContractListBuilder builder) {
            this.contract = Optional.ofNullable(builder.getContract()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="contract", isRequired=true)
        @RuneAttribute(value="contract", isRequired=true)
        public List<? extends LoanContract> getContract() {
            return this.contract;
        }

        @Override
        public LoanContractList build() {
            return this;
        }

        @Override
        public LoanContractListBuilder toBuilder() {
            LoanContractListBuilder builder = LoanContractList.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LoanContractListBuilder builder) {
            Optional.ofNullable(this.getContract()).ifPresent(builder::setContract);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            LoanContractList _that = this.getType().cast(o);
            return ListEquals.listEquals(this.contract, _that.getContract());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.contract != null ? this.contract.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "LoanContractList {contract=" + this.contract + '}';
        }
    }
}

