/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AbstractLoanContractEvent;
import fpml.confirmation.AbstractLoanEventSequence;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.BusinessEventPartiesModel;
import fpml.confirmation.InterestCalculationMethodEnum;
import fpml.confirmation.LegacyLoanInterestPaymentSequence;
import fpml.confirmation.LenderAndCashDetailsModel;
import fpml.confirmation.LoanContractReference;
import fpml.confirmation.LoanLegalActionReference;
import fpml.confirmation.MoneyWithParticipantShare;
import fpml.confirmation.PeriodModel;
import fpml.confirmation.meta.LegacyLoanInterestPaymentMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegacyLoanInterestPayment", builder=LegacyLoanInterestPaymentBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LegacyLoanInterestPayment", model="fpml", builder=LegacyLoanInterestPaymentBuilderImpl.class, version="0.17.2")
public interface LegacyLoanInterestPayment
extends AbstractLoanContractEvent {
    public static final LegacyLoanInterestPaymentMeta metaData = new LegacyLoanInterestPaymentMeta();

    public PeriodModel getPeriodModel();

    public InterestCalculationMethodEnum getCalculationMethod();

    public MoneyWithParticipantShare getAmount();

    public LegacyLoanInterestPaymentSequence getLegacyLoanInterestPaymentSequence();

    @Override
    public LegacyLoanInterestPayment build();

    @Override
    public LegacyLoanInterestPaymentBuilder toBuilder();

    public static LegacyLoanInterestPaymentBuilder builder() {
        return new LegacyLoanInterestPaymentBuilderImpl();
    }

    default public RosettaMetaData<? extends LegacyLoanInterestPayment> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegacyLoanInterestPayment> getType() {
        return LegacyLoanInterestPayment.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyLoanInterestPaymentSequence"), processor, LegacyLoanInterestPaymentSequence.class, this.getLegacyLoanInterestPaymentSequence(), new AttributeMeta[0]);
    }

    public static class LegacyLoanInterestPaymentBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements LegacyLoanInterestPaymentBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected InterestCalculationMethodEnum calculationMethod;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected LegacyLoanInterestPaymentSequence.LegacyLoanInterestPaymentSequenceBuilder legacyLoanInterestPaymentSequence;

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyLoanInterestPaymentSequence")
        @RuneAttribute(value="legacyLoanInterestPaymentSequence")
        public LegacyLoanInterestPaymentSequence.LegacyLoanInterestPaymentSequenceBuilder getLegacyLoanInterestPaymentSequence() {
            return this.legacyLoanInterestPaymentSequence;
        }

        @Override
        public LegacyLoanInterestPaymentSequence.LegacyLoanInterestPaymentSequenceBuilder getOrCreateLegacyLoanInterestPaymentSequence() {
            LegacyLoanInterestPaymentSequence.LegacyLoanInterestPaymentSequenceBuilder result = this.legacyLoanInterestPaymentSequence != null ? this.legacyLoanInterestPaymentSequence : (this.legacyLoanInterestPaymentSequence = LegacyLoanInterestPaymentSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LegacyLoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LegacyLoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LegacyLoanInterestPaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LegacyLoanInterestPaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LegacyLoanInterestPaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LegacyLoanInterestPaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LegacyLoanInterestPaymentBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LegacyLoanInterestPaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LegacyLoanInterestPaymentBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LegacyLoanInterestPaymentBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LegacyLoanInterestPaymentBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public LegacyLoanInterestPaymentBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public LegacyLoanInterestPaymentBuilder setCalculationMethod(InterestCalculationMethodEnum _calculationMethod) {
            this.calculationMethod = _calculationMethod == null ? null : _calculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LegacyLoanInterestPaymentBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyLoanInterestPaymentSequence")
        @RuneAttribute(value="legacyLoanInterestPaymentSequence")
        public LegacyLoanInterestPaymentBuilder setLegacyLoanInterestPaymentSequence(LegacyLoanInterestPaymentSequence _legacyLoanInterestPaymentSequence) {
            this.legacyLoanInterestPaymentSequence = _legacyLoanInterestPaymentSequence == null ? null : _legacyLoanInterestPaymentSequence.toBuilder();
            return this;
        }

        @Override
        public LegacyLoanInterestPayment build() {
            return new LegacyLoanInterestPaymentImpl(this);
        }

        @Override
        public LegacyLoanInterestPaymentBuilder toBuilder() {
            return this;
        }

        @Override
        public LegacyLoanInterestPaymentBuilder prune() {
            super.prune();
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.legacyLoanInterestPaymentSequence != null && !this.legacyLoanInterestPaymentSequence.prune().hasData()) {
                this.legacyLoanInterestPaymentSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getCalculationMethod() != null) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getLegacyLoanInterestPaymentSequence() != null && this.getLegacyLoanInterestPaymentSequence().hasData();
        }

        @Override
        public LegacyLoanInterestPaymentBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LegacyLoanInterestPaymentBuilder o = (LegacyLoanInterestPaymentBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyLoanInterestPaymentSequence(), (RosettaModelObjectBuilder)o.getLegacyLoanInterestPaymentSequence(), this::setLegacyLoanInterestPaymentSequence);
            merger.mergeBasic((Object)this.getCalculationMethod(), (Object)o.getCalculationMethod(), this::setCalculationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegacyLoanInterestPayment _that = (LegacyLoanInterestPayment)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.legacyLoanInterestPaymentSequence, _that.getLegacyLoanInterestPaymentSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.legacyLoanInterestPaymentSequence != null ? this.legacyLoanInterestPaymentSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegacyLoanInterestPaymentBuilder {periodModel=" + this.periodModel + ", calculationMethod=" + (Object)((Object)this.calculationMethod) + ", amount=" + this.amount + ", legacyLoanInterestPaymentSequence=" + this.legacyLoanInterestPaymentSequence + '}' + " " + super.toString();
        }
    }

    public static interface LegacyLoanInterestPaymentBuilder
    extends LegacyLoanInterestPayment,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public LegacyLoanInterestPaymentSequence.LegacyLoanInterestPaymentSequenceBuilder getOrCreateLegacyLoanInterestPaymentSequence();

        @Override
        public LegacyLoanInterestPaymentSequence.LegacyLoanInterestPaymentSequenceBuilder getLegacyLoanInterestPaymentSequence();

        @Override
        public LegacyLoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LegacyLoanInterestPaymentBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LegacyLoanInterestPaymentBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setComment(String var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LegacyLoanInterestPaymentBuilder setLoanContractReference(LoanContractReference var1);

        public LegacyLoanInterestPaymentBuilder setPeriodModel(PeriodModel var1);

        public LegacyLoanInterestPaymentBuilder setCalculationMethod(InterestCalculationMethodEnum var1);

        public LegacyLoanInterestPaymentBuilder setAmount(MoneyWithParticipantShare var1);

        public LegacyLoanInterestPaymentBuilder setLegacyLoanInterestPaymentSequence(LegacyLoanInterestPaymentSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyLoanInterestPaymentSequence"), processor, LegacyLoanInterestPaymentSequence.LegacyLoanInterestPaymentSequenceBuilder.class, this.getLegacyLoanInterestPaymentSequence(), new AttributeMeta[0]);
        }

        @Override
        public LegacyLoanInterestPaymentBuilder prune();
    }

    public static class LegacyLoanInterestPaymentImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements LegacyLoanInterestPayment {
        private final PeriodModel periodModel;
        private final InterestCalculationMethodEnum calculationMethod;
        private final MoneyWithParticipantShare amount;
        private final LegacyLoanInterestPaymentSequence legacyLoanInterestPaymentSequence;

        protected LegacyLoanInterestPaymentImpl(LegacyLoanInterestPaymentBuilder builder) {
            super(builder);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.calculationMethod = builder.getCalculationMethod();
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.legacyLoanInterestPaymentSequence = Optional.ofNullable(builder.getLegacyLoanInterestPaymentSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="legacyLoanInterestPaymentSequence")
        @RuneAttribute(value="legacyLoanInterestPaymentSequence")
        public LegacyLoanInterestPaymentSequence getLegacyLoanInterestPaymentSequence() {
            return this.legacyLoanInterestPaymentSequence;
        }

        @Override
        public LegacyLoanInterestPayment build() {
            return this;
        }

        @Override
        public LegacyLoanInterestPaymentBuilder toBuilder() {
            LegacyLoanInterestPaymentBuilder builder = LegacyLoanInterestPayment.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegacyLoanInterestPaymentBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getCalculationMethod()).ifPresent(builder::setCalculationMethod);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getLegacyLoanInterestPaymentSequence()).ifPresent(builder::setLegacyLoanInterestPaymentSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegacyLoanInterestPayment _that = (LegacyLoanInterestPayment)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.legacyLoanInterestPaymentSequence, _that.getLegacyLoanInterestPaymentSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.legacyLoanInterestPaymentSequence != null ? this.legacyLoanInterestPaymentSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegacyLoanInterestPayment {periodModel=" + this.periodModel + ", calculationMethod=" + (Object)((Object)this.calculationMethod) + ", amount=" + this.amount + ", legacyLoanInterestPaymentSequence=" + this.legacyLoanInterestPaymentSequence + '}' + " " + super.toString();
        }
    }
}

