/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AbstractLoanContractEvent;
import fpml.confirmation.AbstractLoanEventSequence;
import fpml.confirmation.BusinessEventIdentifier;
import fpml.confirmation.BusinessEventPartiesModel;
import fpml.confirmation.InterestCalculationMethodEnum;
import fpml.confirmation.LegacyInterestCapitalizationSequence;
import fpml.confirmation.LenderAndCashDetailsModel;
import fpml.confirmation.LoanContractReference;
import fpml.confirmation.LoanLegalActionReference;
import fpml.confirmation.MoneyWithParticipantShare;
import fpml.confirmation.PeriodModel;
import fpml.confirmation.meta.LegacyInterestCapitalizationMeta;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="LegacyInterestCapitalization", builder=LegacyInterestCapitalizationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="LegacyInterestCapitalization", model="fpml", builder=LegacyInterestCapitalizationBuilderImpl.class, version="0.17.2")
public interface LegacyInterestCapitalization
extends AbstractLoanContractEvent {
    public static final LegacyInterestCapitalizationMeta metaData = new LegacyInterestCapitalizationMeta();

    public PeriodModel getPeriodModel();

    public InterestCalculationMethodEnum getCalculationMethod();

    public MoneyWithParticipantShare getAmount();

    public LegacyInterestCapitalizationSequence getLegacyInterestCapitalizationSequence();

    @Override
    public LegacyInterestCapitalization build();

    @Override
    public LegacyInterestCapitalizationBuilder toBuilder();

    public static LegacyInterestCapitalizationBuilder builder() {
        return new LegacyInterestCapitalizationBuilderImpl();
    }

    default public RosettaMetaData<? extends LegacyInterestCapitalization> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends LegacyInterestCapitalization> getType() {
        return LegacyInterestCapitalization.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.class, this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.class, this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.class, this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.class, this.getLegalActionReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.class, this.getLoanContractReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.class, this.getPeriodModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("calculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.class, this.getAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("legacyInterestCapitalizationSequence"), processor, LegacyInterestCapitalizationSequence.class, this.getLegacyInterestCapitalizationSequence(), new AttributeMeta[0]);
    }

    public static class LegacyInterestCapitalizationBuilderImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventBuilderImpl
    implements LegacyInterestCapitalizationBuilder {
        protected PeriodModel.PeriodModelBuilder periodModel;
        protected InterestCalculationMethodEnum calculationMethod;
        protected MoneyWithParticipantShare.MoneyWithParticipantShareBuilder amount;
        protected LegacyInterestCapitalizationSequence.LegacyInterestCapitalizationSequenceBuilder legacyInterestCapitalizationSequence;

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel.PeriodModelBuilder getPeriodModel() {
            return this.periodModel;
        }

        @Override
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel() {
            PeriodModel.PeriodModelBuilder result = this.periodModel != null ? this.periodModel : (this.periodModel = PeriodModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount() {
            return this.amount;
        }

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount() {
            MoneyWithParticipantShare.MoneyWithParticipantShareBuilder result = this.amount != null ? this.amount : (this.amount = MoneyWithParticipantShare.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="legacyInterestCapitalizationSequence")
        @RuneAttribute(value="legacyInterestCapitalizationSequence")
        public LegacyInterestCapitalizationSequence.LegacyInterestCapitalizationSequenceBuilder getLegacyInterestCapitalizationSequence() {
            return this.legacyInterestCapitalizationSequence;
        }

        @Override
        public LegacyInterestCapitalizationSequence.LegacyInterestCapitalizationSequenceBuilder getOrCreateLegacyInterestCapitalizationSequence() {
            LegacyInterestCapitalizationSequence.LegacyInterestCapitalizationSequenceBuilder result = this.legacyInterestCapitalizationSequence != null ? this.legacyInterestCapitalizationSequence : (this.legacyInterestCapitalizationSequence = LegacyInterestCapitalizationSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier", isRequired=true)
        @RuneAttribute(value="eventIdentifier", isRequired=true)
        public LegacyInterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public LegacyInterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public LegacyInterestCapitalizationBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (BusinessEventIdentifier businessEventIdentifier : eventIdentifiers) {
                    this.eventIdentifier.add(businessEventIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public LegacyInterestCapitalizationBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="abstractLoanEventSequence")
        @RuneAttribute(value="abstractLoanEventSequence")
        public LegacyInterestCapitalizationBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence _abstractLoanEventSequence) {
            this.abstractLoanEventSequence = _abstractLoanEventSequence == null ? null : _abstractLoanEventSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lenderAndCashDetailsModel")
        @RuneAttribute(value="lenderAndCashDetailsModel")
        public LegacyInterestCapitalizationBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel _lenderAndCashDetailsModel) {
            this.lenderAndCashDetailsModel = _lenderAndCashDetailsModel == null ? null : _lenderAndCashDetailsModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="comment")
        @RuneAttribute(value="comment")
        public LegacyInterestCapitalizationBuilder setComment(String _comment) {
            this.comment = _comment == null ? null : _comment;
            return this;
        }

        @Override
        @RosettaAttribute(value="businessEventPartiesModel", isRequired=true)
        @RuneAttribute(value="businessEventPartiesModel", isRequired=true)
        public LegacyInterestCapitalizationBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel _businessEventPartiesModel) {
            this.businessEventPartiesModel = _businessEventPartiesModel == null ? null : _businessEventPartiesModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate", isRequired=true)
        @RuneAttribute(value="effectiveDate", isRequired=true)
        public LegacyInterestCapitalizationBuilder setEffectiveDate(ZonedDateTime _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="legalActionReference")
        @RuneAttribute(value="legalActionReference")
        public LegacyInterestCapitalizationBuilder setLegalActionReference(LoanLegalActionReference _legalActionReference) {
            this.legalActionReference = _legalActionReference == null ? null : _legalActionReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="loanContractReference", isRequired=true)
        @RuneAttribute(value="loanContractReference", isRequired=true)
        public LegacyInterestCapitalizationBuilder setLoanContractReference(LoanContractReference _loanContractReference) {
            this.loanContractReference = _loanContractReference == null ? null : _loanContractReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public LegacyInterestCapitalizationBuilder setPeriodModel(PeriodModel _periodModel) {
            this.periodModel = _periodModel == null ? null : _periodModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public LegacyInterestCapitalizationBuilder setCalculationMethod(InterestCalculationMethodEnum _calculationMethod) {
            this.calculationMethod = _calculationMethod == null ? null : _calculationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public LegacyInterestCapitalizationBuilder setAmount(MoneyWithParticipantShare _amount) {
            this.amount = _amount == null ? null : _amount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="legacyInterestCapitalizationSequence")
        @RuneAttribute(value="legacyInterestCapitalizationSequence")
        public LegacyInterestCapitalizationBuilder setLegacyInterestCapitalizationSequence(LegacyInterestCapitalizationSequence _legacyInterestCapitalizationSequence) {
            this.legacyInterestCapitalizationSequence = _legacyInterestCapitalizationSequence == null ? null : _legacyInterestCapitalizationSequence.toBuilder();
            return this;
        }

        @Override
        public LegacyInterestCapitalization build() {
            return new LegacyInterestCapitalizationImpl(this);
        }

        @Override
        public LegacyInterestCapitalizationBuilder toBuilder() {
            return this;
        }

        @Override
        public LegacyInterestCapitalizationBuilder prune() {
            super.prune();
            if (this.periodModel != null && !this.periodModel.prune().hasData()) {
                this.periodModel = null;
            }
            if (this.amount != null && !this.amount.prune().hasData()) {
                this.amount = null;
            }
            if (this.legacyInterestCapitalizationSequence != null && !this.legacyInterestCapitalizationSequence.prune().hasData()) {
                this.legacyInterestCapitalizationSequence = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPeriodModel() != null && this.getPeriodModel().hasData()) {
                return true;
            }
            if (this.getCalculationMethod() != null) {
                return true;
            }
            if (this.getAmount() != null && this.getAmount().hasData()) {
                return true;
            }
            return this.getLegacyInterestCapitalizationSequence() != null && this.getLegacyInterestCapitalizationSequence().hasData();
        }

        @Override
        public LegacyInterestCapitalizationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            LegacyInterestCapitalizationBuilder o = (LegacyInterestCapitalizationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPeriodModel(), (RosettaModelObjectBuilder)o.getPeriodModel(), this::setPeriodModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmount(), (RosettaModelObjectBuilder)o.getAmount(), this::setAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLegacyInterestCapitalizationSequence(), (RosettaModelObjectBuilder)o.getLegacyInterestCapitalizationSequence(), this::setLegacyInterestCapitalizationSequence);
            merger.mergeBasic((Object)this.getCalculationMethod(), (Object)o.getCalculationMethod(), this::setCalculationMethod, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegacyInterestCapitalization _that = (LegacyInterestCapitalization)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.legacyInterestCapitalizationSequence, _that.getLegacyInterestCapitalizationSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.legacyInterestCapitalizationSequence != null ? this.legacyInterestCapitalizationSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegacyInterestCapitalizationBuilder {periodModel=" + this.periodModel + ", calculationMethod=" + (Object)((Object)this.calculationMethod) + ", amount=" + this.amount + ", legacyInterestCapitalizationSequence=" + this.legacyInterestCapitalizationSequence + '}' + " " + super.toString();
        }
    }

    public static interface LegacyInterestCapitalizationBuilder
    extends LegacyInterestCapitalization,
    AbstractLoanContractEvent.AbstractLoanContractEventBuilder {
        public PeriodModel.PeriodModelBuilder getOrCreatePeriodModel();

        @Override
        public PeriodModel.PeriodModelBuilder getPeriodModel();

        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getOrCreateAmount();

        @Override
        public MoneyWithParticipantShare.MoneyWithParticipantShareBuilder getAmount();

        public LegacyInterestCapitalizationSequence.LegacyInterestCapitalizationSequenceBuilder getOrCreateLegacyInterestCapitalizationSequence();

        @Override
        public LegacyInterestCapitalizationSequence.LegacyInterestCapitalizationSequenceBuilder getLegacyInterestCapitalizationSequence();

        @Override
        public LegacyInterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier var1);

        @Override
        public LegacyInterestCapitalizationBuilder addEventIdentifier(BusinessEventIdentifier var1, int var2);

        @Override
        public LegacyInterestCapitalizationBuilder addEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LegacyInterestCapitalizationBuilder setEventIdentifier(List<? extends BusinessEventIdentifier> var1);

        @Override
        public LegacyInterestCapitalizationBuilder setAbstractLoanEventSequence(AbstractLoanEventSequence var1);

        @Override
        public LegacyInterestCapitalizationBuilder setLenderAndCashDetailsModel(LenderAndCashDetailsModel var1);

        @Override
        public LegacyInterestCapitalizationBuilder setComment(String var1);

        @Override
        public LegacyInterestCapitalizationBuilder setBusinessEventPartiesModel(BusinessEventPartiesModel var1);

        @Override
        public LegacyInterestCapitalizationBuilder setEffectiveDate(ZonedDateTime var1);

        @Override
        public LegacyInterestCapitalizationBuilder setLegalActionReference(LoanLegalActionReference var1);

        @Override
        public LegacyInterestCapitalizationBuilder setLoanContractReference(LoanContractReference var1);

        public LegacyInterestCapitalizationBuilder setPeriodModel(PeriodModel var1);

        public LegacyInterestCapitalizationBuilder setCalculationMethod(InterestCalculationMethodEnum var1);

        public LegacyInterestCapitalizationBuilder setAmount(MoneyWithParticipantShare var1);

        public LegacyInterestCapitalizationBuilder setLegacyInterestCapitalizationSequence(LegacyInterestCapitalizationSequence var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, BusinessEventIdentifier.BusinessEventIdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("abstractLoanEventSequence"), processor, AbstractLoanEventSequence.AbstractLoanEventSequenceBuilder.class, (RosettaModelObjectBuilder)this.getAbstractLoanEventSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lenderAndCashDetailsModel"), processor, LenderAndCashDetailsModel.LenderAndCashDetailsModelBuilder.class, (RosettaModelObjectBuilder)this.getLenderAndCashDetailsModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("comment"), String.class, (Object)this.getComment(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("businessEventPartiesModel"), processor, BusinessEventPartiesModel.BusinessEventPartiesModelBuilder.class, (RosettaModelObjectBuilder)this.getBusinessEventPartiesModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("effectiveDate"), ZonedDateTime.class, (Object)this.getEffectiveDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legalActionReference"), processor, LoanLegalActionReference.LoanLegalActionReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLegalActionReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("loanContractReference"), processor, LoanContractReference.LoanContractReferenceBuilder.class, (RosettaModelObjectBuilder)this.getLoanContractReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("periodModel"), processor, PeriodModel.PeriodModelBuilder.class, this.getPeriodModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("calculationMethod"), InterestCalculationMethodEnum.class, (Object)this.getCalculationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("amount"), processor, MoneyWithParticipantShare.MoneyWithParticipantShareBuilder.class, this.getAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("legacyInterestCapitalizationSequence"), processor, LegacyInterestCapitalizationSequence.LegacyInterestCapitalizationSequenceBuilder.class, this.getLegacyInterestCapitalizationSequence(), new AttributeMeta[0]);
        }

        @Override
        public LegacyInterestCapitalizationBuilder prune();
    }

    public static class LegacyInterestCapitalizationImpl
    extends AbstractLoanContractEvent.AbstractLoanContractEventImpl
    implements LegacyInterestCapitalization {
        private final PeriodModel periodModel;
        private final InterestCalculationMethodEnum calculationMethod;
        private final MoneyWithParticipantShare amount;
        private final LegacyInterestCapitalizationSequence legacyInterestCapitalizationSequence;

        protected LegacyInterestCapitalizationImpl(LegacyInterestCapitalizationBuilder builder) {
            super(builder);
            this.periodModel = Optional.ofNullable(builder.getPeriodModel()).map(f -> f.build()).orElse(null);
            this.calculationMethod = builder.getCalculationMethod();
            this.amount = Optional.ofNullable(builder.getAmount()).map(f -> f.build()).orElse(null);
            this.legacyInterestCapitalizationSequence = Optional.ofNullable(builder.getLegacyInterestCapitalizationSequence()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="periodModel", isRequired=true)
        @RuneAttribute(value="periodModel", isRequired=true)
        public PeriodModel getPeriodModel() {
            return this.periodModel;
        }

        @Override
        @RosettaAttribute(value="calculationMethod", isRequired=true)
        @RuneAttribute(value="calculationMethod", isRequired=true)
        public InterestCalculationMethodEnum getCalculationMethod() {
            return this.calculationMethod;
        }

        @Override
        @RosettaAttribute(value="amount", isRequired=true)
        @RuneAttribute(value="amount", isRequired=true)
        public MoneyWithParticipantShare getAmount() {
            return this.amount;
        }

        @Override
        @RosettaAttribute(value="legacyInterestCapitalizationSequence")
        @RuneAttribute(value="legacyInterestCapitalizationSequence")
        public LegacyInterestCapitalizationSequence getLegacyInterestCapitalizationSequence() {
            return this.legacyInterestCapitalizationSequence;
        }

        @Override
        public LegacyInterestCapitalization build() {
            return this;
        }

        @Override
        public LegacyInterestCapitalizationBuilder toBuilder() {
            LegacyInterestCapitalizationBuilder builder = LegacyInterestCapitalization.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(LegacyInterestCapitalizationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPeriodModel()).ifPresent(builder::setPeriodModel);
            Optional.ofNullable(this.getCalculationMethod()).ifPresent(builder::setCalculationMethod);
            Optional.ofNullable(this.getAmount()).ifPresent(builder::setAmount);
            Optional.ofNullable(this.getLegacyInterestCapitalizationSequence()).ifPresent(builder::setLegacyInterestCapitalizationSequence);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            LegacyInterestCapitalization _that = (LegacyInterestCapitalization)this.getType().cast(o);
            if (!Objects.equals(this.periodModel, _that.getPeriodModel())) {
                return false;
            }
            if (!Objects.equals((Object)this.calculationMethod, (Object)_that.getCalculationMethod())) {
                return false;
            }
            if (!Objects.equals(this.amount, _that.getAmount())) {
                return false;
            }
            return Objects.equals(this.legacyInterestCapitalizationSequence, _that.getLegacyInterestCapitalizationSequence());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.periodModel != null ? this.periodModel.hashCode() : 0);
            _result = 31 * _result + (this.calculationMethod != null ? ((Object)((Object)this.calculationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.amount != null ? this.amount.hashCode() : 0);
            _result = 31 * _result + (this.legacyInterestCapitalizationSequence != null ? this.legacyInterestCapitalizationSequence.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "LegacyInterestCapitalization {periodModel=" + this.periodModel + ", calculationMethod=" + (Object)((Object)this.calculationMethod) + ", amount=" + this.amount + ", legacyInterestCapitalizationSequence=" + this.legacyInterestCapitalizationSequence + '}' + " " + super.toString();
        }
    }
}

