/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.BusinessCenterTime;
import fpml.confirmation.InformationSource;
import fpml.confirmation.NonNegativePayment;
import fpml.confirmation.TriggerConditionEnum;
import fpml.confirmation.TriggerRateObservation;
import fpml.confirmation.TriggerRateObservationSequence0;
import fpml.confirmation.TriggerRateObservationSequence1;
import fpml.confirmation.meta.KnockOutRateObservationMeta;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="KnockOutRateObservation", builder=KnockOutRateObservationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="KnockOutRateObservation", model="fpml", builder=KnockOutRateObservationBuilderImpl.class, version="0.17.2")
public interface KnockOutRateObservation
extends TriggerRateObservation {
    public static final KnockOutRateObservationMeta metaData = new KnockOutRateObservationMeta();

    public NonNegativePayment getRebatePayment();

    @Override
    public KnockOutRateObservation build();

    @Override
    public KnockOutRateObservationBuilder toBuilder();

    public static KnockOutRateObservationBuilder builder() {
        return new KnockOutRateObservationBuilderImpl();
    }

    default public RosettaMetaData<? extends KnockOutRateObservation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends KnockOutRateObservation> getType() {
        return KnockOutRateObservation.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("observationDate"), ZonedDateTime.class, (Object)this.getObservationDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("observationTime"), processor, BusinessCenterTime.class, this.getObservationTime(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.class, this.getInformationSource(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("triggerRateObservationSequence0"), processor, TriggerRateObservationSequence0.class, this.getTriggerRateObservationSequence0(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("triggerRateObservationSequence1"), processor, TriggerRateObservationSequence1.class, this.getTriggerRateObservationSequence1(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("rebatePayment"), processor, NonNegativePayment.class, this.getRebatePayment(), new AttributeMeta[0]);
    }

    public static class KnockOutRateObservationBuilderImpl
    extends TriggerRateObservation.TriggerRateObservationBuilderImpl
    implements KnockOutRateObservationBuilder {
        protected NonNegativePayment.NonNegativePaymentBuilder rebatePayment;

        @Override
        @RosettaAttribute(value="rebatePayment")
        @RuneAttribute(value="rebatePayment")
        public NonNegativePayment.NonNegativePaymentBuilder getRebatePayment() {
            return this.rebatePayment;
        }

        @Override
        public NonNegativePayment.NonNegativePaymentBuilder getOrCreateRebatePayment() {
            NonNegativePayment.NonNegativePaymentBuilder result = this.rebatePayment != null ? this.rebatePayment : (this.rebatePayment = NonNegativePayment.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="observationDate", isRequired=true)
        @RuneAttribute(value="observationDate", isRequired=true)
        public KnockOutRateObservationBuilder setObservationDate(ZonedDateTime _observationDate) {
            this.observationDate = _observationDate == null ? null : _observationDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="observationTime")
        @RuneAttribute(value="observationTime")
        public KnockOutRateObservationBuilder setObservationTime(BusinessCenterTime _observationTime) {
            this.observationTime = _observationTime == null ? null : _observationTime.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="informationSource")
        @RuneAttribute(value="informationSource")
        public KnockOutRateObservationBuilder setInformationSource(InformationSource _informationSource) {
            this.informationSource = _informationSource == null ? null : _informationSource.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerRateObservationSequence0")
        @RuneAttribute(value="triggerRateObservationSequence0")
        public KnockOutRateObservationBuilder setTriggerRateObservationSequence0(TriggerRateObservationSequence0 _triggerRateObservationSequence0) {
            this.triggerRateObservationSequence0 = _triggerRateObservationSequence0 == null ? null : _triggerRateObservationSequence0.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerRateObservationSequence1")
        @RuneAttribute(value="triggerRateObservationSequence1")
        public KnockOutRateObservationBuilder setTriggerRateObservationSequence1(TriggerRateObservationSequence1 _triggerRateObservationSequence1) {
            this.triggerRateObservationSequence1 = _triggerRateObservationSequence1 == null ? null : _triggerRateObservationSequence1.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="triggerCondition", isRequired=true)
        @RuneAttribute(value="triggerCondition", isRequired=true)
        public KnockOutRateObservationBuilder setTriggerCondition(TriggerConditionEnum _triggerCondition) {
            this.triggerCondition = _triggerCondition == null ? null : _triggerCondition;
            return this;
        }

        @Override
        @RosettaAttribute(value="rebatePayment")
        @RuneAttribute(value="rebatePayment")
        public KnockOutRateObservationBuilder setRebatePayment(NonNegativePayment _rebatePayment) {
            this.rebatePayment = _rebatePayment == null ? null : _rebatePayment.toBuilder();
            return this;
        }

        @Override
        public KnockOutRateObservation build() {
            return new KnockOutRateObservationImpl(this);
        }

        @Override
        public KnockOutRateObservationBuilder toBuilder() {
            return this;
        }

        @Override
        public KnockOutRateObservationBuilder prune() {
            super.prune();
            if (this.rebatePayment != null && !this.rebatePayment.prune().hasData()) {
                this.rebatePayment = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getRebatePayment() != null && this.getRebatePayment().hasData();
        }

        @Override
        public KnockOutRateObservationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            KnockOutRateObservationBuilder o = (KnockOutRateObservationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRebatePayment(), (RosettaModelObjectBuilder)o.getRebatePayment(), this::setRebatePayment);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            KnockOutRateObservation _that = (KnockOutRateObservation)this.getType().cast(o);
            return Objects.equals(this.rebatePayment, _that.getRebatePayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rebatePayment != null ? this.rebatePayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "KnockOutRateObservationBuilder {rebatePayment=" + this.rebatePayment + '}' + " " + super.toString();
        }
    }

    public static interface KnockOutRateObservationBuilder
    extends KnockOutRateObservation,
    TriggerRateObservation.TriggerRateObservationBuilder {
        public NonNegativePayment.NonNegativePaymentBuilder getOrCreateRebatePayment();

        @Override
        public NonNegativePayment.NonNegativePaymentBuilder getRebatePayment();

        @Override
        public KnockOutRateObservationBuilder setObservationDate(ZonedDateTime var1);

        @Override
        public KnockOutRateObservationBuilder setObservationTime(BusinessCenterTime var1);

        @Override
        public KnockOutRateObservationBuilder setInformationSource(InformationSource var1);

        @Override
        public KnockOutRateObservationBuilder setTriggerRateObservationSequence0(TriggerRateObservationSequence0 var1);

        @Override
        public KnockOutRateObservationBuilder setTriggerRateObservationSequence1(TriggerRateObservationSequence1 var1);

        @Override
        public KnockOutRateObservationBuilder setTriggerCondition(TriggerConditionEnum var1);

        public KnockOutRateObservationBuilder setRebatePayment(NonNegativePayment var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("observationDate"), ZonedDateTime.class, (Object)this.getObservationDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("observationTime"), processor, BusinessCenterTime.BusinessCenterTimeBuilder.class, (RosettaModelObjectBuilder)this.getObservationTime(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("informationSource"), processor, InformationSource.InformationSourceBuilder.class, (RosettaModelObjectBuilder)this.getInformationSource(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("triggerRateObservationSequence0"), processor, TriggerRateObservationSequence0.TriggerRateObservationSequence0Builder.class, (RosettaModelObjectBuilder)this.getTriggerRateObservationSequence0(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("triggerRateObservationSequence1"), processor, TriggerRateObservationSequence1.TriggerRateObservationSequence1Builder.class, (RosettaModelObjectBuilder)this.getTriggerRateObservationSequence1(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("triggerCondition"), TriggerConditionEnum.class, (Object)this.getTriggerCondition(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("rebatePayment"), processor, NonNegativePayment.NonNegativePaymentBuilder.class, this.getRebatePayment(), new AttributeMeta[0]);
        }

        @Override
        public KnockOutRateObservationBuilder prune();
    }

    public static class KnockOutRateObservationImpl
    extends TriggerRateObservation.TriggerRateObservationImpl
    implements KnockOutRateObservation {
        private final NonNegativePayment rebatePayment;

        protected KnockOutRateObservationImpl(KnockOutRateObservationBuilder builder) {
            super(builder);
            this.rebatePayment = Optional.ofNullable(builder.getRebatePayment()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="rebatePayment")
        @RuneAttribute(value="rebatePayment")
        public NonNegativePayment getRebatePayment() {
            return this.rebatePayment;
        }

        @Override
        public KnockOutRateObservation build() {
            return this;
        }

        @Override
        public KnockOutRateObservationBuilder toBuilder() {
            KnockOutRateObservationBuilder builder = KnockOutRateObservation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(KnockOutRateObservationBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getRebatePayment()).ifPresent(builder::setRebatePayment);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            KnockOutRateObservation _that = (KnockOutRateObservation)this.getType().cast(o);
            return Objects.equals(this.rebatePayment, _that.getRebatePayment());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.rebatePayment != null ? this.rebatePayment.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "KnockOutRateObservation {rebatePayment=" + this.rebatePayment + '}' + " " + super.toString();
        }
    }
}

