/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.FxExchangedCurrencyModel;
import fpml.confirmation.FxPayoffCap;
import fpml.confirmation.FxStrike;
import fpml.confirmation.FxTargetLeverage;
import fpml.confirmation.FxTargetPayoffRegion;
import fpml.confirmation.FxTargetRegionLowerBound;
import fpml.confirmation.FxTargetRegionUpperBound;
import fpml.confirmation.NonNegativeAmountSchedule;
import fpml.confirmation.meta.FxTargetLinearPayoffRegionMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxTargetLinearPayoffRegion", builder=FxTargetLinearPayoffRegionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxTargetLinearPayoffRegion", model="fpml", builder=FxTargetLinearPayoffRegionBuilderImpl.class, version="0.17.2")
public interface FxTargetLinearPayoffRegion
extends FxTargetPayoffRegion {
    public static final FxTargetLinearPayoffRegionMeta metaData = new FxTargetLinearPayoffRegionMeta();

    public FxExchangedCurrencyModel getFxExchangedCurrencyModel();

    public FxStrike getStrike();

    public NonNegativeAmountSchedule getCounterCurrencyAmount();

    public FxTargetRegionLowerBound getLowerBound();

    public FxTargetRegionUpperBound getUpperBound();

    public FxTargetLeverage getLeverage();

    public List<? extends FxPayoffCap> getPayoffCap();

    @Override
    public FxTargetLinearPayoffRegion build();

    @Override
    public FxTargetLinearPayoffRegionBuilder toBuilder();

    public static FxTargetLinearPayoffRegionBuilder builder() {
        return new FxTargetLinearPayoffRegionBuilderImpl();
    }

    default public RosettaMetaData<? extends FxTargetLinearPayoffRegion> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxTargetLinearPayoffRegion> getType() {
        return FxTargetLinearPayoffRegion.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxExchangedCurrencyModel"), processor, FxExchangedCurrencyModel.class, this.getFxExchangedCurrencyModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, FxStrike.class, this.getStrike(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, NonNegativeAmountSchedule.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lowerBound"), processor, FxTargetRegionLowerBound.class, this.getLowerBound(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("upperBound"), processor, FxTargetRegionUpperBound.class, this.getUpperBound(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("leverage"), processor, FxTargetLeverage.class, this.getLeverage(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("payoffCap"), processor, FxPayoffCap.class, this.getPayoffCap(), new AttributeMeta[0]);
    }

    public static class FxTargetLinearPayoffRegionBuilderImpl
    extends FxTargetPayoffRegion.FxTargetPayoffRegionBuilderImpl
    implements FxTargetLinearPayoffRegionBuilder {
        protected FxExchangedCurrencyModel.FxExchangedCurrencyModelBuilder fxExchangedCurrencyModel;
        protected FxStrike.FxStrikeBuilder strike;
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder counterCurrencyAmount;
        protected FxTargetRegionLowerBound.FxTargetRegionLowerBoundBuilder lowerBound;
        protected FxTargetRegionUpperBound.FxTargetRegionUpperBoundBuilder upperBound;
        protected FxTargetLeverage.FxTargetLeverageBuilder leverage;
        protected List<FxPayoffCap.FxPayoffCapBuilder> payoffCap = new ArrayList<FxPayoffCap.FxPayoffCapBuilder>();

        @Override
        @RosettaAttribute(value="fxExchangedCurrencyModel", isRequired=true)
        @RuneAttribute(value="fxExchangedCurrencyModel", isRequired=true)
        public FxExchangedCurrencyModel.FxExchangedCurrencyModelBuilder getFxExchangedCurrencyModel() {
            return this.fxExchangedCurrencyModel;
        }

        @Override
        public FxExchangedCurrencyModel.FxExchangedCurrencyModelBuilder getOrCreateFxExchangedCurrencyModel() {
            FxExchangedCurrencyModel.FxExchangedCurrencyModelBuilder result = this.fxExchangedCurrencyModel != null ? this.fxExchangedCurrencyModel : (this.fxExchangedCurrencyModel = FxExchangedCurrencyModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxStrike.FxStrikeBuilder getStrike() {
            return this.strike;
        }

        @Override
        public FxStrike.FxStrikeBuilder getOrCreateStrike() {
            FxStrike.FxStrikeBuilder result = this.strike != null ? this.strike : (this.strike = FxStrike.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateCounterCurrencyAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.counterCurrencyAmount != null ? this.counterCurrencyAmount : (this.counterCurrencyAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="lowerBound")
        @RuneAttribute(value="lowerBound")
        public FxTargetRegionLowerBound.FxTargetRegionLowerBoundBuilder getLowerBound() {
            return this.lowerBound;
        }

        @Override
        public FxTargetRegionLowerBound.FxTargetRegionLowerBoundBuilder getOrCreateLowerBound() {
            FxTargetRegionLowerBound.FxTargetRegionLowerBoundBuilder result = this.lowerBound != null ? this.lowerBound : (this.lowerBound = FxTargetRegionLowerBound.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="upperBound")
        @RuneAttribute(value="upperBound")
        public FxTargetRegionUpperBound.FxTargetRegionUpperBoundBuilder getUpperBound() {
            return this.upperBound;
        }

        @Override
        public FxTargetRegionUpperBound.FxTargetRegionUpperBoundBuilder getOrCreateUpperBound() {
            FxTargetRegionUpperBound.FxTargetRegionUpperBoundBuilder result = this.upperBound != null ? this.upperBound : (this.upperBound = FxTargetRegionUpperBound.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="leverage")
        @RuneAttribute(value="leverage")
        public FxTargetLeverage.FxTargetLeverageBuilder getLeverage() {
            return this.leverage;
        }

        @Override
        public FxTargetLeverage.FxTargetLeverageBuilder getOrCreateLeverage() {
            FxTargetLeverage.FxTargetLeverageBuilder result = this.leverage != null ? this.leverage : (this.leverage = FxTargetLeverage.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="payoffCap")
        @RuneAttribute(value="payoffCap")
        public List<? extends FxPayoffCap.FxPayoffCapBuilder> getPayoffCap() {
            return this.payoffCap;
        }

        @Override
        public FxPayoffCap.FxPayoffCapBuilder getOrCreatePayoffCap(int index) {
            if (this.payoffCap == null) {
                this.payoffCap = new ArrayList<FxPayoffCap.FxPayoffCapBuilder>();
            }
            return (FxPayoffCap.FxPayoffCapBuilder)this.getIndex(this.payoffCap, index, () -> {
                FxPayoffCap.FxPayoffCapBuilder newPayoffCap = FxPayoffCap.builder();
                return newPayoffCap;
            });
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxTargetLinearPayoffRegionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxExchangedCurrencyModel", isRequired=true)
        @RuneAttribute(value="fxExchangedCurrencyModel", isRequired=true)
        public FxTargetLinearPayoffRegionBuilder setFxExchangedCurrencyModel(FxExchangedCurrencyModel _fxExchangedCurrencyModel) {
            this.fxExchangedCurrencyModel = _fxExchangedCurrencyModel == null ? null : _fxExchangedCurrencyModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxTargetLinearPayoffRegionBuilder setStrike(FxStrike _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public FxTargetLinearPayoffRegionBuilder setCounterCurrencyAmount(NonNegativeAmountSchedule _counterCurrencyAmount) {
            this.counterCurrencyAmount = _counterCurrencyAmount == null ? null : _counterCurrencyAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="lowerBound")
        @RuneAttribute(value="lowerBound")
        public FxTargetLinearPayoffRegionBuilder setLowerBound(FxTargetRegionLowerBound _lowerBound) {
            this.lowerBound = _lowerBound == null ? null : _lowerBound.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="upperBound")
        @RuneAttribute(value="upperBound")
        public FxTargetLinearPayoffRegionBuilder setUpperBound(FxTargetRegionUpperBound _upperBound) {
            this.upperBound = _upperBound == null ? null : _upperBound.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="leverage")
        @RuneAttribute(value="leverage")
        public FxTargetLinearPayoffRegionBuilder setLeverage(FxTargetLeverage _leverage) {
            this.leverage = _leverage == null ? null : _leverage.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="payoffCap")
        @RuneAttribute(value="payoffCap")
        public FxTargetLinearPayoffRegionBuilder addPayoffCap(FxPayoffCap _payoffCap) {
            if (_payoffCap != null) {
                this.payoffCap.add(_payoffCap.toBuilder());
            }
            return this;
        }

        @Override
        public FxTargetLinearPayoffRegionBuilder addPayoffCap(FxPayoffCap _payoffCap, int idx) {
            this.getIndex(this.payoffCap, idx, () -> _payoffCap.toBuilder());
            return this;
        }

        @Override
        public FxTargetLinearPayoffRegionBuilder addPayoffCap(List<? extends FxPayoffCap> payoffCaps) {
            if (payoffCaps != null) {
                for (FxPayoffCap fxPayoffCap : payoffCaps) {
                    this.payoffCap.add(fxPayoffCap.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="payoffCap")
        public FxTargetLinearPayoffRegionBuilder setPayoffCap(List<? extends FxPayoffCap> payoffCaps) {
            this.payoffCap = payoffCaps == null ? new ArrayList<FxPayoffCap.FxPayoffCapBuilder>() : (List)payoffCaps.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxTargetLinearPayoffRegion build() {
            return new FxTargetLinearPayoffRegionImpl(this);
        }

        @Override
        public FxTargetLinearPayoffRegionBuilder toBuilder() {
            return this;
        }

        @Override
        public FxTargetLinearPayoffRegionBuilder prune() {
            super.prune();
            if (this.fxExchangedCurrencyModel != null && !this.fxExchangedCurrencyModel.prune().hasData()) {
                this.fxExchangedCurrencyModel = null;
            }
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            if (this.counterCurrencyAmount != null && !this.counterCurrencyAmount.prune().hasData()) {
                this.counterCurrencyAmount = null;
            }
            if (this.lowerBound != null && !this.lowerBound.prune().hasData()) {
                this.lowerBound = null;
            }
            if (this.upperBound != null && !this.upperBound.prune().hasData()) {
                this.upperBound = null;
            }
            if (this.leverage != null && !this.leverage.prune().hasData()) {
                this.leverage = null;
            }
            this.payoffCap = this.payoffCap.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getFxExchangedCurrencyModel() != null && this.getFxExchangedCurrencyModel().hasData()) {
                return true;
            }
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            if (this.getCounterCurrencyAmount() != null && this.getCounterCurrencyAmount().hasData()) {
                return true;
            }
            if (this.getLowerBound() != null && this.getLowerBound().hasData()) {
                return true;
            }
            if (this.getUpperBound() != null && this.getUpperBound().hasData()) {
                return true;
            }
            if (this.getLeverage() != null && this.getLeverage().hasData()) {
                return true;
            }
            return this.getPayoffCap() != null && this.getPayoffCap().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxTargetLinearPayoffRegionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxTargetLinearPayoffRegionBuilder o = (FxTargetLinearPayoffRegionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxExchangedCurrencyModel(), (RosettaModelObjectBuilder)o.getFxExchangedCurrencyModel(), this::setFxExchangedCurrencyModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCounterCurrencyAmount(), (RosettaModelObjectBuilder)o.getCounterCurrencyAmount(), this::setCounterCurrencyAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLowerBound(), (RosettaModelObjectBuilder)o.getLowerBound(), this::setLowerBound);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUpperBound(), (RosettaModelObjectBuilder)o.getUpperBound(), this::setUpperBound);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLeverage(), (RosettaModelObjectBuilder)o.getLeverage(), this::setLeverage);
            merger.mergeRosetta(this.getPayoffCap(), o.getPayoffCap(), this::getOrCreatePayoffCap);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTargetLinearPayoffRegion _that = (FxTargetLinearPayoffRegion)this.getType().cast(o);
            if (!Objects.equals(this.fxExchangedCurrencyModel, _that.getFxExchangedCurrencyModel())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount())) {
                return false;
            }
            if (!Objects.equals(this.lowerBound, _that.getLowerBound())) {
                return false;
            }
            if (!Objects.equals(this.upperBound, _that.getUpperBound())) {
                return false;
            }
            if (!Objects.equals(this.leverage, _that.getLeverage())) {
                return false;
            }
            return ListEquals.listEquals(this.payoffCap, _that.getPayoffCap());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fxExchangedCurrencyModel != null ? this.fxExchangedCurrencyModel.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            _result = 31 * _result + (this.lowerBound != null ? this.lowerBound.hashCode() : 0);
            _result = 31 * _result + (this.upperBound != null ? this.upperBound.hashCode() : 0);
            _result = 31 * _result + (this.leverage != null ? this.leverage.hashCode() : 0);
            _result = 31 * _result + (this.payoffCap != null ? this.payoffCap.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTargetLinearPayoffRegionBuilder {fxExchangedCurrencyModel=" + this.fxExchangedCurrencyModel + ", strike=" + this.strike + ", counterCurrencyAmount=" + this.counterCurrencyAmount + ", lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", leverage=" + this.leverage + ", payoffCap=" + this.payoffCap + '}' + " " + super.toString();
        }
    }

    public static interface FxTargetLinearPayoffRegionBuilder
    extends FxTargetLinearPayoffRegion,
    FxTargetPayoffRegion.FxTargetPayoffRegionBuilder {
        public FxExchangedCurrencyModel.FxExchangedCurrencyModelBuilder getOrCreateFxExchangedCurrencyModel();

        @Override
        public FxExchangedCurrencyModel.FxExchangedCurrencyModelBuilder getFxExchangedCurrencyModel();

        public FxStrike.FxStrikeBuilder getOrCreateStrike();

        @Override
        public FxStrike.FxStrikeBuilder getStrike();

        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateCounterCurrencyAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getCounterCurrencyAmount();

        public FxTargetRegionLowerBound.FxTargetRegionLowerBoundBuilder getOrCreateLowerBound();

        @Override
        public FxTargetRegionLowerBound.FxTargetRegionLowerBoundBuilder getLowerBound();

        public FxTargetRegionUpperBound.FxTargetRegionUpperBoundBuilder getOrCreateUpperBound();

        @Override
        public FxTargetRegionUpperBound.FxTargetRegionUpperBoundBuilder getUpperBound();

        public FxTargetLeverage.FxTargetLeverageBuilder getOrCreateLeverage();

        @Override
        public FxTargetLeverage.FxTargetLeverageBuilder getLeverage();

        public FxPayoffCap.FxPayoffCapBuilder getOrCreatePayoffCap(int var1);

        public List<? extends FxPayoffCap.FxPayoffCapBuilder> getPayoffCap();

        @Override
        public FxTargetLinearPayoffRegionBuilder setId(String var1);

        public FxTargetLinearPayoffRegionBuilder setFxExchangedCurrencyModel(FxExchangedCurrencyModel var1);

        public FxTargetLinearPayoffRegionBuilder setStrike(FxStrike var1);

        public FxTargetLinearPayoffRegionBuilder setCounterCurrencyAmount(NonNegativeAmountSchedule var1);

        public FxTargetLinearPayoffRegionBuilder setLowerBound(FxTargetRegionLowerBound var1);

        public FxTargetLinearPayoffRegionBuilder setUpperBound(FxTargetRegionUpperBound var1);

        public FxTargetLinearPayoffRegionBuilder setLeverage(FxTargetLeverage var1);

        public FxTargetLinearPayoffRegionBuilder addPayoffCap(FxPayoffCap var1);

        public FxTargetLinearPayoffRegionBuilder addPayoffCap(FxPayoffCap var1, int var2);

        public FxTargetLinearPayoffRegionBuilder addPayoffCap(List<? extends FxPayoffCap> var1);

        public FxTargetLinearPayoffRegionBuilder setPayoffCap(List<? extends FxPayoffCap> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxExchangedCurrencyModel"), processor, FxExchangedCurrencyModel.FxExchangedCurrencyModelBuilder.class, this.getFxExchangedCurrencyModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, FxStrike.FxStrikeBuilder.class, this.getStrike(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("counterCurrencyAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getCounterCurrencyAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lowerBound"), processor, FxTargetRegionLowerBound.FxTargetRegionLowerBoundBuilder.class, this.getLowerBound(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("upperBound"), processor, FxTargetRegionUpperBound.FxTargetRegionUpperBoundBuilder.class, this.getUpperBound(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("leverage"), processor, FxTargetLeverage.FxTargetLeverageBuilder.class, this.getLeverage(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("payoffCap"), processor, FxPayoffCap.FxPayoffCapBuilder.class, this.getPayoffCap(), new AttributeMeta[0]);
        }

        @Override
        public FxTargetLinearPayoffRegionBuilder prune();
    }

    public static class FxTargetLinearPayoffRegionImpl
    extends FxTargetPayoffRegion.FxTargetPayoffRegionImpl
    implements FxTargetLinearPayoffRegion {
        private final FxExchangedCurrencyModel fxExchangedCurrencyModel;
        private final FxStrike strike;
        private final NonNegativeAmountSchedule counterCurrencyAmount;
        private final FxTargetRegionLowerBound lowerBound;
        private final FxTargetRegionUpperBound upperBound;
        private final FxTargetLeverage leverage;
        private final List<? extends FxPayoffCap> payoffCap;

        protected FxTargetLinearPayoffRegionImpl(FxTargetLinearPayoffRegionBuilder builder) {
            super(builder);
            this.fxExchangedCurrencyModel = Optional.ofNullable(builder.getFxExchangedCurrencyModel()).map(f -> f.build()).orElse(null);
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.counterCurrencyAmount = Optional.ofNullable(builder.getCounterCurrencyAmount()).map(f -> f.build()).orElse(null);
            this.lowerBound = Optional.ofNullable(builder.getLowerBound()).map(f -> f.build()).orElse(null);
            this.upperBound = Optional.ofNullable(builder.getUpperBound()).map(f -> f.build()).orElse(null);
            this.leverage = Optional.ofNullable(builder.getLeverage()).map(f -> f.build()).orElse(null);
            this.payoffCap = Optional.ofNullable(builder.getPayoffCap()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="fxExchangedCurrencyModel", isRequired=true)
        @RuneAttribute(value="fxExchangedCurrencyModel", isRequired=true)
        public FxExchangedCurrencyModel getFxExchangedCurrencyModel() {
            return this.fxExchangedCurrencyModel;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxStrike getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="counterCurrencyAmount")
        @RuneAttribute(value="counterCurrencyAmount")
        public NonNegativeAmountSchedule getCounterCurrencyAmount() {
            return this.counterCurrencyAmount;
        }

        @Override
        @RosettaAttribute(value="lowerBound")
        @RuneAttribute(value="lowerBound")
        public FxTargetRegionLowerBound getLowerBound() {
            return this.lowerBound;
        }

        @Override
        @RosettaAttribute(value="upperBound")
        @RuneAttribute(value="upperBound")
        public FxTargetRegionUpperBound getUpperBound() {
            return this.upperBound;
        }

        @Override
        @RosettaAttribute(value="leverage")
        @RuneAttribute(value="leverage")
        public FxTargetLeverage getLeverage() {
            return this.leverage;
        }

        @Override
        @RosettaAttribute(value="payoffCap")
        @RuneAttribute(value="payoffCap")
        public List<? extends FxPayoffCap> getPayoffCap() {
            return this.payoffCap;
        }

        @Override
        public FxTargetLinearPayoffRegion build() {
            return this;
        }

        @Override
        public FxTargetLinearPayoffRegionBuilder toBuilder() {
            FxTargetLinearPayoffRegionBuilder builder = FxTargetLinearPayoffRegion.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxTargetLinearPayoffRegionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getFxExchangedCurrencyModel()).ifPresent(builder::setFxExchangedCurrencyModel);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getCounterCurrencyAmount()).ifPresent(builder::setCounterCurrencyAmount);
            Optional.ofNullable(this.getLowerBound()).ifPresent(builder::setLowerBound);
            Optional.ofNullable(this.getUpperBound()).ifPresent(builder::setUpperBound);
            Optional.ofNullable(this.getLeverage()).ifPresent(builder::setLeverage);
            Optional.ofNullable(this.getPayoffCap()).ifPresent(builder::setPayoffCap);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxTargetLinearPayoffRegion _that = (FxTargetLinearPayoffRegion)this.getType().cast(o);
            if (!Objects.equals(this.fxExchangedCurrencyModel, _that.getFxExchangedCurrencyModel())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.counterCurrencyAmount, _that.getCounterCurrencyAmount())) {
                return false;
            }
            if (!Objects.equals(this.lowerBound, _that.getLowerBound())) {
                return false;
            }
            if (!Objects.equals(this.upperBound, _that.getUpperBound())) {
                return false;
            }
            if (!Objects.equals(this.leverage, _that.getLeverage())) {
                return false;
            }
            return ListEquals.listEquals(this.payoffCap, _that.getPayoffCap());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.fxExchangedCurrencyModel != null ? this.fxExchangedCurrencyModel.hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.counterCurrencyAmount != null ? this.counterCurrencyAmount.hashCode() : 0);
            _result = 31 * _result + (this.lowerBound != null ? this.lowerBound.hashCode() : 0);
            _result = 31 * _result + (this.upperBound != null ? this.upperBound.hashCode() : 0);
            _result = 31 * _result + (this.leverage != null ? this.leverage.hashCode() : 0);
            _result = 31 * _result + (this.payoffCap != null ? this.payoffCap.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxTargetLinearPayoffRegion {fxExchangedCurrencyModel=" + this.fxExchangedCurrencyModel + ", strike=" + this.strike + ", counterCurrencyAmount=" + this.counterCurrencyAmount + ", lowerBound=" + this.lowerBound + ", upperBound=" + this.upperBound + ", leverage=" + this.leverage + ", payoffCap=" + this.payoffCap + '}' + " " + super.toString();
        }
    }
}

