/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.BuyerSellerModel;
import fpml.confirmation.ExerciseProcedure;
import fpml.confirmation.FxAmericanExercise;
import fpml.confirmation.FxCashSettlement;
import fpml.confirmation.FxEuropeanExercise;
import fpml.confirmation.FxOptionFeatures;
import fpml.confirmation.FxOptionPremium;
import fpml.confirmation.FxStrikePrice;
import fpml.confirmation.NonNegativeMoney;
import fpml.confirmation.Option;
import fpml.confirmation.Period;
import fpml.confirmation.ProductModel;
import fpml.confirmation.PutCallEnum;
import fpml.confirmation.meta.FxOptionMeta;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="FxOption", builder=FxOptionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxOption", model="fpml", builder=FxOptionBuilderImpl.class, version="0.17.2")
public interface FxOption
extends Option {
    public static final FxOptionMeta metaData = new FxOptionMeta();

    public AdjustableOrRelativeDate getEffectiveDate();

    public Period getTenorPeriod();

    public FxAmericanExercise getAmericanExercise();

    public FxEuropeanExercise getEuropeanExercise();

    public ExerciseProcedure getExerciseProcedure();

    public NonNegativeMoney getPutCurrencyAmount();

    public NonNegativeMoney getCallCurrencyAmount();

    public PutCallEnum getSoldAs();

    public FxStrikePrice getStrike();

    public BigDecimal getSpotRate();

    public FxOptionFeatures getFeatures();

    public FxOptionPremium getPremium();

    public FxCashSettlement getCashSettlement();

    @Override
    public FxOption build();

    @Override
    public FxOptionBuilder toBuilder();

    public static FxOptionBuilder builder() {
        return new FxOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends FxOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxOption> getType() {
        return FxOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.class, this.getEffectiveDate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.class, this.getTenorPeriod(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("americanExercise"), processor, FxAmericanExercise.class, this.getAmericanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("europeanExercise"), processor, FxEuropeanExercise.class, this.getEuropeanExercise(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("putCurrencyAmount"), processor, NonNegativeMoney.class, this.getPutCurrencyAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("callCurrencyAmount"), processor, NonNegativeMoney.class, this.getCallCurrencyAmount(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("soldAs"), PutCallEnum.class, (Object)this.getSoldAs(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("strike"), processor, FxStrikePrice.class, this.getStrike(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("features"), processor, FxOptionFeatures.class, this.getFeatures(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.class, this.getPremium(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlement.class, this.getCashSettlement(), new AttributeMeta[0]);
    }

    public static class FxOptionBuilderImpl
    extends Option.OptionBuilderImpl
    implements FxOptionBuilder {
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder effectiveDate;
        protected Period.PeriodBuilder tenorPeriod;
        protected FxAmericanExercise.FxAmericanExerciseBuilder americanExercise;
        protected FxEuropeanExercise.FxEuropeanExerciseBuilder europeanExercise;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected NonNegativeMoney.NonNegativeMoneyBuilder putCurrencyAmount;
        protected NonNegativeMoney.NonNegativeMoneyBuilder callCurrencyAmount;
        protected PutCallEnum soldAs;
        protected FxStrikePrice.FxStrikePriceBuilder strike;
        protected BigDecimal spotRate;
        protected FxOptionFeatures.FxOptionFeaturesBuilder features;
        protected FxOptionPremium.FxOptionPremiumBuilder premium;
        protected FxCashSettlement.FxCashSettlementBuilder cashSettlement;

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.effectiveDate != null ? this.effectiveDate : (this.effectiveDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public Period.PeriodBuilder getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        public Period.PeriodBuilder getOrCreateTenorPeriod() {
            Period.PeriodBuilder result = this.tenorPeriod != null ? this.tenorPeriod : (this.tenorPeriod = Period.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public FxAmericanExercise.FxAmericanExerciseBuilder getAmericanExercise() {
            return this.americanExercise;
        }

        @Override
        public FxAmericanExercise.FxAmericanExerciseBuilder getOrCreateAmericanExercise() {
            FxAmericanExercise.FxAmericanExerciseBuilder result = this.americanExercise != null ? this.americanExercise : (this.americanExercise = FxAmericanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public FxEuropeanExercise.FxEuropeanExerciseBuilder getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        public FxEuropeanExercise.FxEuropeanExerciseBuilder getOrCreateEuropeanExercise() {
            FxEuropeanExercise.FxEuropeanExerciseBuilder result = this.europeanExercise != null ? this.europeanExercise : (this.europeanExercise = FxEuropeanExercise.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="putCurrencyAmount", isRequired=true)
        @RuneAttribute(value="putCurrencyAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getPutCurrencyAmount() {
            return this.putCurrencyAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePutCurrencyAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.putCurrencyAmount != null ? this.putCurrencyAmount : (this.putCurrencyAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="callCurrencyAmount", isRequired=true)
        @RuneAttribute(value="callCurrencyAmount", isRequired=true)
        public NonNegativeMoney.NonNegativeMoneyBuilder getCallCurrencyAmount() {
            return this.callCurrencyAmount;
        }

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateCallCurrencyAmount() {
            NonNegativeMoney.NonNegativeMoneyBuilder result = this.callCurrencyAmount != null ? this.callCurrencyAmount : (this.callCurrencyAmount = NonNegativeMoney.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="soldAs")
        @RuneAttribute(value="soldAs")
        public PutCallEnum getSoldAs() {
            return this.soldAs;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxStrikePrice.FxStrikePriceBuilder getStrike() {
            return this.strike;
        }

        @Override
        public FxStrikePrice.FxStrikePriceBuilder getOrCreateStrike() {
            FxStrikePrice.FxStrikePriceBuilder result = this.strike != null ? this.strike : (this.strike = FxStrikePrice.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="features")
        @RuneAttribute(value="features")
        public FxOptionFeatures.FxOptionFeaturesBuilder getFeatures() {
            return this.features;
        }

        @Override
        public FxOptionFeatures.FxOptionFeaturesBuilder getOrCreateFeatures() {
            FxOptionFeatures.FxOptionFeaturesBuilder result = this.features != null ? this.features : (this.features = FxOptionFeatures.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxOptionPremium.FxOptionPremiumBuilder getPremium() {
            return this.premium;
        }

        @Override
        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium() {
            FxOptionPremium.FxOptionPremiumBuilder result = this.premium != null ? this.premium : (this.premium = FxOptionPremium.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlement.FxCashSettlementBuilder getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxCashSettlement.FxCashSettlementBuilder getOrCreateCashSettlement() {
            FxCashSettlement.FxCashSettlementBuilder result = this.cashSettlement != null ? this.cashSettlement : (this.cashSettlement = FxCashSettlement.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public FxOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public FxOptionBuilder setEffectiveDate(AdjustableOrRelativeDate _effectiveDate) {
            this.effectiveDate = _effectiveDate == null ? null : _effectiveDate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public FxOptionBuilder setTenorPeriod(Period _tenorPeriod) {
            this.tenorPeriod = _tenorPeriod == null ? null : _tenorPeriod.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public FxOptionBuilder setAmericanExercise(FxAmericanExercise _americanExercise) {
            this.americanExercise = _americanExercise == null ? null : _americanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public FxOptionBuilder setEuropeanExercise(FxEuropeanExercise _europeanExercise) {
            this.europeanExercise = _europeanExercise == null ? null : _europeanExercise.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public FxOptionBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="putCurrencyAmount", isRequired=true)
        @RuneAttribute(value="putCurrencyAmount", isRequired=true)
        public FxOptionBuilder setPutCurrencyAmount(NonNegativeMoney _putCurrencyAmount) {
            this.putCurrencyAmount = _putCurrencyAmount == null ? null : _putCurrencyAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="callCurrencyAmount", isRequired=true)
        @RuneAttribute(value="callCurrencyAmount", isRequired=true)
        public FxOptionBuilder setCallCurrencyAmount(NonNegativeMoney _callCurrencyAmount) {
            this.callCurrencyAmount = _callCurrencyAmount == null ? null : _callCurrencyAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="soldAs")
        @RuneAttribute(value="soldAs")
        public FxOptionBuilder setSoldAs(PutCallEnum _soldAs) {
            this.soldAs = _soldAs == null ? null : _soldAs;
            return this;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxOptionBuilder setStrike(FxStrikePrice _strike) {
            this.strike = _strike == null ? null : _strike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxOptionBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="features")
        @RuneAttribute(value="features")
        public FxOptionBuilder setFeatures(FxOptionFeatures _features) {
            this.features = _features == null ? null : _features.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxOptionBuilder setPremium(FxOptionPremium _premium) {
            this.premium = _premium == null ? null : _premium.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxOptionBuilder setCashSettlement(FxCashSettlement _cashSettlement) {
            this.cashSettlement = _cashSettlement == null ? null : _cashSettlement.toBuilder();
            return this;
        }

        @Override
        public FxOption build() {
            return new FxOptionImpl(this);
        }

        @Override
        public FxOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public FxOptionBuilder prune() {
            super.prune();
            if (this.effectiveDate != null && !this.effectiveDate.prune().hasData()) {
                this.effectiveDate = null;
            }
            if (this.tenorPeriod != null && !this.tenorPeriod.prune().hasData()) {
                this.tenorPeriod = null;
            }
            if (this.americanExercise != null && !this.americanExercise.prune().hasData()) {
                this.americanExercise = null;
            }
            if (this.europeanExercise != null && !this.europeanExercise.prune().hasData()) {
                this.europeanExercise = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.putCurrencyAmount != null && !this.putCurrencyAmount.prune().hasData()) {
                this.putCurrencyAmount = null;
            }
            if (this.callCurrencyAmount != null && !this.callCurrencyAmount.prune().hasData()) {
                this.callCurrencyAmount = null;
            }
            if (this.strike != null && !this.strike.prune().hasData()) {
                this.strike = null;
            }
            if (this.features != null && !this.features.prune().hasData()) {
                this.features = null;
            }
            if (this.premium != null && !this.premium.prune().hasData()) {
                this.premium = null;
            }
            if (this.cashSettlement != null && !this.cashSettlement.prune().hasData()) {
                this.cashSettlement = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getEffectiveDate() != null && this.getEffectiveDate().hasData()) {
                return true;
            }
            if (this.getTenorPeriod() != null && this.getTenorPeriod().hasData()) {
                return true;
            }
            if (this.getAmericanExercise() != null && this.getAmericanExercise().hasData()) {
                return true;
            }
            if (this.getEuropeanExercise() != null && this.getEuropeanExercise().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getPutCurrencyAmount() != null && this.getPutCurrencyAmount().hasData()) {
                return true;
            }
            if (this.getCallCurrencyAmount() != null && this.getCallCurrencyAmount().hasData()) {
                return true;
            }
            if (this.getSoldAs() != null) {
                return true;
            }
            if (this.getStrike() != null && this.getStrike().hasData()) {
                return true;
            }
            if (this.getSpotRate() != null) {
                return true;
            }
            if (this.getFeatures() != null && this.getFeatures().hasData()) {
                return true;
            }
            if (this.getPremium() != null && this.getPremium().hasData()) {
                return true;
            }
            return this.getCashSettlement() != null && this.getCashSettlement().hasData();
        }

        @Override
        public FxOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxOptionBuilder o = (FxOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEffectiveDate(), (RosettaModelObjectBuilder)o.getEffectiveDate(), this::setEffectiveDate);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTenorPeriod(), (RosettaModelObjectBuilder)o.getTenorPeriod(), this::setTenorPeriod);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAmericanExercise(), (RosettaModelObjectBuilder)o.getAmericanExercise(), this::setAmericanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getEuropeanExercise(), (RosettaModelObjectBuilder)o.getEuropeanExercise(), this::setEuropeanExercise);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPutCurrencyAmount(), (RosettaModelObjectBuilder)o.getPutCurrencyAmount(), this::setPutCurrencyAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCallCurrencyAmount(), (RosettaModelObjectBuilder)o.getCallCurrencyAmount(), this::setCallCurrencyAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getStrike(), (RosettaModelObjectBuilder)o.getStrike(), this::setStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFeatures(), (RosettaModelObjectBuilder)o.getFeatures(), this::setFeatures);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPremium(), (RosettaModelObjectBuilder)o.getPremium(), this::setPremium);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCashSettlement(), (RosettaModelObjectBuilder)o.getCashSettlement(), this::setCashSettlement);
            merger.mergeBasic((Object)this.getSoldAs(), (Object)o.getSoldAs(), this::setSoldAs, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxOption _that = (FxOption)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.tenorPeriod, _that.getTenorPeriod())) {
                return false;
            }
            if (!Objects.equals(this.americanExercise, _that.getAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.putCurrencyAmount, _that.getPutCurrencyAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrencyAmount, _that.getCallCurrencyAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.soldAs, (Object)_that.getSoldAs())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.features, _that.getFeatures())) {
                return false;
            }
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.cashSettlement, _that.getCashSettlement());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            _result = 31 * _result + (this.americanExercise != null ? this.americanExercise.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.putCurrencyAmount != null ? this.putCurrencyAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrencyAmount != null ? this.callCurrencyAmount.hashCode() : 0);
            _result = 31 * _result + (this.soldAs != null ? ((Object)((Object)this.soldAs)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.features != null ? this.features.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxOptionBuilder {effectiveDate=" + this.effectiveDate + ", tenorPeriod=" + this.tenorPeriod + ", americanExercise=" + this.americanExercise + ", europeanExercise=" + this.europeanExercise + ", exerciseProcedure=" + this.exerciseProcedure + ", putCurrencyAmount=" + this.putCurrencyAmount + ", callCurrencyAmount=" + this.callCurrencyAmount + ", soldAs=" + (Object)((Object)this.soldAs) + ", strike=" + this.strike + ", spotRate=" + this.spotRate + ", features=" + this.features + ", premium=" + this.premium + ", cashSettlement=" + this.cashSettlement + '}' + " " + super.toString();
        }
    }

    public static interface FxOptionBuilder
    extends FxOption,
    Option.OptionBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateEffectiveDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getEffectiveDate();

        public Period.PeriodBuilder getOrCreateTenorPeriod();

        @Override
        public Period.PeriodBuilder getTenorPeriod();

        public FxAmericanExercise.FxAmericanExerciseBuilder getOrCreateAmericanExercise();

        @Override
        public FxAmericanExercise.FxAmericanExerciseBuilder getAmericanExercise();

        public FxEuropeanExercise.FxEuropeanExerciseBuilder getOrCreateEuropeanExercise();

        @Override
        public FxEuropeanExercise.FxEuropeanExerciseBuilder getEuropeanExercise();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreatePutCurrencyAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getPutCurrencyAmount();

        public NonNegativeMoney.NonNegativeMoneyBuilder getOrCreateCallCurrencyAmount();

        @Override
        public NonNegativeMoney.NonNegativeMoneyBuilder getCallCurrencyAmount();

        public FxStrikePrice.FxStrikePriceBuilder getOrCreateStrike();

        @Override
        public FxStrikePrice.FxStrikePriceBuilder getStrike();

        public FxOptionFeatures.FxOptionFeaturesBuilder getOrCreateFeatures();

        @Override
        public FxOptionFeatures.FxOptionFeaturesBuilder getFeatures();

        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium();

        @Override
        public FxOptionPremium.FxOptionPremiumBuilder getPremium();

        public FxCashSettlement.FxCashSettlementBuilder getOrCreateCashSettlement();

        @Override
        public FxCashSettlement.FxCashSettlementBuilder getCashSettlement();

        @Override
        public FxOptionBuilder setProductModel(ProductModel var1);

        @Override
        public FxOptionBuilder setId(String var1);

        @Override
        public FxOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public FxOptionBuilder setEffectiveDate(AdjustableOrRelativeDate var1);

        public FxOptionBuilder setTenorPeriod(Period var1);

        public FxOptionBuilder setAmericanExercise(FxAmericanExercise var1);

        public FxOptionBuilder setEuropeanExercise(FxEuropeanExercise var1);

        public FxOptionBuilder setExerciseProcedure(ExerciseProcedure var1);

        public FxOptionBuilder setPutCurrencyAmount(NonNegativeMoney var1);

        public FxOptionBuilder setCallCurrencyAmount(NonNegativeMoney var1);

        public FxOptionBuilder setSoldAs(PutCallEnum var1);

        public FxOptionBuilder setStrike(FxStrikePrice var1);

        public FxOptionBuilder setSpotRate(BigDecimal var1);

        public FxOptionBuilder setFeatures(FxOptionFeatures var1);

        public FxOptionBuilder setPremium(FxOptionPremium var1);

        public FxOptionBuilder setCashSettlement(FxCashSettlement var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("effectiveDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getEffectiveDate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("tenorPeriod"), processor, Period.PeriodBuilder.class, this.getTenorPeriod(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("americanExercise"), processor, FxAmericanExercise.FxAmericanExerciseBuilder.class, this.getAmericanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("europeanExercise"), processor, FxEuropeanExercise.FxEuropeanExerciseBuilder.class, this.getEuropeanExercise(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("putCurrencyAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getPutCurrencyAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("callCurrencyAmount"), processor, NonNegativeMoney.NonNegativeMoneyBuilder.class, this.getCallCurrencyAmount(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("soldAs"), PutCallEnum.class, (Object)this.getSoldAs(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("strike"), processor, FxStrikePrice.FxStrikePriceBuilder.class, this.getStrike(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("features"), processor, FxOptionFeatures.FxOptionFeaturesBuilder.class, this.getFeatures(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.FxOptionPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashSettlement"), processor, FxCashSettlement.FxCashSettlementBuilder.class, this.getCashSettlement(), new AttributeMeta[0]);
        }

        @Override
        public FxOptionBuilder prune();
    }

    public static class FxOptionImpl
    extends Option.OptionImpl
    implements FxOption {
        private final AdjustableOrRelativeDate effectiveDate;
        private final Period tenorPeriod;
        private final FxAmericanExercise americanExercise;
        private final FxEuropeanExercise europeanExercise;
        private final ExerciseProcedure exerciseProcedure;
        private final NonNegativeMoney putCurrencyAmount;
        private final NonNegativeMoney callCurrencyAmount;
        private final PutCallEnum soldAs;
        private final FxStrikePrice strike;
        private final BigDecimal spotRate;
        private final FxOptionFeatures features;
        private final FxOptionPremium premium;
        private final FxCashSettlement cashSettlement;

        protected FxOptionImpl(FxOptionBuilder builder) {
            super(builder);
            this.effectiveDate = Optional.ofNullable(builder.getEffectiveDate()).map(f -> f.build()).orElse(null);
            this.tenorPeriod = Optional.ofNullable(builder.getTenorPeriod()).map(f -> f.build()).orElse(null);
            this.americanExercise = Optional.ofNullable(builder.getAmericanExercise()).map(f -> f.build()).orElse(null);
            this.europeanExercise = Optional.ofNullable(builder.getEuropeanExercise()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.putCurrencyAmount = Optional.ofNullable(builder.getPutCurrencyAmount()).map(f -> f.build()).orElse(null);
            this.callCurrencyAmount = Optional.ofNullable(builder.getCallCurrencyAmount()).map(f -> f.build()).orElse(null);
            this.soldAs = builder.getSoldAs();
            this.strike = Optional.ofNullable(builder.getStrike()).map(f -> f.build()).orElse(null);
            this.spotRate = builder.getSpotRate();
            this.features = Optional.ofNullable(builder.getFeatures()).map(f -> f.build()).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).map(f -> f.build()).orElse(null);
            this.cashSettlement = Optional.ofNullable(builder.getCashSettlement()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="effectiveDate")
        @RuneAttribute(value="effectiveDate")
        public AdjustableOrRelativeDate getEffectiveDate() {
            return this.effectiveDate;
        }

        @Override
        @RosettaAttribute(value="tenorPeriod")
        @RuneAttribute(value="tenorPeriod")
        public Period getTenorPeriod() {
            return this.tenorPeriod;
        }

        @Override
        @RosettaAttribute(value="americanExercise")
        @RuneAttribute(value="americanExercise")
        public FxAmericanExercise getAmericanExercise() {
            return this.americanExercise;
        }

        @Override
        @RosettaAttribute(value="europeanExercise")
        @RuneAttribute(value="europeanExercise")
        public FxEuropeanExercise getEuropeanExercise() {
            return this.europeanExercise;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="putCurrencyAmount", isRequired=true)
        @RuneAttribute(value="putCurrencyAmount", isRequired=true)
        public NonNegativeMoney getPutCurrencyAmount() {
            return this.putCurrencyAmount;
        }

        @Override
        @RosettaAttribute(value="callCurrencyAmount", isRequired=true)
        @RuneAttribute(value="callCurrencyAmount", isRequired=true)
        public NonNegativeMoney getCallCurrencyAmount() {
            return this.callCurrencyAmount;
        }

        @Override
        @RosettaAttribute(value="soldAs")
        @RuneAttribute(value="soldAs")
        public PutCallEnum getSoldAs() {
            return this.soldAs;
        }

        @Override
        @RosettaAttribute(value="strike", isRequired=true)
        @RuneAttribute(value="strike", isRequired=true)
        public FxStrikePrice getStrike() {
            return this.strike;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="features")
        @RuneAttribute(value="features")
        public FxOptionFeatures getFeatures() {
            return this.features;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxOptionPremium getPremium() {
            return this.premium;
        }

        @Override
        @RosettaAttribute(value="cashSettlement")
        @RuneAttribute(value="cashSettlement")
        public FxCashSettlement getCashSettlement() {
            return this.cashSettlement;
        }

        @Override
        public FxOption build() {
            return this;
        }

        @Override
        public FxOptionBuilder toBuilder() {
            FxOptionBuilder builder = FxOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getEffectiveDate()).ifPresent(builder::setEffectiveDate);
            Optional.ofNullable(this.getTenorPeriod()).ifPresent(builder::setTenorPeriod);
            Optional.ofNullable(this.getAmericanExercise()).ifPresent(builder::setAmericanExercise);
            Optional.ofNullable(this.getEuropeanExercise()).ifPresent(builder::setEuropeanExercise);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getPutCurrencyAmount()).ifPresent(builder::setPutCurrencyAmount);
            Optional.ofNullable(this.getCallCurrencyAmount()).ifPresent(builder::setCallCurrencyAmount);
            Optional.ofNullable(this.getSoldAs()).ifPresent(builder::setSoldAs);
            Optional.ofNullable(this.getStrike()).ifPresent(builder::setStrike);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getFeatures()).ifPresent(builder::setFeatures);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
            Optional.ofNullable(this.getCashSettlement()).ifPresent(builder::setCashSettlement);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxOption _that = (FxOption)this.getType().cast(o);
            if (!Objects.equals(this.effectiveDate, _that.getEffectiveDate())) {
                return false;
            }
            if (!Objects.equals(this.tenorPeriod, _that.getTenorPeriod())) {
                return false;
            }
            if (!Objects.equals(this.americanExercise, _that.getAmericanExercise())) {
                return false;
            }
            if (!Objects.equals(this.europeanExercise, _that.getEuropeanExercise())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.putCurrencyAmount, _that.getPutCurrencyAmount())) {
                return false;
            }
            if (!Objects.equals(this.callCurrencyAmount, _that.getCallCurrencyAmount())) {
                return false;
            }
            if (!Objects.equals((Object)this.soldAs, (Object)_that.getSoldAs())) {
                return false;
            }
            if (!Objects.equals(this.strike, _that.getStrike())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.features, _that.getFeatures())) {
                return false;
            }
            if (!Objects.equals(this.premium, _that.getPremium())) {
                return false;
            }
            return Objects.equals(this.cashSettlement, _that.getCashSettlement());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.effectiveDate != null ? this.effectiveDate.hashCode() : 0);
            _result = 31 * _result + (this.tenorPeriod != null ? this.tenorPeriod.hashCode() : 0);
            _result = 31 * _result + (this.americanExercise != null ? this.americanExercise.hashCode() : 0);
            _result = 31 * _result + (this.europeanExercise != null ? this.europeanExercise.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.putCurrencyAmount != null ? this.putCurrencyAmount.hashCode() : 0);
            _result = 31 * _result + (this.callCurrencyAmount != null ? this.callCurrencyAmount.hashCode() : 0);
            _result = 31 * _result + (this.soldAs != null ? ((Object)((Object)this.soldAs)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.strike != null ? this.strike.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.features != null ? this.features.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            _result = 31 * _result + (this.cashSettlement != null ? this.cashSettlement.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxOption {effectiveDate=" + this.effectiveDate + ", tenorPeriod=" + this.tenorPeriod + ", americanExercise=" + this.americanExercise + ", europeanExercise=" + this.europeanExercise + ", exerciseProcedure=" + this.exerciseProcedure + ", putCurrencyAmount=" + this.putCurrencyAmount + ", callCurrencyAmount=" + this.callCurrencyAmount + ", soldAs=" + (Object)((Object)this.soldAs) + ", strike=" + this.strike + ", spotRate=" + this.spotRate + ", features=" + this.features + ", premium=" + this.premium + ", cashSettlement=" + this.cashSettlement + '}' + " " + super.toString();
        }
    }
}

