/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.BuyerSellerModel;
import fpml.confirmation.ExerciseProcedure;
import fpml.confirmation.FxAccrual;
import fpml.confirmation.FxAccrualBarrier;
import fpml.confirmation.FxAccrualOptionSequence;
import fpml.confirmation.FxAverageRate;
import fpml.confirmation.FxAverageStrike;
import fpml.confirmation.FxExpiryDateOrScheduleModel;
import fpml.confirmation.FxOptionPremium;
import fpml.confirmation.FxSettlementDateOrScheduleModel;
import fpml.confirmation.NonNegativeAmountSchedule;
import fpml.confirmation.Option;
import fpml.confirmation.ProductModel;
import fpml.confirmation.PutCallCurrencyModel;
import fpml.confirmation.meta.FxAccrualOptionMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FxAccrualOption", builder=FxAccrualOptionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FxAccrualOption", model="fpml", builder=FxAccrualOptionBuilderImpl.class, version="0.17.2")
public interface FxAccrualOption
extends Option {
    public static final FxAccrualOptionMeta metaData = new FxAccrualOptionMeta();

    public PutCallCurrencyModel getPutCallCurrencyModel();

    public NonNegativeAmountSchedule getNotionalAmount();

    public FxAccrual getAccrual();

    public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel();

    public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel();

    public ExerciseProcedure getExerciseProcedure();

    public BigDecimal getSpotRate();

    public FxAccrualOptionSequence getFxAccrualOptionSequence();

    public FxAverageStrike getAverageStrike();

    public FxAverageRate getAverageRate();

    public List<? extends FxAccrualBarrier> getBarrier();

    public List<? extends FxOptionPremium> getPremium();

    @Override
    public FxAccrualOption build();

    @Override
    public FxAccrualOptionBuilder toBuilder();

    public static FxAccrualOptionBuilder builder() {
        return new FxAccrualOptionBuilderImpl();
    }

    default public RosettaMetaData<? extends FxAccrualOption> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FxAccrualOption> getType() {
        return FxAccrualOption.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.class, this.getProductModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.class, this.getBuyerSellerModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("putCallCurrencyModel"), processor, PutCallCurrencyModel.class, this.getPutCallCurrencyModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.class, this.getNotionalAmount(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.class, this.getAccrual(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.class, this.getExerciseProcedure(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("fxAccrualOptionSequence"), processor, FxAccrualOptionSequence.class, this.getFxAccrualOptionSequence(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averageStrike"), processor, FxAverageStrike.class, this.getAverageStrike(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("averageRate"), processor, FxAverageRate.class, this.getAverageRate(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.class, this.getBarrier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.class, this.getPremium(), new AttributeMeta[0]);
    }

    public static class FxAccrualOptionBuilderImpl
    extends Option.OptionBuilderImpl
    implements FxAccrualOptionBuilder {
        protected PutCallCurrencyModel.PutCallCurrencyModelBuilder putCallCurrencyModel;
        protected NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder notionalAmount;
        protected FxAccrual.FxAccrualBuilder accrual;
        protected FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder fxExpiryDateOrScheduleModel;
        protected FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder fxSettlementDateOrScheduleModel;
        protected ExerciseProcedure.ExerciseProcedureBuilder exerciseProcedure;
        protected BigDecimal spotRate;
        protected FxAccrualOptionSequence.FxAccrualOptionSequenceBuilder fxAccrualOptionSequence;
        protected FxAverageStrike.FxAverageStrikeBuilder averageStrike;
        protected FxAverageRate.FxAverageRateBuilder averageRate;
        protected List<FxAccrualBarrier.FxAccrualBarrierBuilder> barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
        protected List<FxOptionPremium.FxOptionPremiumBuilder> premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();

        @Override
        @RosettaAttribute(value="putCallCurrencyModel", isRequired=true)
        @RuneAttribute(value="putCallCurrencyModel", isRequired=true)
        public PutCallCurrencyModel.PutCallCurrencyModelBuilder getPutCallCurrencyModel() {
            return this.putCallCurrencyModel;
        }

        @Override
        public PutCallCurrencyModel.PutCallCurrencyModelBuilder getOrCreatePutCallCurrencyModel() {
            PutCallCurrencyModel.PutCallCurrencyModelBuilder result = this.putCallCurrencyModel != null ? this.putCallCurrencyModel : (this.putCallCurrencyModel = PutCallCurrencyModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount() {
            NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder result = this.notionalAmount != null ? this.notionalAmount : (this.notionalAmount = NonNegativeAmountSchedule.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual.FxAccrualBuilder getAccrual() {
            return this.accrual;
        }

        @Override
        public FxAccrual.FxAccrualBuilder getOrCreateAccrual() {
            FxAccrual.FxAccrualBuilder result = this.accrual != null ? this.accrual : (this.accrual = FxAccrual.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel() {
            FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder result = this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel : (this.fxExpiryDateOrScheduleModel = FxExpiryDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel() {
            FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder result = this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel : (this.fxSettlementDateOrScheduleModel = FxSettlementDateOrScheduleModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure() {
            ExerciseProcedure.ExerciseProcedureBuilder result = this.exerciseProcedure != null ? this.exerciseProcedure : (this.exerciseProcedure = ExerciseProcedure.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="fxAccrualOptionSequence")
        @RuneAttribute(value="fxAccrualOptionSequence")
        public FxAccrualOptionSequence.FxAccrualOptionSequenceBuilder getFxAccrualOptionSequence() {
            return this.fxAccrualOptionSequence;
        }

        @Override
        public FxAccrualOptionSequence.FxAccrualOptionSequenceBuilder getOrCreateFxAccrualOptionSequence() {
            FxAccrualOptionSequence.FxAccrualOptionSequenceBuilder result = this.fxAccrualOptionSequence != null ? this.fxAccrualOptionSequence : (this.fxAccrualOptionSequence = FxAccrualOptionSequence.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averageStrike")
        @RuneAttribute(value="averageStrike")
        public FxAverageStrike.FxAverageStrikeBuilder getAverageStrike() {
            return this.averageStrike;
        }

        @Override
        public FxAverageStrike.FxAverageStrikeBuilder getOrCreateAverageStrike() {
            FxAverageStrike.FxAverageStrikeBuilder result = this.averageStrike != null ? this.averageStrike : (this.averageStrike = FxAverageStrike.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="averageRate")
        @RuneAttribute(value="averageRate")
        public FxAverageRate.FxAverageRateBuilder getAverageRate() {
            return this.averageRate;
        }

        @Override
        public FxAverageRate.FxAverageRateBuilder getOrCreateAverageRate() {
            FxAverageRate.FxAverageRateBuilder result = this.averageRate != null ? this.averageRate : (this.averageRate = FxAverageRate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier() {
            return this.barrier;
        }

        @Override
        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int index) {
            if (this.barrier == null) {
                this.barrier = new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>();
            }
            return (FxAccrualBarrier.FxAccrualBarrierBuilder)this.getIndex(this.barrier, index, () -> {
                FxAccrualBarrier.FxAccrualBarrierBuilder newBarrier = FxAccrualBarrier.builder();
                return newBarrier;
            });
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium() {
            return this.premium;
        }

        @Override
        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int index) {
            if (this.premium == null) {
                this.premium = new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>();
            }
            return (FxOptionPremium.FxOptionPremiumBuilder)this.getIndex(this.premium, index, () -> {
                FxOptionPremium.FxOptionPremiumBuilder newPremium = FxOptionPremium.builder();
                return newPremium;
            });
        }

        @Override
        @RosettaAttribute(value="productModel")
        @RuneAttribute(value="productModel")
        public FxAccrualOptionBuilder setProductModel(ProductModel _productModel) {
            this.productModel = _productModel == null ? null : _productModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public FxAccrualOptionBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="buyerSellerModel", isRequired=true)
        @RuneAttribute(value="buyerSellerModel", isRequired=true)
        public FxAccrualOptionBuilder setBuyerSellerModel(BuyerSellerModel _buyerSellerModel) {
            this.buyerSellerModel = _buyerSellerModel == null ? null : _buyerSellerModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="putCallCurrencyModel", isRequired=true)
        @RuneAttribute(value="putCallCurrencyModel", isRequired=true)
        public FxAccrualOptionBuilder setPutCallCurrencyModel(PutCallCurrencyModel _putCallCurrencyModel) {
            this.putCallCurrencyModel = _putCallCurrencyModel == null ? null : _putCallCurrencyModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public FxAccrualOptionBuilder setNotionalAmount(NonNegativeAmountSchedule _notionalAmount) {
            this.notionalAmount = _notionalAmount == null ? null : _notionalAmount.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrualOptionBuilder setAccrual(FxAccrual _accrual) {
            this.accrual = _accrual == null ? null : _accrual.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxAccrualOptionBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel _fxExpiryDateOrScheduleModel) {
            this.fxExpiryDateOrScheduleModel = _fxExpiryDateOrScheduleModel == null ? null : _fxExpiryDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxAccrualOptionBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel _fxSettlementDateOrScheduleModel) {
            this.fxSettlementDateOrScheduleModel = _fxSettlementDateOrScheduleModel == null ? null : _fxSettlementDateOrScheduleModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public FxAccrualOptionBuilder setExerciseProcedure(ExerciseProcedure _exerciseProcedure) {
            this.exerciseProcedure = _exerciseProcedure == null ? null : _exerciseProcedure.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public FxAccrualOptionBuilder setSpotRate(BigDecimal _spotRate) {
            this.spotRate = _spotRate == null ? null : _spotRate;
            return this;
        }

        @Override
        @RosettaAttribute(value="fxAccrualOptionSequence")
        @RuneAttribute(value="fxAccrualOptionSequence")
        public FxAccrualOptionBuilder setFxAccrualOptionSequence(FxAccrualOptionSequence _fxAccrualOptionSequence) {
            this.fxAccrualOptionSequence = _fxAccrualOptionSequence == null ? null : _fxAccrualOptionSequence.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averageStrike")
        @RuneAttribute(value="averageStrike")
        public FxAccrualOptionBuilder setAverageStrike(FxAverageStrike _averageStrike) {
            this.averageStrike = _averageStrike == null ? null : _averageStrike.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="averageRate")
        @RuneAttribute(value="averageRate")
        public FxAccrualOptionBuilder setAverageRate(FxAverageRate _averageRate) {
            this.averageRate = _averageRate == null ? null : _averageRate.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public FxAccrualOptionBuilder addBarrier(FxAccrualBarrier _barrier) {
            if (_barrier != null) {
                this.barrier.add(_barrier.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualOptionBuilder addBarrier(FxAccrualBarrier _barrier, int idx) {
            this.getIndex(this.barrier, idx, () -> _barrier.toBuilder());
            return this;
        }

        @Override
        public FxAccrualOptionBuilder addBarrier(List<? extends FxAccrualBarrier> barriers) {
            if (barriers != null) {
                for (FxAccrualBarrier fxAccrualBarrier : barriers) {
                    this.barrier.add(fxAccrualBarrier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="barrier")
        public FxAccrualOptionBuilder setBarrier(List<? extends FxAccrualBarrier> barriers) {
            this.barrier = barriers == null ? new ArrayList<FxAccrualBarrier.FxAccrualBarrierBuilder>() : (List)barriers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public FxAccrualOptionBuilder addPremium(FxOptionPremium _premium) {
            if (_premium != null) {
                this.premium.add(_premium.toBuilder());
            }
            return this;
        }

        @Override
        public FxAccrualOptionBuilder addPremium(FxOptionPremium _premium, int idx) {
            this.getIndex(this.premium, idx, () -> _premium.toBuilder());
            return this;
        }

        @Override
        public FxAccrualOptionBuilder addPremium(List<? extends FxOptionPremium> premiums) {
            if (premiums != null) {
                for (FxOptionPremium fxOptionPremium : premiums) {
                    this.premium.add(fxOptionPremium.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="premium")
        public FxAccrualOptionBuilder setPremium(List<? extends FxOptionPremium> premiums) {
            this.premium = premiums == null ? new ArrayList<FxOptionPremium.FxOptionPremiumBuilder>() : (List)premiums.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FxAccrualOption build() {
            return new FxAccrualOptionImpl(this);
        }

        @Override
        public FxAccrualOptionBuilder toBuilder() {
            return this;
        }

        @Override
        public FxAccrualOptionBuilder prune() {
            super.prune();
            if (this.putCallCurrencyModel != null && !this.putCallCurrencyModel.prune().hasData()) {
                this.putCallCurrencyModel = null;
            }
            if (this.notionalAmount != null && !this.notionalAmount.prune().hasData()) {
                this.notionalAmount = null;
            }
            if (this.accrual != null && !this.accrual.prune().hasData()) {
                this.accrual = null;
            }
            if (this.fxExpiryDateOrScheduleModel != null && !this.fxExpiryDateOrScheduleModel.prune().hasData()) {
                this.fxExpiryDateOrScheduleModel = null;
            }
            if (this.fxSettlementDateOrScheduleModel != null && !this.fxSettlementDateOrScheduleModel.prune().hasData()) {
                this.fxSettlementDateOrScheduleModel = null;
            }
            if (this.exerciseProcedure != null && !this.exerciseProcedure.prune().hasData()) {
                this.exerciseProcedure = null;
            }
            if (this.fxAccrualOptionSequence != null && !this.fxAccrualOptionSequence.prune().hasData()) {
                this.fxAccrualOptionSequence = null;
            }
            if (this.averageStrike != null && !this.averageStrike.prune().hasData()) {
                this.averageStrike = null;
            }
            if (this.averageRate != null && !this.averageRate.prune().hasData()) {
                this.averageRate = null;
            }
            this.barrier = this.barrier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.premium = this.premium.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getPutCallCurrencyModel() != null && this.getPutCallCurrencyModel().hasData()) {
                return true;
            }
            if (this.getNotionalAmount() != null && this.getNotionalAmount().hasData()) {
                return true;
            }
            if (this.getAccrual() != null && this.getAccrual().hasData()) {
                return true;
            }
            if (this.getFxExpiryDateOrScheduleModel() != null && this.getFxExpiryDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getFxSettlementDateOrScheduleModel() != null && this.getFxSettlementDateOrScheduleModel().hasData()) {
                return true;
            }
            if (this.getExerciseProcedure() != null && this.getExerciseProcedure().hasData()) {
                return true;
            }
            if (this.getSpotRate() != null) {
                return true;
            }
            if (this.getFxAccrualOptionSequence() != null && this.getFxAccrualOptionSequence().hasData()) {
                return true;
            }
            if (this.getAverageStrike() != null && this.getAverageStrike().hasData()) {
                return true;
            }
            if (this.getAverageRate() != null && this.getAverageRate().hasData()) {
                return true;
            }
            if (this.getBarrier() != null && this.getBarrier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            return this.getPremium() != null && this.getPremium().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        @Override
        public FxAccrualOptionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            FxAccrualOptionBuilder o = (FxAccrualOptionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPutCallCurrencyModel(), (RosettaModelObjectBuilder)o.getPutCallCurrencyModel(), this::setPutCallCurrencyModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getNotionalAmount(), (RosettaModelObjectBuilder)o.getNotionalAmount(), this::setNotionalAmount);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAccrual(), (RosettaModelObjectBuilder)o.getAccrual(), this::setAccrual);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxExpiryDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxExpiryDateOrScheduleModel(), this::setFxExpiryDateOrScheduleModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxSettlementDateOrScheduleModel(), (RosettaModelObjectBuilder)o.getFxSettlementDateOrScheduleModel(), this::setFxSettlementDateOrScheduleModel);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExerciseProcedure(), (RosettaModelObjectBuilder)o.getExerciseProcedure(), this::setExerciseProcedure);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFxAccrualOptionSequence(), (RosettaModelObjectBuilder)o.getFxAccrualOptionSequence(), this::setFxAccrualOptionSequence);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAverageStrike(), (RosettaModelObjectBuilder)o.getAverageStrike(), this::setAverageStrike);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getAverageRate(), (RosettaModelObjectBuilder)o.getAverageRate(), this::setAverageRate);
            merger.mergeRosetta(this.getBarrier(), o.getBarrier(), this::getOrCreateBarrier);
            merger.mergeRosetta(this.getPremium(), o.getPremium(), this::getOrCreatePremium);
            merger.mergeBasic((Object)this.getSpotRate(), (Object)o.getSpotRate(), this::setSpotRate, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualOption _that = (FxAccrualOption)this.getType().cast(o);
            if (!Objects.equals(this.putCallCurrencyModel, _that.getPutCallCurrencyModel())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.fxAccrualOptionSequence, _that.getFxAccrualOptionSequence())) {
                return false;
            }
            if (!Objects.equals(this.averageStrike, _that.getAverageStrike())) {
                return false;
            }
            if (!Objects.equals(this.averageRate, _that.getAverageRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.putCallCurrencyModel != null ? this.putCallCurrencyModel.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.fxAccrualOptionSequence != null ? this.fxAccrualOptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.averageStrike != null ? this.averageStrike.hashCode() : 0);
            _result = 31 * _result + (this.averageRate != null ? this.averageRate.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualOptionBuilder {putCallCurrencyModel=" + this.putCallCurrencyModel + ", notionalAmount=" + this.notionalAmount + ", accrual=" + this.accrual + ", fxExpiryDateOrScheduleModel=" + this.fxExpiryDateOrScheduleModel + ", fxSettlementDateOrScheduleModel=" + this.fxSettlementDateOrScheduleModel + ", exerciseProcedure=" + this.exerciseProcedure + ", spotRate=" + this.spotRate + ", fxAccrualOptionSequence=" + this.fxAccrualOptionSequence + ", averageStrike=" + this.averageStrike + ", averageRate=" + this.averageRate + ", barrier=" + this.barrier + ", premium=" + this.premium + '}' + " " + super.toString();
        }
    }

    public static interface FxAccrualOptionBuilder
    extends FxAccrualOption,
    Option.OptionBuilder {
        public PutCallCurrencyModel.PutCallCurrencyModelBuilder getOrCreatePutCallCurrencyModel();

        @Override
        public PutCallCurrencyModel.PutCallCurrencyModelBuilder getPutCallCurrencyModel();

        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getOrCreateNotionalAmount();

        @Override
        public NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder getNotionalAmount();

        public FxAccrual.FxAccrualBuilder getOrCreateAccrual();

        @Override
        public FxAccrual.FxAccrualBuilder getAccrual();

        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getOrCreateFxExpiryDateOrScheduleModel();

        @Override
        public FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder getFxExpiryDateOrScheduleModel();

        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getOrCreateFxSettlementDateOrScheduleModel();

        @Override
        public FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder getFxSettlementDateOrScheduleModel();

        public ExerciseProcedure.ExerciseProcedureBuilder getOrCreateExerciseProcedure();

        @Override
        public ExerciseProcedure.ExerciseProcedureBuilder getExerciseProcedure();

        public FxAccrualOptionSequence.FxAccrualOptionSequenceBuilder getOrCreateFxAccrualOptionSequence();

        @Override
        public FxAccrualOptionSequence.FxAccrualOptionSequenceBuilder getFxAccrualOptionSequence();

        public FxAverageStrike.FxAverageStrikeBuilder getOrCreateAverageStrike();

        @Override
        public FxAverageStrike.FxAverageStrikeBuilder getAverageStrike();

        public FxAverageRate.FxAverageRateBuilder getOrCreateAverageRate();

        @Override
        public FxAverageRate.FxAverageRateBuilder getAverageRate();

        public FxAccrualBarrier.FxAccrualBarrierBuilder getOrCreateBarrier(int var1);

        public List<? extends FxAccrualBarrier.FxAccrualBarrierBuilder> getBarrier();

        public FxOptionPremium.FxOptionPremiumBuilder getOrCreatePremium(int var1);

        public List<? extends FxOptionPremium.FxOptionPremiumBuilder> getPremium();

        @Override
        public FxAccrualOptionBuilder setProductModel(ProductModel var1);

        @Override
        public FxAccrualOptionBuilder setId(String var1);

        @Override
        public FxAccrualOptionBuilder setBuyerSellerModel(BuyerSellerModel var1);

        public FxAccrualOptionBuilder setPutCallCurrencyModel(PutCallCurrencyModel var1);

        public FxAccrualOptionBuilder setNotionalAmount(NonNegativeAmountSchedule var1);

        public FxAccrualOptionBuilder setAccrual(FxAccrual var1);

        public FxAccrualOptionBuilder setFxExpiryDateOrScheduleModel(FxExpiryDateOrScheduleModel var1);

        public FxAccrualOptionBuilder setFxSettlementDateOrScheduleModel(FxSettlementDateOrScheduleModel var1);

        public FxAccrualOptionBuilder setExerciseProcedure(ExerciseProcedure var1);

        public FxAccrualOptionBuilder setSpotRate(BigDecimal var1);

        public FxAccrualOptionBuilder setFxAccrualOptionSequence(FxAccrualOptionSequence var1);

        public FxAccrualOptionBuilder setAverageStrike(FxAverageStrike var1);

        public FxAccrualOptionBuilder setAverageRate(FxAverageRate var1);

        public FxAccrualOptionBuilder addBarrier(FxAccrualBarrier var1);

        public FxAccrualOptionBuilder addBarrier(FxAccrualBarrier var1, int var2);

        public FxAccrualOptionBuilder addBarrier(List<? extends FxAccrualBarrier> var1);

        public FxAccrualOptionBuilder setBarrier(List<? extends FxAccrualBarrier> var1);

        public FxAccrualOptionBuilder addPremium(FxOptionPremium var1);

        public FxAccrualOptionBuilder addPremium(FxOptionPremium var1, int var2);

        public FxAccrualOptionBuilder addPremium(List<? extends FxOptionPremium> var1);

        public FxAccrualOptionBuilder setPremium(List<? extends FxOptionPremium> var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("productModel"), processor, ProductModel.ProductModelBuilder.class, (RosettaModelObjectBuilder)this.getProductModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("buyerSellerModel"), processor, BuyerSellerModel.BuyerSellerModelBuilder.class, (RosettaModelObjectBuilder)this.getBuyerSellerModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("putCallCurrencyModel"), processor, PutCallCurrencyModel.PutCallCurrencyModelBuilder.class, this.getPutCallCurrencyModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("notionalAmount"), processor, NonNegativeAmountSchedule.NonNegativeAmountScheduleBuilder.class, this.getNotionalAmount(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("accrual"), processor, FxAccrual.FxAccrualBuilder.class, this.getAccrual(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxExpiryDateOrScheduleModel"), processor, FxExpiryDateOrScheduleModel.FxExpiryDateOrScheduleModelBuilder.class, this.getFxExpiryDateOrScheduleModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxSettlementDateOrScheduleModel"), processor, FxSettlementDateOrScheduleModel.FxSettlementDateOrScheduleModelBuilder.class, this.getFxSettlementDateOrScheduleModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exerciseProcedure"), processor, ExerciseProcedure.ExerciseProcedureBuilder.class, this.getExerciseProcedure(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("spotRate"), BigDecimal.class, (Object)this.getSpotRate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("fxAccrualOptionSequence"), processor, FxAccrualOptionSequence.FxAccrualOptionSequenceBuilder.class, this.getFxAccrualOptionSequence(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averageStrike"), processor, FxAverageStrike.FxAverageStrikeBuilder.class, this.getAverageStrike(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("averageRate"), processor, FxAverageRate.FxAverageRateBuilder.class, this.getAverageRate(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("barrier"), processor, FxAccrualBarrier.FxAccrualBarrierBuilder.class, this.getBarrier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("premium"), processor, FxOptionPremium.FxOptionPremiumBuilder.class, this.getPremium(), new AttributeMeta[0]);
        }

        @Override
        public FxAccrualOptionBuilder prune();
    }

    public static class FxAccrualOptionImpl
    extends Option.OptionImpl
    implements FxAccrualOption {
        private final PutCallCurrencyModel putCallCurrencyModel;
        private final NonNegativeAmountSchedule notionalAmount;
        private final FxAccrual accrual;
        private final FxExpiryDateOrScheduleModel fxExpiryDateOrScheduleModel;
        private final FxSettlementDateOrScheduleModel fxSettlementDateOrScheduleModel;
        private final ExerciseProcedure exerciseProcedure;
        private final BigDecimal spotRate;
        private final FxAccrualOptionSequence fxAccrualOptionSequence;
        private final FxAverageStrike averageStrike;
        private final FxAverageRate averageRate;
        private final List<? extends FxAccrualBarrier> barrier;
        private final List<? extends FxOptionPremium> premium;

        protected FxAccrualOptionImpl(FxAccrualOptionBuilder builder) {
            super(builder);
            this.putCallCurrencyModel = Optional.ofNullable(builder.getPutCallCurrencyModel()).map(f -> f.build()).orElse(null);
            this.notionalAmount = Optional.ofNullable(builder.getNotionalAmount()).map(f -> f.build()).orElse(null);
            this.accrual = Optional.ofNullable(builder.getAccrual()).map(f -> f.build()).orElse(null);
            this.fxExpiryDateOrScheduleModel = Optional.ofNullable(builder.getFxExpiryDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.fxSettlementDateOrScheduleModel = Optional.ofNullable(builder.getFxSettlementDateOrScheduleModel()).map(f -> f.build()).orElse(null);
            this.exerciseProcedure = Optional.ofNullable(builder.getExerciseProcedure()).map(f -> f.build()).orElse(null);
            this.spotRate = builder.getSpotRate();
            this.fxAccrualOptionSequence = Optional.ofNullable(builder.getFxAccrualOptionSequence()).map(f -> f.build()).orElse(null);
            this.averageStrike = Optional.ofNullable(builder.getAverageStrike()).map(f -> f.build()).orElse(null);
            this.averageRate = Optional.ofNullable(builder.getAverageRate()).map(f -> f.build()).orElse(null);
            this.barrier = Optional.ofNullable(builder.getBarrier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.premium = Optional.ofNullable(builder.getPremium()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="putCallCurrencyModel", isRequired=true)
        @RuneAttribute(value="putCallCurrencyModel", isRequired=true)
        public PutCallCurrencyModel getPutCallCurrencyModel() {
            return this.putCallCurrencyModel;
        }

        @Override
        @RosettaAttribute(value="notionalAmount", isRequired=true)
        @RuneAttribute(value="notionalAmount", isRequired=true)
        public NonNegativeAmountSchedule getNotionalAmount() {
            return this.notionalAmount;
        }

        @Override
        @RosettaAttribute(value="accrual", isRequired=true)
        @RuneAttribute(value="accrual", isRequired=true)
        public FxAccrual getAccrual() {
            return this.accrual;
        }

        @Override
        @RosettaAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxExpiryDateOrScheduleModel", isRequired=true)
        public FxExpiryDateOrScheduleModel getFxExpiryDateOrScheduleModel() {
            return this.fxExpiryDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        @RuneAttribute(value="fxSettlementDateOrScheduleModel", isRequired=true)
        public FxSettlementDateOrScheduleModel getFxSettlementDateOrScheduleModel() {
            return this.fxSettlementDateOrScheduleModel;
        }

        @Override
        @RosettaAttribute(value="exerciseProcedure")
        @RuneAttribute(value="exerciseProcedure")
        public ExerciseProcedure getExerciseProcedure() {
            return this.exerciseProcedure;
        }

        @Override
        @RosettaAttribute(value="spotRate")
        @RuneAttribute(value="spotRate")
        public BigDecimal getSpotRate() {
            return this.spotRate;
        }

        @Override
        @RosettaAttribute(value="fxAccrualOptionSequence")
        @RuneAttribute(value="fxAccrualOptionSequence")
        public FxAccrualOptionSequence getFxAccrualOptionSequence() {
            return this.fxAccrualOptionSequence;
        }

        @Override
        @RosettaAttribute(value="averageStrike")
        @RuneAttribute(value="averageStrike")
        public FxAverageStrike getAverageStrike() {
            return this.averageStrike;
        }

        @Override
        @RosettaAttribute(value="averageRate")
        @RuneAttribute(value="averageRate")
        public FxAverageRate getAverageRate() {
            return this.averageRate;
        }

        @Override
        @RosettaAttribute(value="barrier")
        @RuneAttribute(value="barrier")
        public List<? extends FxAccrualBarrier> getBarrier() {
            return this.barrier;
        }

        @Override
        @RosettaAttribute(value="premium")
        @RuneAttribute(value="premium")
        public List<? extends FxOptionPremium> getPremium() {
            return this.premium;
        }

        @Override
        public FxAccrualOption build() {
            return this;
        }

        @Override
        public FxAccrualOptionBuilder toBuilder() {
            FxAccrualOptionBuilder builder = FxAccrualOption.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FxAccrualOptionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getPutCallCurrencyModel()).ifPresent(builder::setPutCallCurrencyModel);
            Optional.ofNullable(this.getNotionalAmount()).ifPresent(builder::setNotionalAmount);
            Optional.ofNullable(this.getAccrual()).ifPresent(builder::setAccrual);
            Optional.ofNullable(this.getFxExpiryDateOrScheduleModel()).ifPresent(builder::setFxExpiryDateOrScheduleModel);
            Optional.ofNullable(this.getFxSettlementDateOrScheduleModel()).ifPresent(builder::setFxSettlementDateOrScheduleModel);
            Optional.ofNullable(this.getExerciseProcedure()).ifPresent(builder::setExerciseProcedure);
            Optional.ofNullable(this.getSpotRate()).ifPresent(builder::setSpotRate);
            Optional.ofNullable(this.getFxAccrualOptionSequence()).ifPresent(builder::setFxAccrualOptionSequence);
            Optional.ofNullable(this.getAverageStrike()).ifPresent(builder::setAverageStrike);
            Optional.ofNullable(this.getAverageRate()).ifPresent(builder::setAverageRate);
            Optional.ofNullable(this.getBarrier()).ifPresent(builder::setBarrier);
            Optional.ofNullable(this.getPremium()).ifPresent(builder::setPremium);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            FxAccrualOption _that = (FxAccrualOption)this.getType().cast(o);
            if (!Objects.equals(this.putCallCurrencyModel, _that.getPutCallCurrencyModel())) {
                return false;
            }
            if (!Objects.equals(this.notionalAmount, _that.getNotionalAmount())) {
                return false;
            }
            if (!Objects.equals(this.accrual, _that.getAccrual())) {
                return false;
            }
            if (!Objects.equals(this.fxExpiryDateOrScheduleModel, _that.getFxExpiryDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.fxSettlementDateOrScheduleModel, _that.getFxSettlementDateOrScheduleModel())) {
                return false;
            }
            if (!Objects.equals(this.exerciseProcedure, _that.getExerciseProcedure())) {
                return false;
            }
            if (!Objects.equals(this.spotRate, _that.getSpotRate())) {
                return false;
            }
            if (!Objects.equals(this.fxAccrualOptionSequence, _that.getFxAccrualOptionSequence())) {
                return false;
            }
            if (!Objects.equals(this.averageStrike, _that.getAverageStrike())) {
                return false;
            }
            if (!Objects.equals(this.averageRate, _that.getAverageRate())) {
                return false;
            }
            if (!ListEquals.listEquals(this.barrier, _that.getBarrier())) {
                return false;
            }
            return ListEquals.listEquals(this.premium, _that.getPremium());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.putCallCurrencyModel != null ? this.putCallCurrencyModel.hashCode() : 0);
            _result = 31 * _result + (this.notionalAmount != null ? this.notionalAmount.hashCode() : 0);
            _result = 31 * _result + (this.accrual != null ? this.accrual.hashCode() : 0);
            _result = 31 * _result + (this.fxExpiryDateOrScheduleModel != null ? this.fxExpiryDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.fxSettlementDateOrScheduleModel != null ? this.fxSettlementDateOrScheduleModel.hashCode() : 0);
            _result = 31 * _result + (this.exerciseProcedure != null ? this.exerciseProcedure.hashCode() : 0);
            _result = 31 * _result + (this.spotRate != null ? this.spotRate.hashCode() : 0);
            _result = 31 * _result + (this.fxAccrualOptionSequence != null ? this.fxAccrualOptionSequence.hashCode() : 0);
            _result = 31 * _result + (this.averageStrike != null ? this.averageStrike.hashCode() : 0);
            _result = 31 * _result + (this.averageRate != null ? this.averageRate.hashCode() : 0);
            _result = 31 * _result + (this.barrier != null ? this.barrier.hashCode() : 0);
            _result = 31 * _result + (this.premium != null ? this.premium.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "FxAccrualOption {putCallCurrencyModel=" + this.putCallCurrencyModel + ", notionalAmount=" + this.notionalAmount + ", accrual=" + this.accrual + ", fxExpiryDateOrScheduleModel=" + this.fxExpiryDateOrScheduleModel + ", fxSettlementDateOrScheduleModel=" + this.fxSettlementDateOrScheduleModel + ", exerciseProcedure=" + this.exerciseProcedure + ", spotRate=" + this.spotRate + ", fxAccrualOptionSequence=" + this.fxAccrualOptionSequence + ", averageStrike=" + this.averageStrike + ", averageRate=" + this.averageRate + ", barrier=" + this.barrier + ", premium=" + this.premium + '}' + " " + super.toString();
        }
    }
}

