/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CurrentPriorCommitmentModel;
import fpml.confirmation.FacilityReference;
import fpml.confirmation.OutstandingsPosition;
import fpml.confirmation.meta.FacilityPositionMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="FacilityPosition", builder=FacilityPositionBuilderImpl.class, version="0.17.2")
@RuneDataType(value="FacilityPosition", model="fpml", builder=FacilityPositionBuilderImpl.class, version="0.17.2")
public interface FacilityPosition
extends RosettaModelObject {
    public static final FacilityPositionMeta metaData = new FacilityPositionMeta();

    public FacilityReference getFacilityReference();

    public CurrentPriorCommitmentModel getCurrentPriorCommitmentModel();

    public List<? extends OutstandingsPosition> getOutstandingsPosition();

    public FacilityPosition build();

    public FacilityPositionBuilder toBuilder();

    public static FacilityPositionBuilder builder() {
        return new FacilityPositionBuilderImpl();
    }

    default public RosettaMetaData<? extends FacilityPosition> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends FacilityPosition> getType() {
        return FacilityPosition.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.class, this.getFacilityReference(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currentPriorCommitmentModel"), processor, CurrentPriorCommitmentModel.class, this.getCurrentPriorCommitmentModel(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("outstandingsPosition"), processor, OutstandingsPosition.class, this.getOutstandingsPosition(), new AttributeMeta[0]);
    }

    public static class FacilityPositionBuilderImpl
    implements FacilityPositionBuilder {
        protected FacilityReference.FacilityReferenceBuilder facilityReference;
        protected CurrentPriorCommitmentModel.CurrentPriorCommitmentModelBuilder currentPriorCommitmentModel;
        protected List<OutstandingsPosition.OutstandingsPositionBuilder> outstandingsPosition = new ArrayList<OutstandingsPosition.OutstandingsPositionBuilder>();

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference.FacilityReferenceBuilder getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference() {
            FacilityReference.FacilityReferenceBuilder result = this.facilityReference != null ? this.facilityReference : (this.facilityReference = FacilityReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="currentPriorCommitmentModel", isRequired=true)
        @RuneAttribute(value="currentPriorCommitmentModel", isRequired=true)
        public CurrentPriorCommitmentModel.CurrentPriorCommitmentModelBuilder getCurrentPriorCommitmentModel() {
            return this.currentPriorCommitmentModel;
        }

        @Override
        public CurrentPriorCommitmentModel.CurrentPriorCommitmentModelBuilder getOrCreateCurrentPriorCommitmentModel() {
            CurrentPriorCommitmentModel.CurrentPriorCommitmentModelBuilder result = this.currentPriorCommitmentModel != null ? this.currentPriorCommitmentModel : (this.currentPriorCommitmentModel = CurrentPriorCommitmentModel.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="outstandingsPosition")
        @RuneAttribute(value="outstandingsPosition")
        public List<? extends OutstandingsPosition.OutstandingsPositionBuilder> getOutstandingsPosition() {
            return this.outstandingsPosition;
        }

        @Override
        public OutstandingsPosition.OutstandingsPositionBuilder getOrCreateOutstandingsPosition(int index) {
            if (this.outstandingsPosition == null) {
                this.outstandingsPosition = new ArrayList<OutstandingsPosition.OutstandingsPositionBuilder>();
            }
            return (OutstandingsPosition.OutstandingsPositionBuilder)this.getIndex(this.outstandingsPosition, index, () -> {
                OutstandingsPosition.OutstandingsPositionBuilder newOutstandingsPosition = OutstandingsPosition.builder();
                return newOutstandingsPosition;
            });
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityPositionBuilder setFacilityReference(FacilityReference _facilityReference) {
            this.facilityReference = _facilityReference == null ? null : _facilityReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="currentPriorCommitmentModel", isRequired=true)
        @RuneAttribute(value="currentPriorCommitmentModel", isRequired=true)
        public FacilityPositionBuilder setCurrentPriorCommitmentModel(CurrentPriorCommitmentModel _currentPriorCommitmentModel) {
            this.currentPriorCommitmentModel = _currentPriorCommitmentModel == null ? null : _currentPriorCommitmentModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="outstandingsPosition")
        @RuneAttribute(value="outstandingsPosition")
        public FacilityPositionBuilder addOutstandingsPosition(OutstandingsPosition _outstandingsPosition) {
            if (_outstandingsPosition != null) {
                this.outstandingsPosition.add(_outstandingsPosition.toBuilder());
            }
            return this;
        }

        @Override
        public FacilityPositionBuilder addOutstandingsPosition(OutstandingsPosition _outstandingsPosition, int idx) {
            this.getIndex(this.outstandingsPosition, idx, () -> _outstandingsPosition.toBuilder());
            return this;
        }

        @Override
        public FacilityPositionBuilder addOutstandingsPosition(List<? extends OutstandingsPosition> outstandingsPositions) {
            if (outstandingsPositions != null) {
                for (OutstandingsPosition outstandingsPosition : outstandingsPositions) {
                    this.outstandingsPosition.add(outstandingsPosition.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="outstandingsPosition")
        public FacilityPositionBuilder setOutstandingsPosition(List<? extends OutstandingsPosition> outstandingsPositions) {
            this.outstandingsPosition = outstandingsPositions == null ? new ArrayList<OutstandingsPosition.OutstandingsPositionBuilder>() : (List)outstandingsPositions.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public FacilityPosition build() {
            return new FacilityPositionImpl(this);
        }

        @Override
        public FacilityPositionBuilder toBuilder() {
            return this;
        }

        @Override
        public FacilityPositionBuilder prune() {
            if (this.facilityReference != null && !this.facilityReference.prune().hasData()) {
                this.facilityReference = null;
            }
            if (this.currentPriorCommitmentModel != null && !this.currentPriorCommitmentModel.prune().hasData()) {
                this.currentPriorCommitmentModel = null;
            }
            this.outstandingsPosition = this.outstandingsPosition.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getFacilityReference() != null && this.getFacilityReference().hasData()) {
                return true;
            }
            if (this.getCurrentPriorCommitmentModel() != null && this.getCurrentPriorCommitmentModel().hasData()) {
                return true;
            }
            return this.getOutstandingsPosition() != null && this.getOutstandingsPosition().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public FacilityPositionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            FacilityPositionBuilder o = (FacilityPositionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getFacilityReference(), (RosettaModelObjectBuilder)o.getFacilityReference(), this::setFacilityReference);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getCurrentPriorCommitmentModel(), (RosettaModelObjectBuilder)o.getCurrentPriorCommitmentModel(), this::setCurrentPriorCommitmentModel);
            merger.mergeRosetta(this.getOutstandingsPosition(), o.getOutstandingsPosition(), this::getOrCreateOutstandingsPosition);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityPosition _that = this.getType().cast(o);
            if (!Objects.equals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            if (!Objects.equals(this.currentPriorCommitmentModel, _that.getCurrentPriorCommitmentModel())) {
                return false;
            }
            return ListEquals.listEquals(this.outstandingsPosition, _that.getOutstandingsPosition());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.currentPriorCommitmentModel != null ? this.currentPriorCommitmentModel.hashCode() : 0);
            _result = 31 * _result + (this.outstandingsPosition != null ? this.outstandingsPosition.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityPositionBuilder {facilityReference=" + this.facilityReference + ", currentPriorCommitmentModel=" + this.currentPriorCommitmentModel + ", outstandingsPosition=" + this.outstandingsPosition + '}';
        }
    }

    public static interface FacilityPositionBuilder
    extends FacilityPosition,
    RosettaModelObjectBuilder {
        public FacilityReference.FacilityReferenceBuilder getOrCreateFacilityReference();

        @Override
        public FacilityReference.FacilityReferenceBuilder getFacilityReference();

        public CurrentPriorCommitmentModel.CurrentPriorCommitmentModelBuilder getOrCreateCurrentPriorCommitmentModel();

        @Override
        public CurrentPriorCommitmentModel.CurrentPriorCommitmentModelBuilder getCurrentPriorCommitmentModel();

        public OutstandingsPosition.OutstandingsPositionBuilder getOrCreateOutstandingsPosition(int var1);

        public List<? extends OutstandingsPosition.OutstandingsPositionBuilder> getOutstandingsPosition();

        public FacilityPositionBuilder setFacilityReference(FacilityReference var1);

        public FacilityPositionBuilder setCurrentPriorCommitmentModel(CurrentPriorCommitmentModel var1);

        public FacilityPositionBuilder addOutstandingsPosition(OutstandingsPosition var1);

        public FacilityPositionBuilder addOutstandingsPosition(OutstandingsPosition var1, int var2);

        public FacilityPositionBuilder addOutstandingsPosition(List<? extends OutstandingsPosition> var1);

        public FacilityPositionBuilder setOutstandingsPosition(List<? extends OutstandingsPosition> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("facilityReference"), processor, FacilityReference.FacilityReferenceBuilder.class, this.getFacilityReference(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currentPriorCommitmentModel"), processor, CurrentPriorCommitmentModel.CurrentPriorCommitmentModelBuilder.class, this.getCurrentPriorCommitmentModel(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("outstandingsPosition"), processor, OutstandingsPosition.OutstandingsPositionBuilder.class, this.getOutstandingsPosition(), new AttributeMeta[0]);
        }

        public FacilityPositionBuilder prune();
    }

    public static class FacilityPositionImpl
    implements FacilityPosition {
        private final FacilityReference facilityReference;
        private final CurrentPriorCommitmentModel currentPriorCommitmentModel;
        private final List<? extends OutstandingsPosition> outstandingsPosition;

        protected FacilityPositionImpl(FacilityPositionBuilder builder) {
            this.facilityReference = Optional.ofNullable(builder.getFacilityReference()).map(f -> f.build()).orElse(null);
            this.currentPriorCommitmentModel = Optional.ofNullable(builder.getCurrentPriorCommitmentModel()).map(f -> f.build()).orElse(null);
            this.outstandingsPosition = Optional.ofNullable(builder.getOutstandingsPosition()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="facilityReference", isRequired=true)
        @RuneAttribute(value="facilityReference", isRequired=true)
        public FacilityReference getFacilityReference() {
            return this.facilityReference;
        }

        @Override
        @RosettaAttribute(value="currentPriorCommitmentModel", isRequired=true)
        @RuneAttribute(value="currentPriorCommitmentModel", isRequired=true)
        public CurrentPriorCommitmentModel getCurrentPriorCommitmentModel() {
            return this.currentPriorCommitmentModel;
        }

        @Override
        @RosettaAttribute(value="outstandingsPosition")
        @RuneAttribute(value="outstandingsPosition")
        public List<? extends OutstandingsPosition> getOutstandingsPosition() {
            return this.outstandingsPosition;
        }

        @Override
        public FacilityPosition build() {
            return this;
        }

        @Override
        public FacilityPositionBuilder toBuilder() {
            FacilityPositionBuilder builder = FacilityPosition.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(FacilityPositionBuilder builder) {
            Optional.ofNullable(this.getFacilityReference()).ifPresent(builder::setFacilityReference);
            Optional.ofNullable(this.getCurrentPriorCommitmentModel()).ifPresent(builder::setCurrentPriorCommitmentModel);
            Optional.ofNullable(this.getOutstandingsPosition()).ifPresent(builder::setOutstandingsPosition);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            FacilityPosition _that = this.getType().cast(o);
            if (!Objects.equals(this.facilityReference, _that.getFacilityReference())) {
                return false;
            }
            if (!Objects.equals(this.currentPriorCommitmentModel, _that.getCurrentPriorCommitmentModel())) {
                return false;
            }
            return ListEquals.listEquals(this.outstandingsPosition, _that.getOutstandingsPosition());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.facilityReference != null ? this.facilityReference.hashCode() : 0);
            _result = 31 * _result + (this.currentPriorCommitmentModel != null ? this.currentPriorCommitmentModel.hashCode() : 0);
            _result = 31 * _result + (this.outstandingsPosition != null ? this.outstandingsPosition.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "FacilityPosition {facilityReference=" + this.facilityReference + ", currentPriorCommitmentModel=" + this.currentPriorCommitmentModel + ", outstandingsPosition=" + this.outstandingsPosition + '}';
        }
    }
}

