/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import fpml.confirmation.AdjustableOrRelativeDate;
import fpml.confirmation.ClearanceSystem;
import fpml.confirmation.ExchangeId;
import fpml.confirmation.ExchangeIdentifierModel;
import fpml.confirmation.ExchangeTraded;
import fpml.confirmation.IdentifiedCurrency;
import fpml.confirmation.InstrumentId;
import fpml.confirmation.InstrumentType;
import fpml.confirmation.ProductReference;
import fpml.confirmation.meta.ExchangeTradedContractMeta;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ExchangeTradedContract", builder=ExchangeTradedContractBuilderImpl.class, version="0.17.2")
@RuneDataType(value="ExchangeTradedContract", model="fpml", builder=ExchangeTradedContractBuilderImpl.class, version="0.17.2")
public interface ExchangeTradedContract
extends ExchangeTraded {
    public static final ExchangeTradedContractMeta metaData = new ExchangeTradedContractMeta();

    public BigDecimal getMultiplier();

    public String getContractReference();

    public AdjustableOrRelativeDate getExpirationDate();

    @Override
    public ExchangeTradedContract build();

    @Override
    public ExchangeTradedContractBuilder toBuilder();

    public static ExchangeTradedContractBuilder builder() {
        return new ExchangeTradedContractBuilderImpl();
    }

    default public RosettaMetaData<? extends ExchangeTradedContract> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ExchangeTradedContract> getType() {
        return ExchangeTradedContract.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.class, this.getInstrumentId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.class, this.getInstrumentType(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.class, this.getCurrency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.class, this.getExchangeId(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.class, this.getClearanceSystem(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("definition"), processor, ProductReference.class, this.getDefinition(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.class, this.getExchangeIdentifierModel(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.class, this.getExpirationDate(), new AttributeMeta[0]);
    }

    public static class ExchangeTradedContractBuilderImpl
    extends ExchangeTraded.ExchangeTradedBuilderImpl
    implements ExchangeTradedContractBuilder {
        protected BigDecimal multiplier;
        protected String contractReference;
        protected AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder expirationDate;

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="contractReference")
        @RuneAttribute(value="contractReference")
        public String getContractReference() {
            return this.contractReference;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate() {
            AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder result = this.expirationDate != null ? this.expirationDate : (this.expirationDate = AdjustableOrRelativeDate.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="id")
        @RuneAttribute(value="id")
        public ExchangeTradedContractBuilder setId(String _id) {
            this.id = _id == null ? null : _id;
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentId", isRequired=true)
        @RuneAttribute(value="instrumentId", isRequired=true)
        public ExchangeTradedContractBuilder addInstrumentId(InstrumentId _instrumentId) {
            if (_instrumentId != null) {
                this.instrumentId.add(_instrumentId.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedContractBuilder addInstrumentId(InstrumentId _instrumentId, int idx) {
            this.getIndex(this.instrumentId, idx, () -> _instrumentId.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedContractBuilder addInstrumentId(List<? extends InstrumentId> instrumentIds) {
            if (instrumentIds != null) {
                for (InstrumentId instrumentId : instrumentIds) {
                    this.instrumentId.add(instrumentId.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentId")
        public ExchangeTradedContractBuilder setInstrumentId(List<? extends InstrumentId> instrumentIds) {
            this.instrumentId = instrumentIds == null ? new ArrayList() : (List)instrumentIds.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="instrumentType")
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedContractBuilder addInstrumentType(InstrumentType _instrumentType) {
            if (_instrumentType != null) {
                this.instrumentType.add(_instrumentType.toBuilder());
            }
            return this;
        }

        @Override
        public ExchangeTradedContractBuilder addInstrumentType(InstrumentType _instrumentType, int idx) {
            this.getIndex(this.instrumentType, idx, () -> _instrumentType.toBuilder());
            return this;
        }

        @Override
        public ExchangeTradedContractBuilder addInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            if (instrumentTypes != null) {
                for (InstrumentType instrumentType : instrumentTypes) {
                    this.instrumentType.add(instrumentType.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="instrumentType")
        public ExchangeTradedContractBuilder setInstrumentType(List<? extends InstrumentType> instrumentTypes) {
            this.instrumentType = instrumentTypes == null ? new ArrayList() : (List)instrumentTypes.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="description")
        @RuneAttribute(value="description")
        public ExchangeTradedContractBuilder setDescription(String _description) {
            this.description = _description == null ? null : _description;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public ExchangeTradedContractBuilder setCurrency(IdentifiedCurrency _currency) {
            this.currency = _currency == null ? null : _currency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeId")
        @RuneAttribute(value="exchangeId")
        public ExchangeTradedContractBuilder setExchangeId(ExchangeId _exchangeId) {
            this.exchangeId = _exchangeId == null ? null : _exchangeId.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="clearanceSystem")
        @RuneAttribute(value="clearanceSystem")
        public ExchangeTradedContractBuilder setClearanceSystem(ClearanceSystem _clearanceSystem) {
            this.clearanceSystem = _clearanceSystem == null ? null : _clearanceSystem.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="definition")
        @RuneAttribute(value="definition")
        public ExchangeTradedContractBuilder setDefinition(ProductReference _definition) {
            this.definition = _definition == null ? null : _definition.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="exchangeIdentifierModel", isRequired=true)
        @RuneAttribute(value="exchangeIdentifierModel", isRequired=true)
        public ExchangeTradedContractBuilder setExchangeIdentifierModel(ExchangeIdentifierModel _exchangeIdentifierModel) {
            this.exchangeIdentifierModel = _exchangeIdentifierModel == null ? null : _exchangeIdentifierModel.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public ExchangeTradedContractBuilder setMultiplier(BigDecimal _multiplier) {
            this.multiplier = _multiplier == null ? null : _multiplier;
            return this;
        }

        @Override
        @RosettaAttribute(value="contractReference")
        @RuneAttribute(value="contractReference")
        public ExchangeTradedContractBuilder setContractReference(String _contractReference) {
            this.contractReference = _contractReference == null ? null : _contractReference;
            return this;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public ExchangeTradedContractBuilder setExpirationDate(AdjustableOrRelativeDate _expirationDate) {
            this.expirationDate = _expirationDate == null ? null : _expirationDate.toBuilder();
            return this;
        }

        @Override
        public ExchangeTradedContract build() {
            return new ExchangeTradedContractImpl(this);
        }

        @Override
        public ExchangeTradedContractBuilder toBuilder() {
            return this;
        }

        @Override
        public ExchangeTradedContractBuilder prune() {
            super.prune();
            if (this.expirationDate != null && !this.expirationDate.prune().hasData()) {
                this.expirationDate = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            if (this.getMultiplier() != null) {
                return true;
            }
            if (this.getContractReference() != null) {
                return true;
            }
            return this.getExpirationDate() != null && this.getExpirationDate().hasData();
        }

        @Override
        public ExchangeTradedContractBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ExchangeTradedContractBuilder o = (ExchangeTradedContractBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getExpirationDate(), (RosettaModelObjectBuilder)o.getExpirationDate(), this::setExpirationDate);
            merger.mergeBasic((Object)this.getMultiplier(), (Object)o.getMultiplier(), this::setMultiplier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getContractReference(), (Object)o.getContractReference(), this::setContractReference, new AttributeMeta[0]);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTradedContract _that = (ExchangeTradedContract)this.getType().cast(o);
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.contractReference, _that.getContractReference())) {
                return false;
            }
            return Objects.equals(this.expirationDate, _that.getExpirationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.contractReference != null ? this.contractReference.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTradedContractBuilder {multiplier=" + this.multiplier + ", contractReference=" + this.contractReference + ", expirationDate=" + this.expirationDate + '}' + " " + super.toString();
        }
    }

    public static interface ExchangeTradedContractBuilder
    extends ExchangeTradedContract,
    ExchangeTraded.ExchangeTradedBuilder {
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getOrCreateExpirationDate();

        @Override
        public AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder getExpirationDate();

        @Override
        public ExchangeTradedContractBuilder setId(String var1);

        @Override
        public ExchangeTradedContractBuilder addInstrumentId(InstrumentId var1);

        @Override
        public ExchangeTradedContractBuilder addInstrumentId(InstrumentId var1, int var2);

        @Override
        public ExchangeTradedContractBuilder addInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedContractBuilder setInstrumentId(List<? extends InstrumentId> var1);

        @Override
        public ExchangeTradedContractBuilder addInstrumentType(InstrumentType var1);

        @Override
        public ExchangeTradedContractBuilder addInstrumentType(InstrumentType var1, int var2);

        @Override
        public ExchangeTradedContractBuilder addInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedContractBuilder setInstrumentType(List<? extends InstrumentType> var1);

        @Override
        public ExchangeTradedContractBuilder setDescription(String var1);

        @Override
        public ExchangeTradedContractBuilder setCurrency(IdentifiedCurrency var1);

        @Override
        public ExchangeTradedContractBuilder setExchangeId(ExchangeId var1);

        @Override
        public ExchangeTradedContractBuilder setClearanceSystem(ClearanceSystem var1);

        @Override
        public ExchangeTradedContractBuilder setDefinition(ProductReference var1);

        @Override
        public ExchangeTradedContractBuilder setExchangeIdentifierModel(ExchangeIdentifierModel var1);

        public ExchangeTradedContractBuilder setMultiplier(BigDecimal var1);

        public ExchangeTradedContractBuilder setContractReference(String var1);

        public ExchangeTradedContractBuilder setExpirationDate(AdjustableOrRelativeDate var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("id"), String.class, (Object)this.getId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentId"), processor, InstrumentId.InstrumentIdBuilder.class, this.getInstrumentId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("instrumentType"), processor, InstrumentType.InstrumentTypeBuilder.class, this.getInstrumentType(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("description"), String.class, (Object)this.getDescription(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("currency"), processor, IdentifiedCurrency.IdentifiedCurrencyBuilder.class, (RosettaModelObjectBuilder)this.getCurrency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeId"), processor, ExchangeId.ExchangeIdBuilder.class, (RosettaModelObjectBuilder)this.getExchangeId(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("clearanceSystem"), processor, ClearanceSystem.ClearanceSystemBuilder.class, (RosettaModelObjectBuilder)this.getClearanceSystem(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("definition"), processor, ProductReference.ProductReferenceBuilder.class, (RosettaModelObjectBuilder)this.getDefinition(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("exchangeIdentifierModel"), processor, ExchangeIdentifierModel.ExchangeIdentifierModelBuilder.class, (RosettaModelObjectBuilder)this.getExchangeIdentifierModel(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("multiplier"), BigDecimal.class, (Object)this.getMultiplier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("contractReference"), String.class, (Object)this.getContractReference(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("expirationDate"), processor, AdjustableOrRelativeDate.AdjustableOrRelativeDateBuilder.class, this.getExpirationDate(), new AttributeMeta[0]);
        }

        @Override
        public ExchangeTradedContractBuilder prune();
    }

    public static class ExchangeTradedContractImpl
    extends ExchangeTraded.ExchangeTradedImpl
    implements ExchangeTradedContract {
        private final BigDecimal multiplier;
        private final String contractReference;
        private final AdjustableOrRelativeDate expirationDate;

        protected ExchangeTradedContractImpl(ExchangeTradedContractBuilder builder) {
            super(builder);
            this.multiplier = builder.getMultiplier();
            this.contractReference = builder.getContractReference();
            this.expirationDate = Optional.ofNullable(builder.getExpirationDate()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="multiplier")
        @RuneAttribute(value="multiplier")
        public BigDecimal getMultiplier() {
            return this.multiplier;
        }

        @Override
        @RosettaAttribute(value="contractReference")
        @RuneAttribute(value="contractReference")
        public String getContractReference() {
            return this.contractReference;
        }

        @Override
        @RosettaAttribute(value="expirationDate")
        @RuneAttribute(value="expirationDate")
        public AdjustableOrRelativeDate getExpirationDate() {
            return this.expirationDate;
        }

        @Override
        public ExchangeTradedContract build() {
            return this;
        }

        @Override
        public ExchangeTradedContractBuilder toBuilder() {
            ExchangeTradedContractBuilder builder = ExchangeTradedContract.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ExchangeTradedContractBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getMultiplier()).ifPresent(builder::setMultiplier);
            Optional.ofNullable(this.getContractReference()).ifPresent(builder::setContractReference);
            Optional.ofNullable(this.getExpirationDate()).ifPresent(builder::setExpirationDate);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExchangeTradedContract _that = (ExchangeTradedContract)this.getType().cast(o);
            if (!Objects.equals(this.multiplier, _that.getMultiplier())) {
                return false;
            }
            if (!Objects.equals(this.contractReference, _that.getContractReference())) {
                return false;
            }
            return Objects.equals(this.expirationDate, _that.getExpirationDate());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.multiplier != null ? this.multiplier.hashCode() : 0);
            _result = 31 * _result + (this.contractReference != null ? this.contractReference.hashCode() : 0);
            _result = 31 * _result + (this.expirationDate != null ? this.expirationDate.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ExchangeTradedContract {multiplier=" + this.multiplier + ", contractReference=" + this.contractReference + ", expirationDate=" + this.expirationDate + '}' + " " + super.toString();
        }
    }
}

