/*
 * Decompiled with CFR 0.152.
 */
package fpml.confirmation;

import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import fpml.confirmation.CreditLimit;
import fpml.confirmation.LimitModelEnum;
import fpml.confirmation.PartyTradeInformation;
import fpml.confirmation.meta.CreditLimitInformationMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="CreditLimitInformation", builder=CreditLimitInformationBuilderImpl.class, version="0.17.2")
@RuneDataType(value="CreditLimitInformation", model="fpml", builder=CreditLimitInformationBuilderImpl.class, version="0.17.2")
public interface CreditLimitInformation
extends RosettaModelObject {
    public static final CreditLimitInformationMeta metaData = new CreditLimitInformationMeta();

    public PartyTradeInformation getPartyInformation();

    public LimitModelEnum getLimitModel();

    public List<? extends CreditLimit> getCreditLimit();

    public CreditLimitInformation build();

    public CreditLimitInformationBuilder toBuilder();

    public static CreditLimitInformationBuilder builder() {
        return new CreditLimitInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends CreditLimitInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CreditLimitInformation> getType() {
        return CreditLimitInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("partyInformation"), processor, PartyTradeInformation.class, this.getPartyInformation(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("limitModel"), LimitModelEnum.class, (Object)this.getLimitModel(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("creditLimit"), processor, CreditLimit.class, this.getCreditLimit(), new AttributeMeta[0]);
    }

    public static class CreditLimitInformationBuilderImpl
    implements CreditLimitInformationBuilder {
        protected PartyTradeInformation.PartyTradeInformationBuilder partyInformation;
        protected LimitModelEnum limitModel;
        protected List<CreditLimit.CreditLimitBuilder> creditLimit = new ArrayList<CreditLimit.CreditLimitBuilder>();

        @Override
        @RosettaAttribute(value="partyInformation", isRequired=true)
        @RuneAttribute(value="partyInformation", isRequired=true)
        public PartyTradeInformation.PartyTradeInformationBuilder getPartyInformation() {
            return this.partyInformation;
        }

        @Override
        public PartyTradeInformation.PartyTradeInformationBuilder getOrCreatePartyInformation() {
            PartyTradeInformation.PartyTradeInformationBuilder result = this.partyInformation != null ? this.partyInformation : (this.partyInformation = PartyTradeInformation.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="limitModel", isRequired=true)
        @RuneAttribute(value="limitModel", isRequired=true)
        public LimitModelEnum getLimitModel() {
            return this.limitModel;
        }

        @Override
        @RosettaAttribute(value="creditLimit", isRequired=true)
        @RuneAttribute(value="creditLimit", isRequired=true)
        public List<? extends CreditLimit.CreditLimitBuilder> getCreditLimit() {
            return this.creditLimit;
        }

        @Override
        public CreditLimit.CreditLimitBuilder getOrCreateCreditLimit(int index) {
            if (this.creditLimit == null) {
                this.creditLimit = new ArrayList<CreditLimit.CreditLimitBuilder>();
            }
            return (CreditLimit.CreditLimitBuilder)this.getIndex(this.creditLimit, index, () -> {
                CreditLimit.CreditLimitBuilder newCreditLimit = CreditLimit.builder();
                return newCreditLimit;
            });
        }

        @Override
        @RosettaAttribute(value="partyInformation", isRequired=true)
        @RuneAttribute(value="partyInformation", isRequired=true)
        public CreditLimitInformationBuilder setPartyInformation(PartyTradeInformation _partyInformation) {
            this.partyInformation = _partyInformation == null ? null : _partyInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="limitModel", isRequired=true)
        @RuneAttribute(value="limitModel", isRequired=true)
        public CreditLimitInformationBuilder setLimitModel(LimitModelEnum _limitModel) {
            this.limitModel = _limitModel == null ? null : _limitModel;
            return this;
        }

        @Override
        @RosettaAttribute(value="creditLimit", isRequired=true)
        @RuneAttribute(value="creditLimit", isRequired=true)
        public CreditLimitInformationBuilder addCreditLimit(CreditLimit _creditLimit) {
            if (_creditLimit != null) {
                this.creditLimit.add(_creditLimit.toBuilder());
            }
            return this;
        }

        @Override
        public CreditLimitInformationBuilder addCreditLimit(CreditLimit _creditLimit, int idx) {
            this.getIndex(this.creditLimit, idx, () -> _creditLimit.toBuilder());
            return this;
        }

        @Override
        public CreditLimitInformationBuilder addCreditLimit(List<? extends CreditLimit> creditLimits) {
            if (creditLimits != null) {
                for (CreditLimit creditLimit : creditLimits) {
                    this.creditLimit.add(creditLimit.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="creditLimit")
        public CreditLimitInformationBuilder setCreditLimit(List<? extends CreditLimit> creditLimits) {
            this.creditLimit = creditLimits == null ? new ArrayList<CreditLimit.CreditLimitBuilder>() : (List)creditLimits.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public CreditLimitInformation build() {
            return new CreditLimitInformationImpl(this);
        }

        @Override
        public CreditLimitInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public CreditLimitInformationBuilder prune() {
            if (this.partyInformation != null && !this.partyInformation.prune().hasData()) {
                this.partyInformation = null;
            }
            this.creditLimit = this.creditLimit.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getPartyInformation() != null && this.getPartyInformation().hasData()) {
                return true;
            }
            if (this.getLimitModel() != null) {
                return true;
            }
            return this.getCreditLimit() != null && this.getCreditLimit().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public CreditLimitInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CreditLimitInformationBuilder o = (CreditLimitInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getPartyInformation(), (RosettaModelObjectBuilder)o.getPartyInformation(), this::setPartyInformation);
            merger.mergeRosetta(this.getCreditLimit(), o.getCreditLimit(), this::getOrCreateCreditLimit);
            merger.mergeBasic((Object)this.getLimitModel(), (Object)o.getLimitModel(), this::setLimitModel, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditLimitInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyInformation, _that.getPartyInformation())) {
                return false;
            }
            if (!Objects.equals((Object)this.limitModel, (Object)_that.getLimitModel())) {
                return false;
            }
            return ListEquals.listEquals(this.creditLimit, _that.getCreditLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyInformation != null ? this.partyInformation.hashCode() : 0);
            _result = 31 * _result + (this.limitModel != null ? ((Object)((Object)this.limitModel)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditLimit != null ? this.creditLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditLimitInformationBuilder {partyInformation=" + this.partyInformation + ", limitModel=" + (Object)((Object)this.limitModel) + ", creditLimit=" + this.creditLimit + '}';
        }
    }

    public static interface CreditLimitInformationBuilder
    extends CreditLimitInformation,
    RosettaModelObjectBuilder {
        public PartyTradeInformation.PartyTradeInformationBuilder getOrCreatePartyInformation();

        @Override
        public PartyTradeInformation.PartyTradeInformationBuilder getPartyInformation();

        public CreditLimit.CreditLimitBuilder getOrCreateCreditLimit(int var1);

        public List<? extends CreditLimit.CreditLimitBuilder> getCreditLimit();

        public CreditLimitInformationBuilder setPartyInformation(PartyTradeInformation var1);

        public CreditLimitInformationBuilder setLimitModel(LimitModelEnum var1);

        public CreditLimitInformationBuilder addCreditLimit(CreditLimit var1);

        public CreditLimitInformationBuilder addCreditLimit(CreditLimit var1, int var2);

        public CreditLimitInformationBuilder addCreditLimit(List<? extends CreditLimit> var1);

        public CreditLimitInformationBuilder setCreditLimit(List<? extends CreditLimit> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("partyInformation"), processor, PartyTradeInformation.PartyTradeInformationBuilder.class, this.getPartyInformation(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("limitModel"), LimitModelEnum.class, (Object)this.getLimitModel(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("creditLimit"), processor, CreditLimit.CreditLimitBuilder.class, this.getCreditLimit(), new AttributeMeta[0]);
        }

        public CreditLimitInformationBuilder prune();
    }

    public static class CreditLimitInformationImpl
    implements CreditLimitInformation {
        private final PartyTradeInformation partyInformation;
        private final LimitModelEnum limitModel;
        private final List<? extends CreditLimit> creditLimit;

        protected CreditLimitInformationImpl(CreditLimitInformationBuilder builder) {
            this.partyInformation = Optional.ofNullable(builder.getPartyInformation()).map(f -> f.build()).orElse(null);
            this.limitModel = builder.getLimitModel();
            this.creditLimit = Optional.ofNullable(builder.getCreditLimit()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="partyInformation", isRequired=true)
        @RuneAttribute(value="partyInformation", isRequired=true)
        public PartyTradeInformation getPartyInformation() {
            return this.partyInformation;
        }

        @Override
        @RosettaAttribute(value="limitModel", isRequired=true)
        @RuneAttribute(value="limitModel", isRequired=true)
        public LimitModelEnum getLimitModel() {
            return this.limitModel;
        }

        @Override
        @RosettaAttribute(value="creditLimit", isRequired=true)
        @RuneAttribute(value="creditLimit", isRequired=true)
        public List<? extends CreditLimit> getCreditLimit() {
            return this.creditLimit;
        }

        @Override
        public CreditLimitInformation build() {
            return this;
        }

        @Override
        public CreditLimitInformationBuilder toBuilder() {
            CreditLimitInformationBuilder builder = CreditLimitInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CreditLimitInformationBuilder builder) {
            Optional.ofNullable(this.getPartyInformation()).ifPresent(builder::setPartyInformation);
            Optional.ofNullable(this.getLimitModel()).ifPresent(builder::setLimitModel);
            Optional.ofNullable(this.getCreditLimit()).ifPresent(builder::setCreditLimit);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CreditLimitInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.partyInformation, _that.getPartyInformation())) {
                return false;
            }
            if (!Objects.equals((Object)this.limitModel, (Object)_that.getLimitModel())) {
                return false;
            }
            return ListEquals.listEquals(this.creditLimit, _that.getCreditLimit());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.partyInformation != null ? this.partyInformation.hashCode() : 0);
            _result = 31 * _result + (this.limitModel != null ? ((Object)((Object)this.limitModel)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.creditLimit != null ? this.creditLimit.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CreditLimitInformation {partyInformation=" + this.partyInformation + ", limitModel=" + (Object)((Object)this.limitModel) + ", creditLimit=" + this.creditLimit + '}';
        }
    }
}

