/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.FixedPrice;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="FixedPriceNonNegativePrice_datedValue")
@ImplementedBy(value=Default.class)
public interface FixedPriceNonNegativePrice_datedValue
extends Validator<FixedPrice> {
    public static final String NAME = "FixedPriceNonNegativePrice_datedValue";
    public static final String DEFINITION = "if price -> datedValue exists then price -> datedValue -> value all >= 0.0";

    public static class NoOp
    implements FixedPriceNonNegativePrice_datedValue {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FixedPrice fixedPrice) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements FixedPriceNonNegativePrice_datedValue {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, FixedPrice fixedPrice) {
            ComparisonResult result = this.executeDataRule(fixedPrice);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)FixedPriceNonNegativePrice_datedValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FixedPrice", (RosettaPath)path, (String)FixedPriceNonNegativePrice_datedValue.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)FixedPriceNonNegativePrice_datedValue.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"FixedPrice", (RosettaPath)path, (String)FixedPriceNonNegativePrice_datedValue.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(FixedPrice fixedPrice) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fixedPrice).map("getPrice", _fixedPrice -> _fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule0 -> referenceWithMetaPriceSchedule0 == null ? null : referenceWithMetaPriceSchedule0.getValue()).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.greaterThanEquals((Mapper)MapperS.of((Object)fixedPrice).map("getPrice", _fixedPrice -> _fixedPrice.getPrice()).map("Type coercion", referenceWithMetaPriceSchedule1 -> referenceWithMetaPriceSchedule1 == null ? null : referenceWithMetaPriceSchedule1.getValue()).mapC("getDatedValue", priceSchedule -> priceSchedule.getDatedValue()).map("getValue", datedValue -> datedValue.getValue()), (Mapper)MapperS.of((Object)new BigDecimal("0.0")), (CardinalityOperator)CardinalityOperator.All);
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

