/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.collateral;

import cdm.base.datetime.CalculationFrequency;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.product.collateral.CollateralInterestCalculationParameters;
import cdm.product.collateral.CollateralInterestHandlingParameters;
import cdm.product.collateral.CollateralMarginTypeEnum;
import cdm.product.collateral.meta.CollateralInterestParametersMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="CollateralInterestParameters", builder=CollateralInterestParametersBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="CollateralInterestParameters", model="cdm", builder=CollateralInterestParametersBuilderImpl.class, version="7.0.0-dev.50")
public interface CollateralInterestParameters
extends RosettaModelObject {
    public static final CollateralInterestParametersMeta metaData = new CollateralInterestParametersMeta();

    public CounterpartyRoleEnum getPostingParty();

    public CollateralMarginTypeEnum getMarginType();

    public String getCurrency();

    public CollateralInterestCalculationParameters getInterestCalculationParameters();

    public CalculationFrequency getInterestCalculationFrequency();

    public CollateralInterestHandlingParameters getInterestHandlingParameters();

    public CollateralInterestParameters build();

    public CollateralInterestParametersBuilder toBuilder();

    public static CollateralInterestParametersBuilder builder() {
        return new CollateralInterestParametersBuilderImpl();
    }

    default public RosettaMetaData<? extends CollateralInterestParameters> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends CollateralInterestParameters> getType() {
        return CollateralInterestParameters.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("postingParty"), CounterpartyRoleEnum.class, (Object)this.getPostingParty(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("marginType"), CollateralMarginTypeEnum.class, (Object)this.getMarginType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("currency"), String.class, (Object)this.getCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestCalculationParameters"), processor, CollateralInterestCalculationParameters.class, this.getInterestCalculationParameters(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestCalculationFrequency"), processor, CalculationFrequency.class, this.getInterestCalculationFrequency(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("interestHandlingParameters"), processor, CollateralInterestHandlingParameters.class, this.getInterestHandlingParameters(), new AttributeMeta[0]);
    }

    public static class CollateralInterestParametersBuilderImpl
    implements CollateralInterestParametersBuilder {
        protected CounterpartyRoleEnum postingParty;
        protected CollateralMarginTypeEnum marginType;
        protected String currency;
        protected CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder interestCalculationParameters;
        protected CalculationFrequency.CalculationFrequencyBuilder interestCalculationFrequency;
        protected CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder interestHandlingParameters;

        @Override
        @RosettaAttribute(value="postingParty")
        @RuneAttribute(value="postingParty")
        public CounterpartyRoleEnum getPostingParty() {
            return this.postingParty;
        }

        @Override
        @RosettaAttribute(value="marginType")
        @RuneAttribute(value="marginType")
        public CollateralMarginTypeEnum getMarginType() {
            return this.marginType;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public String getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="interestCalculationParameters")
        @RuneAttribute(value="interestCalculationParameters")
        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getInterestCalculationParameters() {
            return this.interestCalculationParameters;
        }

        @Override
        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getOrCreateInterestCalculationParameters() {
            CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder result = this.interestCalculationParameters != null ? this.interestCalculationParameters : (this.interestCalculationParameters = CollateralInterestCalculationParameters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestCalculationFrequency")
        @RuneAttribute(value="interestCalculationFrequency")
        public CalculationFrequency.CalculationFrequencyBuilder getInterestCalculationFrequency() {
            return this.interestCalculationFrequency;
        }

        @Override
        public CalculationFrequency.CalculationFrequencyBuilder getOrCreateInterestCalculationFrequency() {
            CalculationFrequency.CalculationFrequencyBuilder result = this.interestCalculationFrequency != null ? this.interestCalculationFrequency : (this.interestCalculationFrequency = CalculationFrequency.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="interestHandlingParameters")
        @RuneAttribute(value="interestHandlingParameters")
        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getInterestHandlingParameters() {
            return this.interestHandlingParameters;
        }

        @Override
        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getOrCreateInterestHandlingParameters() {
            CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder result = this.interestHandlingParameters != null ? this.interestHandlingParameters : (this.interestHandlingParameters = CollateralInterestHandlingParameters.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="postingParty")
        @RuneAttribute(value="postingParty")
        public CollateralInterestParametersBuilder setPostingParty(CounterpartyRoleEnum _postingParty) {
            this.postingParty = _postingParty == null ? null : _postingParty;
            return this;
        }

        @Override
        @RosettaAttribute(value="marginType")
        @RuneAttribute(value="marginType")
        public CollateralInterestParametersBuilder setMarginType(CollateralMarginTypeEnum _marginType) {
            this.marginType = _marginType == null ? null : _marginType;
            return this;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public CollateralInterestParametersBuilder setCurrency(String _currency) {
            this.currency = _currency == null ? null : _currency;
            return this;
        }

        @Override
        @RosettaAttribute(value="interestCalculationParameters")
        @RuneAttribute(value="interestCalculationParameters")
        public CollateralInterestParametersBuilder setInterestCalculationParameters(CollateralInterestCalculationParameters _interestCalculationParameters) {
            this.interestCalculationParameters = _interestCalculationParameters == null ? null : _interestCalculationParameters.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestCalculationFrequency")
        @RuneAttribute(value="interestCalculationFrequency")
        public CollateralInterestParametersBuilder setInterestCalculationFrequency(CalculationFrequency _interestCalculationFrequency) {
            this.interestCalculationFrequency = _interestCalculationFrequency == null ? null : _interestCalculationFrequency.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="interestHandlingParameters")
        @RuneAttribute(value="interestHandlingParameters")
        public CollateralInterestParametersBuilder setInterestHandlingParameters(CollateralInterestHandlingParameters _interestHandlingParameters) {
            this.interestHandlingParameters = _interestHandlingParameters == null ? null : _interestHandlingParameters.toBuilder();
            return this;
        }

        @Override
        public CollateralInterestParameters build() {
            return new CollateralInterestParametersImpl(this);
        }

        @Override
        public CollateralInterestParametersBuilder toBuilder() {
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder prune() {
            if (this.interestCalculationParameters != null && !this.interestCalculationParameters.prune().hasData()) {
                this.interestCalculationParameters = null;
            }
            if (this.interestCalculationFrequency != null && !this.interestCalculationFrequency.prune().hasData()) {
                this.interestCalculationFrequency = null;
            }
            if (this.interestHandlingParameters != null && !this.interestHandlingParameters.prune().hasData()) {
                this.interestHandlingParameters = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getPostingParty() != null) {
                return true;
            }
            if (this.getMarginType() != null) {
                return true;
            }
            if (this.getCurrency() != null) {
                return true;
            }
            if (this.getInterestCalculationParameters() != null && this.getInterestCalculationParameters().hasData()) {
                return true;
            }
            if (this.getInterestCalculationFrequency() != null && this.getInterestCalculationFrequency().hasData()) {
                return true;
            }
            return this.getInterestHandlingParameters() != null && this.getInterestHandlingParameters().hasData();
        }

        public CollateralInterestParametersBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            CollateralInterestParametersBuilder o = (CollateralInterestParametersBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestCalculationParameters(), (RosettaModelObjectBuilder)o.getInterestCalculationParameters(), this::setInterestCalculationParameters);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestCalculationFrequency(), (RosettaModelObjectBuilder)o.getInterestCalculationFrequency(), this::setInterestCalculationFrequency);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getInterestHandlingParameters(), (RosettaModelObjectBuilder)o.getInterestHandlingParameters(), this::setInterestHandlingParameters);
            merger.mergeBasic((Object)this.getPostingParty(), (Object)o.getPostingParty(), this::setPostingParty, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getMarginType(), (Object)o.getMarginType(), this::setMarginType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCurrency(), (Object)o.getCurrency(), this::setCurrency, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestParameters _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.postingParty, (Object)_that.getPostingParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.marginType, (Object)_that.getMarginType())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationParameters, _that.getInterestCalculationParameters())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationFrequency, _that.getInterestCalculationFrequency())) {
                return false;
            }
            return Objects.equals(this.interestHandlingParameters, _that.getInterestHandlingParameters());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.postingParty != null ? ((Object)((Object)this.postingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.marginType != null ? ((Object)((Object)this.marginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationParameters != null ? this.interestCalculationParameters.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationFrequency != null ? this.interestCalculationFrequency.hashCode() : 0);
            _result = 31 * _result + (this.interestHandlingParameters != null ? this.interestHandlingParameters.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestParametersBuilder {postingParty=" + (Object)((Object)this.postingParty) + ", marginType=" + (Object)((Object)this.marginType) + ", currency=" + this.currency + ", interestCalculationParameters=" + this.interestCalculationParameters + ", interestCalculationFrequency=" + this.interestCalculationFrequency + ", interestHandlingParameters=" + this.interestHandlingParameters + '}';
        }
    }

    public static interface CollateralInterestParametersBuilder
    extends CollateralInterestParameters,
    RosettaModelObjectBuilder {
        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getOrCreateInterestCalculationParameters();

        @Override
        public CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder getInterestCalculationParameters();

        public CalculationFrequency.CalculationFrequencyBuilder getOrCreateInterestCalculationFrequency();

        @Override
        public CalculationFrequency.CalculationFrequencyBuilder getInterestCalculationFrequency();

        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getOrCreateInterestHandlingParameters();

        @Override
        public CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder getInterestHandlingParameters();

        public CollateralInterestParametersBuilder setPostingParty(CounterpartyRoleEnum var1);

        public CollateralInterestParametersBuilder setMarginType(CollateralMarginTypeEnum var1);

        public CollateralInterestParametersBuilder setCurrency(String var1);

        public CollateralInterestParametersBuilder setInterestCalculationParameters(CollateralInterestCalculationParameters var1);

        public CollateralInterestParametersBuilder setInterestCalculationFrequency(CalculationFrequency var1);

        public CollateralInterestParametersBuilder setInterestHandlingParameters(CollateralInterestHandlingParameters var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("postingParty"), CounterpartyRoleEnum.class, (Object)this.getPostingParty(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("marginType"), CollateralMarginTypeEnum.class, (Object)this.getMarginType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("currency"), String.class, (Object)this.getCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestCalculationParameters"), processor, CollateralInterestCalculationParameters.CollateralInterestCalculationParametersBuilder.class, this.getInterestCalculationParameters(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestCalculationFrequency"), processor, CalculationFrequency.CalculationFrequencyBuilder.class, this.getInterestCalculationFrequency(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("interestHandlingParameters"), processor, CollateralInterestHandlingParameters.CollateralInterestHandlingParametersBuilder.class, this.getInterestHandlingParameters(), new AttributeMeta[0]);
        }

        public CollateralInterestParametersBuilder prune();
    }

    public static class CollateralInterestParametersImpl
    implements CollateralInterestParameters {
        private final CounterpartyRoleEnum postingParty;
        private final CollateralMarginTypeEnum marginType;
        private final String currency;
        private final CollateralInterestCalculationParameters interestCalculationParameters;
        private final CalculationFrequency interestCalculationFrequency;
        private final CollateralInterestHandlingParameters interestHandlingParameters;

        protected CollateralInterestParametersImpl(CollateralInterestParametersBuilder builder) {
            this.postingParty = builder.getPostingParty();
            this.marginType = builder.getMarginType();
            this.currency = builder.getCurrency();
            this.interestCalculationParameters = Optional.ofNullable(builder.getInterestCalculationParameters()).map(f -> f.build()).orElse(null);
            this.interestCalculationFrequency = Optional.ofNullable(builder.getInterestCalculationFrequency()).map(f -> f.build()).orElse(null);
            this.interestHandlingParameters = Optional.ofNullable(builder.getInterestHandlingParameters()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="postingParty")
        @RuneAttribute(value="postingParty")
        public CounterpartyRoleEnum getPostingParty() {
            return this.postingParty;
        }

        @Override
        @RosettaAttribute(value="marginType")
        @RuneAttribute(value="marginType")
        public CollateralMarginTypeEnum getMarginType() {
            return this.marginType;
        }

        @Override
        @RosettaAttribute(value="currency")
        @RuneAttribute(value="currency")
        public String getCurrency() {
            return this.currency;
        }

        @Override
        @RosettaAttribute(value="interestCalculationParameters")
        @RuneAttribute(value="interestCalculationParameters")
        public CollateralInterestCalculationParameters getInterestCalculationParameters() {
            return this.interestCalculationParameters;
        }

        @Override
        @RosettaAttribute(value="interestCalculationFrequency")
        @RuneAttribute(value="interestCalculationFrequency")
        public CalculationFrequency getInterestCalculationFrequency() {
            return this.interestCalculationFrequency;
        }

        @Override
        @RosettaAttribute(value="interestHandlingParameters")
        @RuneAttribute(value="interestHandlingParameters")
        public CollateralInterestHandlingParameters getInterestHandlingParameters() {
            return this.interestHandlingParameters;
        }

        @Override
        public CollateralInterestParameters build() {
            return this;
        }

        @Override
        public CollateralInterestParametersBuilder toBuilder() {
            CollateralInterestParametersBuilder builder = CollateralInterestParameters.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(CollateralInterestParametersBuilder builder) {
            Optional.ofNullable(this.getPostingParty()).ifPresent(builder::setPostingParty);
            Optional.ofNullable(this.getMarginType()).ifPresent(builder::setMarginType);
            Optional.ofNullable(this.getCurrency()).ifPresent(builder::setCurrency);
            Optional.ofNullable(this.getInterestCalculationParameters()).ifPresent(builder::setInterestCalculationParameters);
            Optional.ofNullable(this.getInterestCalculationFrequency()).ifPresent(builder::setInterestCalculationFrequency);
            Optional.ofNullable(this.getInterestHandlingParameters()).ifPresent(builder::setInterestHandlingParameters);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            CollateralInterestParameters _that = this.getType().cast(o);
            if (!Objects.equals((Object)this.postingParty, (Object)_that.getPostingParty())) {
                return false;
            }
            if (!Objects.equals((Object)this.marginType, (Object)_that.getMarginType())) {
                return false;
            }
            if (!Objects.equals(this.currency, _that.getCurrency())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationParameters, _that.getInterestCalculationParameters())) {
                return false;
            }
            if (!Objects.equals(this.interestCalculationFrequency, _that.getInterestCalculationFrequency())) {
                return false;
            }
            return Objects.equals(this.interestHandlingParameters, _that.getInterestHandlingParameters());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.postingParty != null ? ((Object)((Object)this.postingParty)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.marginType != null ? ((Object)((Object)this.marginType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.currency != null ? this.currency.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationParameters != null ? this.interestCalculationParameters.hashCode() : 0);
            _result = 31 * _result + (this.interestCalculationFrequency != null ? this.interestCalculationFrequency.hashCode() : 0);
            _result = 31 * _result + (this.interestHandlingParameters != null ? this.interestHandlingParameters.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "CollateralInterestParameters {postingParty=" + (Object)((Object)this.postingParty) + ", marginType=" + (Object)((Object)this.marginType) + ", currency=" + this.currency + ", interestCalculationParameters=" + this.interestCalculationParameters + ", interestCalculationFrequency=" + this.interestCalculationFrequency + ", interestHandlingParameters=" + this.interestHandlingParameters + '}';
        }
    }
}

