/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.csa.processor;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.metafields.FieldWithMetaBusinessCenterEnum;
import cdm.legaldocumentation.csa.CalculationDateLocation;
import cdm.legaldocumentation.csa.CalculationDateLocationElection;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.Path;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import java.util.List;
import java.util.Optional;
import org.isda.cdm.processor.CreateiQMappingProcessorUtils;

public class CalculationDateLocationMappingProcessor
extends MappingProcessor {
    public CalculationDateLocationMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext mappingContext) {
        super(modelPath, synonymPaths, mappingContext);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        CalculationDateLocation.CalculationDateLocationBuilder calculationDateLocationBuilder = (CalculationDateLocation.CalculationDateLocationBuilder)builder;
        CreateiQMappingProcessorUtils.PARTIES.forEach(party -> this.getCalculationDateLocation(synonymPath, (String)party).ifPresent(calculationDateLocationBuilder::addPartyElection));
    }

    private Optional<CalculationDateLocationElection> getCalculationDateLocation(Path synonymPath, String party) {
        CalculationDateLocationElection.CalculationDateLocationElectionBuilder calculationDateLocationElectionBuilder = CalculationDateLocationElection.builder();
        String selectLocationSynonymValue = synonymPath.endsWith(new String[]{"calculation_date"}) ? "_calculation_date_location" : "_" + synonymPath.getLastElement().getPathName();
        this.setValueAndUpdateMappings(synonymPath.addElement(party + selectLocationSynonymValue), value -> calculationDateLocationElectionBuilder.setParty(CreateiQMappingProcessorUtils.toCounterpartyRoleEnum(party)));
        this.setValueAndUpdateMappings(synonymPath.addElement(party + "_location"), value -> this.getSynonymToEnumMap().getEnumValueOptional(BusinessCenterEnum.class, value).map(enumValue -> FieldWithMetaBusinessCenterEnum.builder().setValue((BusinessCenterEnum)((Object)((Object)enumValue))).build()).ifPresent(calculationDateLocationElectionBuilder::setBusinessCenter));
        this.setValueAndUpdateMappings(synonymPath.addElement(party + "_specify"), value -> calculationDateLocationElectionBuilder.setCustomLocation(CreateiQMappingProcessorUtils.removeHtml(value)));
        return calculationDateLocationElectionBuilder.hasData() ? Optional.of(calculationDateLocationElectionBuilder.build()) : Optional.empty();
    }
}

