/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.tradestate.functions;

import cdm.ingest.fpml.confirmation.tradestate.functions.MapPriceQuantityList;
import cdm.observable.asset.PriceQuantity;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import fpml.confirmation.PartiesAndAccountsModel;
import fpml.confirmation.Trade;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapTradeLotListDefault.class)
public abstract class MapTradeLotList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapPriceQuantityList mapPriceQuantityList;

    public List<? extends TradeLot> evaluate(Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
        List tradeLotList;
        List<TradeLot.TradeLotBuilder> tradeLotListBuilder = this.doEvaluate(fpmlTrade, fpmlPartiesAndAccountsModel);
        if (tradeLotListBuilder == null) {
            tradeLotList = null;
        } else {
            tradeLotList = tradeLotListBuilder.stream().map(TradeLot::build).collect(Collectors.toList());
            this.objectValidator.validate(TradeLot.class, tradeLotList);
        }
        return tradeLotList;
    }

    protected abstract List<TradeLot.TradeLotBuilder> doEvaluate(Trade var1, PartiesAndAccountsModel var2);

    public static class MapTradeLotListDefault
    extends MapTradeLotList {
        @Override
        protected List<TradeLot.TradeLotBuilder> doEvaluate(Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
            ArrayList<TradeLot.TradeLotBuilder> tradeLotList = new ArrayList<TradeLot.TradeLotBuilder>();
            return this.assignOutput(tradeLotList, fpmlTrade, fpmlPartiesAndAccountsModel);
        }

        protected List<TradeLot.TradeLotBuilder> assignOutput(List<TradeLot.TradeLotBuilder> tradeLotList, Trade fpmlTrade, PartiesAndAccountsModel fpmlPartiesAndAccountsModel) {
            TradeLot tradeLot = TradeLot.builder().setPriceQuantity(new ArrayList<PriceQuantity>(this.mapPriceQuantityList.evaluate(fpmlTrade))).build();
            if (tradeLot == null) {
                tradeLotList.addAll(this.toBuilder(Collections.emptyList()));
            } else {
                tradeLotList.addAll(this.toBuilder(Collections.singletonList(tradeLot)));
            }
            return Optional.ofNullable(tradeLotList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

