/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.settlement.functions;

import cdm.base.datetime.AdjustableDate;
import cdm.base.datetime.AdjustableOrRelativeDate;
import cdm.ingest.fpml.confirmation.common.functions.MapCurrency;
import cdm.ingest.fpml.confirmation.common.functions.MapInformationSource;
import cdm.ingest.fpml.confirmation.datetime.functions.MapBusinessCenterTime;
import cdm.ingest.fpml.confirmation.datetime.functions.MapZoneDateTimeToDate;
import cdm.observable.asset.FxSpotRateSource;
import cdm.observable.asset.QuoteBasisEnum;
import cdm.observable.asset.QuotedCurrencyPair;
import cdm.observable.asset.ValuationMethod;
import cdm.observable.asset.ValuationSource;
import cdm.product.common.settlement.CashSettlementTerms;
import cdm.product.common.settlement.FxFixingDate;
import cdm.product.common.settlement.SettlementDate;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.common.settlement.ValuationDate;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import fpml.confirmation.BusinessCenterTime;
import fpml.confirmation.Currency;
import fpml.confirmation.FxOption;
import fpml.confirmation.InformationSource;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapFxOptionToSettlementTermsDefault.class)
public abstract class MapFxOptionToSettlementTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapBusinessCenterTime mapBusinessCenterTime;
    @Inject
    protected MapCurrency mapCurrency;
    @Inject
    protected MapInformationSource mapInformationSource;
    @Inject
    protected MapZoneDateTimeToDate mapZoneDateTimeToDate;

    public SettlementTerms evaluate(FxOption fpmlFxOption) {
        SettlementTerms settlementTerms;
        SettlementTerms.SettlementTermsBuilder settlementTermsBuilder = this.doEvaluate(fpmlFxOption);
        if (settlementTermsBuilder == null) {
            settlementTerms = null;
        } else {
            settlementTerms = settlementTermsBuilder.build();
            this.objectValidator.validate(SettlementTerms.class, (RosettaModelObject)settlementTerms);
        }
        return settlementTerms;
    }

    protected abstract SettlementTerms.SettlementTermsBuilder doEvaluate(FxOption var1);

    protected abstract MapperS<ZonedDateTime> EuropeanExercise(FxOption var1);

    protected abstract MapperS<ZonedDateTime> AmericanExercise(FxOption var1);

    protected abstract MapperS<ZonedDateTime> settlementDate(FxOption var1);

    protected abstract MapperS<SettlementTypeEnum> settlementType(FxOption var1);

    public static class MapFxOptionToSettlementTermsDefault
    extends MapFxOptionToSettlementTerms {
        @Override
        protected SettlementTerms.SettlementTermsBuilder doEvaluate(FxOption fpmlFxOption) {
            SettlementTerms.SettlementTermsBuilder settlementTerms = SettlementTerms.builder();
            return this.assignOutput(settlementTerms, fpmlFxOption);
        }

        protected SettlementTerms.SettlementTermsBuilder assignOutput(SettlementTerms.SettlementTermsBuilder settlementTerms, FxOption fpmlFxOption) {
            if (ExpressionOperators.exists(this.settlementDate(fpmlFxOption)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                MapperC thenArg = MapperS.of((Object)fpmlFxOption).map("getCashSettlement", fxOption -> fxOption.getCashSettlement()).mapC("getFixing", fxCashSettlement -> fxCashSettlement.getFixing());
                settlementTerms = (SettlementTerms.SettlementTermsBuilder)this.toBuilder(SettlementTerms.builder().setSettlementDate(SettlementDate.builder().setValueDate(this.mapZoneDateTimeToDate.evaluate((ZonedDateTime)this.settlementDate(fpmlFxOption).get())).build()).setSettlementType((SettlementTypeEnum)((Object)this.settlementType(fpmlFxOption).get())).setSettlementCurrency(this.mapCurrency.evaluate((Currency)MapperS.of((Object)fpmlFxOption).map("getCashSettlement", fxOption -> fxOption.getCashSettlement()).map("getSettlementCurrency", fxCashSettlement -> fxCashSettlement.getSettlementCurrency()).get())).setCashSettlementTerms(thenArg.mapItem(item -> {
                    MapperS _thenArg = item.map("getQuotedCurrencyPair", fxFixing -> fxFixing.getQuotedCurrencyPair());
                    return MapperS.of((Object)CashSettlementTerms.builder().setValuationMethod(ValuationMethod.builder().setValuationSource(ValuationSource.builder().setQuotedCurrencyPairValue((QuotedCurrencyPair)_thenArg.mapSingleToItem(_item -> MapperS.of((Object)QuotedCurrencyPair.builder().setCurrency1(this.mapCurrency.evaluate((Currency)_item.map("getCurrency1", quotedCurrencyPair -> quotedCurrencyPair.getCurrency1()).get())).setCurrency2(this.mapCurrency.evaluate((Currency)_item.map("getCurrency2", quotedCurrencyPair -> quotedCurrencyPair.getCurrency2()).get())).setQuoteBasis((QuoteBasisEnum)((Object)((Object)((Object)_item.map("getQuoteBasis", quotedCurrencyPair -> quotedCurrencyPair.getQuoteBasis()).checkedMap("to-enum", e -> QuoteBasisEnum.valueOf(e.name()), IllegalArgumentException.class).get())))).build())).get()).setInformationSource(FxSpotRateSource.builder().setPrimarySource(this.mapInformationSource.evaluate((InformationSource)item.map("getFxSpotRateSource", fxFixing -> fxFixing.getFxSpotRateSource()).map("getPrimaryRateSource", fxSpotRateSource -> fxSpotRateSource.getPrimaryRateSource()).get())).build()).build()).build()).setValuationDate(ValuationDate.builder().setFxFixingDate(FxFixingDate.builder().setPeriod(null).setPeriodMultiplier(null).setFxFixingDate(AdjustableOrRelativeDate.builder().setAdjustableDate(AdjustableDate.builder().setAdjustedDateValue((Date)item.map("getFixingDate", fxFixing -> fxFixing.getFixingDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).build()).build()).build()).build()).setValuationTime(this.mapBusinessCenterTime.evaluate((BusinessCenterTime)item.map("getFxSpotRateSource", fxFixing -> fxFixing.getFxSpotRateSource()).map("getFixingTime", fxSpotRateSource -> fxSpotRateSource.getFixingTime()).get())).build());
                }).getMulti()).build());
            } else {
                settlementTerms = null;
            }
            return Optional.ofNullable(settlementTerms).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<ZonedDateTime> EuropeanExercise(FxOption fpmlFxOption) {
            return MapperS.of((Object)fpmlFxOption).map("getEuropeanExercise", fxOption -> fxOption.getEuropeanExercise()).map("getValueDate", fxEuropeanExercise -> fxEuropeanExercise.getValueDate());
        }

        @Override
        protected MapperS<ZonedDateTime> AmericanExercise(FxOption fpmlFxOption) {
            return MapperS.of((Object)fpmlFxOption).map("getAmericanExercise", fxOption -> fxOption.getAmericanExercise()).map("getLatestValueDate", fxAmericanExercise -> fxAmericanExercise.getLatestValueDate());
        }

        @Override
        protected MapperS<ZonedDateTime> settlementDate(FxOption fpmlFxOption) {
            if (ExpressionOperators.exists(this.EuropeanExercise(fpmlFxOption)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.EuropeanExercise(fpmlFxOption);
            }
            if (ExpressionOperators.exists(this.AmericanExercise(fpmlFxOption)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.AmericanExercise(fpmlFxOption);
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<SettlementTypeEnum> settlementType(FxOption fpmlFxOption) {
            if (ExpressionOperators.exists((Mapper)MapperS.of((Object)fpmlFxOption).map("getCashSettlement", fxOption -> fxOption.getCashSettlement())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperS.of((Object)((Object)SettlementTypeEnum.CASH));
            }
            return MapperS.ofNull();
        }
    }
}

