/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.swap.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.product.swap.functions.MapSwapPayout;
import cdm.ingest.fpml.confirmation.product.swap.functions.MapTerminationProvision;
import cdm.product.template.EconomicTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.CancelableProvision;
import fpml.confirmation.EarlyTerminationProvision;
import fpml.confirmation.ExtendibleProvision;
import fpml.confirmation.InterestRateStream;
import fpml.confirmation.Swap;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapSwapEconomicTermsDefault.class)
public abstract class MapSwapEconomicTerms
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapSwapPayout mapSwapPayout;
    @Inject
    protected MapTerminationProvision mapTerminationProvision;

    public EconomicTerms evaluate(Swap fpmlSwap, List<? extends Counterparty> cdmCounterpartyList) {
        EconomicTerms economicTerms;
        EconomicTerms.EconomicTermsBuilder economicTermsBuilder = this.doEvaluate(fpmlSwap, cdmCounterpartyList);
        if (economicTermsBuilder == null) {
            economicTerms = null;
        } else {
            economicTerms = economicTermsBuilder.build();
            this.objectValidator.validate(EconomicTerms.class, (RosettaModelObject)economicTerms);
        }
        return economicTerms;
    }

    protected abstract EconomicTerms.EconomicTermsBuilder doEvaluate(Swap var1, List<? extends Counterparty> var2);

    public static class MapSwapEconomicTermsDefault
    extends MapSwapEconomicTerms {
        @Override
        protected EconomicTerms.EconomicTermsBuilder doEvaluate(Swap fpmlSwap, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            EconomicTerms.EconomicTermsBuilder economicTerms = EconomicTerms.builder();
            return this.assignOutput(economicTerms, fpmlSwap, cdmCounterpartyList);
        }

        protected EconomicTerms.EconomicTermsBuilder assignOutput(EconomicTerms.EconomicTermsBuilder economicTerms, Swap fpmlSwap, List<? extends Counterparty> cdmCounterpartyList) {
            economicTerms = (EconomicTerms.EconomicTermsBuilder)this.toBuilder(EconomicTerms.builder().setPayout(MapperS.of((Object)fpmlSwap).mapC("getSwapStream", swap -> swap.getSwapStream()).mapItem(item -> MapperS.of((Object)this.mapSwapPayout.evaluate((InterestRateStream)item.get(), cdmCounterpartyList))).getMulti()).setTerminationProvision(this.mapTerminationProvision.evaluate((EarlyTerminationProvision)MapperS.of((Object)fpmlSwap).map("getEarlyTerminationProvision", swap -> swap.getEarlyTerminationProvision()).get(), (CancelableProvision)MapperS.of((Object)fpmlSwap).map("getCancelableProvision", swap -> swap.getCancelableProvision()).get(), (ExtendibleProvision)MapperS.of((Object)fpmlSwap).map("getExtendibleProvision", swap -> swap.getExtendibleProvision()).get(), cdmCounterpartyList)).build());
            return Optional.ofNullable(economicTerms).map(o -> o.prune()).orElse(null);
        }
    }
}

