/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.returnswap.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.product.returnswap.functions.MapInterestLegToInterestRatePayout;
import cdm.ingest.fpml.confirmation.product.returnswap.functions.MapReturnLegToPerformancePayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.DirectionalLeg;
import fpml.confirmation.InterestLeg;
import fpml.confirmation.ReturnLeg;
import fpml.confirmation.custom.functions.ToLegChoice;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapReturnSwapLegToPayoutDefault.class)
public abstract class MapReturnSwapLegToPayout
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected MapInterestLegToInterestRatePayout mapInterestLegToInterestRatePayout;
    @Inject
    protected MapReturnLegToPerformancePayout mapReturnLegToPerformancePayout;
    @Inject
    protected ToLegChoice toLegChoice;

    public Payout evaluate(DirectionalLeg fpmlDirectionalLeg, List<? extends Counterparty> cdmCounterpartyList) {
        Payout payout;
        Payout.PayoutBuilder payoutBuilder = this.doEvaluate(fpmlDirectionalLeg, cdmCounterpartyList);
        if (payoutBuilder == null) {
            payout = null;
        } else {
            payout = payoutBuilder.build();
            this.objectValidator.validate(Payout.class, (RosettaModelObject)payout);
        }
        return payout;
    }

    protected abstract Payout.PayoutBuilder doEvaluate(DirectionalLeg var1, List<? extends Counterparty> var2);

    public static class MapReturnSwapLegToPayoutDefault
    extends MapReturnSwapLegToPayout {
        @Override
        protected Payout.PayoutBuilder doEvaluate(DirectionalLeg fpmlDirectionalLeg, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            Payout.PayoutBuilder payout = Payout.builder();
            return this.assignOutput(payout, fpmlDirectionalLeg, cdmCounterpartyList);
        }

        protected Payout.PayoutBuilder assignOutput(Payout.PayoutBuilder payout, DirectionalLeg fpmlDirectionalLeg, List<? extends Counterparty> cdmCounterpartyList) {
            MapperS switchArgument = MapperS.of((Object)this.toLegChoice.evaluate(fpmlDirectionalLeg));
            if (switchArgument.get() == null) {
                payout = null;
            } else if (switchArgument.map("getInterestLeg", legChoice -> legChoice.getInterestLeg()).get() != null) {
                MapperS interestLeg = switchArgument.map("getInterestLeg", legChoice -> legChoice.getInterestLeg());
                payout = (Payout.PayoutBuilder)this.toBuilder(this.mapInterestLegToInterestRatePayout.evaluate((InterestLeg)interestLeg.get(), cdmCounterpartyList));
            } else if (switchArgument.map("getReturnLeg", legChoice -> legChoice.getReturnLeg()).get() != null) {
                MapperS returnLeg = switchArgument.map("getReturnLeg", legChoice -> legChoice.getReturnLeg());
                payout = (Payout.PayoutBuilder)this.toBuilder(this.mapReturnLegToPerformancePayout.evaluate((ReturnLeg)returnLeg.get(), cdmCounterpartyList));
            } else {
                payout = null;
            }
            return Optional.ofNullable(payout).map(o -> o.prune()).orElse(null);
        }
    }
}

