/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.product.commodityswaption.functions;

import cdm.base.staticdata.party.Counterparty;
import cdm.ingest.fpml.confirmation.common.functions.GetFpmlCommodityPhysicalExercise;
import cdm.ingest.fpml.confirmation.common.functions.MapExerciseTerms;
import cdm.ingest.fpml.confirmation.party.functions.MapBuyerSeller;
import cdm.ingest.fpml.confirmation.party.functions.MapSellerAsPayerAndBuyerAsReceiver;
import cdm.ingest.fpml.confirmation.product.commodityswaption.functions.MapUnderlierNonTransferableProduct;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.Underlier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import fpml.confirmation.BuyerSellerModel;
import fpml.confirmation.CommodityPhysicalExercise;
import fpml.confirmation.CommoditySwapDetailsModel;
import fpml.confirmation.CommoditySwaption;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=MapCommoditySwaptionPayoutDefault.class)
public abstract class MapCommoditySwaptionPayout
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetFpmlCommodityPhysicalExercise getFpmlCommodityPhysicalExercise;
    @Inject
    protected MapBuyerSeller mapBuyerSeller;
    @Inject
    protected MapExerciseTerms mapExerciseTerms;
    @Inject
    protected MapSellerAsPayerAndBuyerAsReceiver mapSellerAsPayerAndBuyerAsReceiver;
    @Inject
    protected MapUnderlierNonTransferableProduct mapUnderlierNonTransferableProduct;

    public Payout evaluate(CommoditySwaption fpmlCommoditySwaption, List<? extends Counterparty> cdmCounterpartyList) {
        Payout payout;
        Payout.PayoutBuilder payoutBuilder = this.doEvaluate(fpmlCommoditySwaption, cdmCounterpartyList);
        if (payoutBuilder == null) {
            payout = null;
        } else {
            payout = payoutBuilder.build();
            this.objectValidator.validate(Payout.class, (RosettaModelObject)payout);
        }
        return payout;
    }

    protected abstract Payout.PayoutBuilder doEvaluate(CommoditySwaption var1, List<? extends Counterparty> var2);

    public static class MapCommoditySwaptionPayoutDefault
    extends MapCommoditySwaptionPayout {
        @Override
        protected Payout.PayoutBuilder doEvaluate(CommoditySwaption fpmlCommoditySwaption, List<? extends Counterparty> cdmCounterpartyList) {
            if (cdmCounterpartyList == null) {
                cdmCounterpartyList = Collections.emptyList();
            }
            Payout.PayoutBuilder payout = Payout.builder();
            return this.assignOutput(payout, fpmlCommoditySwaption, cdmCounterpartyList);
        }

        protected Payout.PayoutBuilder assignOutput(Payout.PayoutBuilder payout, CommoditySwaption fpmlCommoditySwaption, List<? extends Counterparty> cdmCounterpartyList) {
            payout = (Payout.PayoutBuilder)this.toBuilder(Payout.builder().setOptionPayout(OptionPayout.builder().setPayerReceiver(this.mapSellerAsPayerAndBuyerAsReceiver.evaluate((BuyerSellerModel)MapperS.of((Object)fpmlCommoditySwaption).map("getBuyerSellerModel", commoditySwaption -> commoditySwaption.getBuyerSellerModel()).get(), cdmCounterpartyList)).setSettlementTerms(null).setBuyerSeller(this.mapBuyerSeller.evaluate((BuyerSellerModel)MapperS.of((Object)fpmlCommoditySwaption).map("getBuyerSellerModel", commoditySwaption -> commoditySwaption.getBuyerSellerModel()).get(), cdmCounterpartyList)).setUnderlier(Underlier.builder().setProduct(Product.builder().setNonTransferableProduct(this.mapUnderlierNonTransferableProduct.evaluate((CommoditySwapDetailsModel)MapperS.of((Object)fpmlCommoditySwaption).map("getCommoditySwap", commoditySwaption -> commoditySwaption.getCommoditySwap()).map("getCommoditySwapDetailsModel", commoditySwaptionUnderlying -> commoditySwaptionUnderlying.getCommoditySwapDetailsModel()).get(), cdmCounterpartyList)).build()).build()).setOptionType(null).setExerciseTerms(this.mapExerciseTerms.evaluate(this.getFpmlCommodityPhysicalExercise.evaluate((CommodityPhysicalExercise)MapperS.of((Object)fpmlCommoditySwaption).map("getPhysicalExercise", commoditySwaption -> commoditySwaption.getPhysicalExercise()).get()), null, null, (BuyerSellerModel)MapperS.of((Object)fpmlCommoditySwaption).map("getBuyerSellerModel", commoditySwaption -> commoditySwaption.getBuyerSellerModel()).get(), cdmCounterpartyList)).setStrike(null).build()).build());
            return Optional.ofNullable(payout).map(o -> o.prune()).orElse(null);
        }
    }
}

