/*
 * Decompiled with CFR 0.152.
 */
package cdm.ingest.fpml.confirmation.pricequantity.functions;

import cdm.base.math.DatedValue;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import fpml.confirmation.Step;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=MapScheduleToDatedValueListDefault.class)
public abstract class MapScheduleToDatedValueList
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends DatedValue> evaluate(List<? extends Step> fpmlStepList) {
        List datedValueList;
        List<DatedValue.DatedValueBuilder> datedValueListBuilder = this.doEvaluate(fpmlStepList);
        if (datedValueListBuilder == null) {
            datedValueList = null;
        } else {
            datedValueList = datedValueListBuilder.stream().map(DatedValue::build).collect(Collectors.toList());
            this.objectValidator.validate(DatedValue.class, datedValueList);
        }
        return datedValueList;
    }

    protected abstract List<DatedValue.DatedValueBuilder> doEvaluate(List<? extends Step> var1);

    public static class MapScheduleToDatedValueListDefault
    extends MapScheduleToDatedValueList {
        @Override
        protected List<DatedValue.DatedValueBuilder> doEvaluate(List<? extends Step> fpmlStepList) {
            if (fpmlStepList == null) {
                fpmlStepList = Collections.emptyList();
            }
            ArrayList<DatedValue.DatedValueBuilder> datedValueList = new ArrayList<DatedValue.DatedValueBuilder>();
            return this.assignOutput(datedValueList, fpmlStepList);
        }

        protected List<DatedValue.DatedValueBuilder> assignOutput(List<DatedValue.DatedValueBuilder> datedValueList, List<? extends Step> fpmlStepList) {
            datedValueList.addAll(this.toBuilder(MapperC.of(fpmlStepList).mapItem(item -> {
                DatedValue.DatedValueBuilder withMetaArgument = DatedValue.builder().setDate((Date)item.map("getStepDate", step -> step.getStepDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).setValue((BigDecimal)item.map("getStepValue", step -> step.getStepValue()).get()).build() == null ? null : DatedValue.builder().setDate((Date)item.map("getStepDate", step -> step.getStepDate()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())).get()).setValue((BigDecimal)item.map("getStepValue", step -> step.getStepValue()).get()).build().toBuilder();
                withMetaArgument.getOrCreateMeta().setExternalKey((String)item.map("getId", step -> step.getId()).get());
                return MapperS.of((Object)withMetaArgument);
            }).getMulti()));
            return Optional.ofNullable(datedValueList).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

