/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.ExecutionDetails;
import cdm.event.common.ExecutionInstruction;
import cdm.event.common.TradeState;
import cdm.event.position.PositionStatusEnum;
import cdm.product.collateral.Collateral;
import cdm.product.template.NonTransferableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaDate;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=Create_ExecutionDefault.class)
public abstract class Create_Execution
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TradeState evaluate(ExecutionInstruction instruction) {
        TradeState execution;
        TradeState.TradeStateBuilder executionBuilder = this.doEvaluate(instruction);
        if (executionBuilder == null) {
            execution = null;
        } else {
            execution = executionBuilder.build();
            this.objectValidator.validate(TradeState.class, (RosettaModelObject)execution);
        }
        return execution;
    }

    protected abstract TradeState.TradeStateBuilder doEvaluate(ExecutionInstruction var1);

    public static class Create_ExecutionDefault
    extends Create_Execution {
        @Override
        protected TradeState.TradeStateBuilder doEvaluate(ExecutionInstruction instruction) {
            TradeState.TradeStateBuilder execution = TradeState.builder();
            return this.assignOutput(execution, instruction);
        }

        protected TradeState.TradeStateBuilder assignOutput(TradeState.TradeStateBuilder execution, ExecutionInstruction instruction) {
            execution.getOrCreateTrade().setProduct((NonTransferableProduct)MapperS.of((Object)instruction).map("getProduct", executionInstruction -> executionInstruction.getProduct()).get());
            TradeLot tradeLot = TradeLot.builder().setPriceQuantity(MapperS.of((Object)instruction).mapC("getPriceQuantity", executionInstruction -> executionInstruction.getPriceQuantity()).getMulti()).setLotIdentifier(MapperS.of((Object)instruction).map("getLotIdentifier", executionInstruction -> executionInstruction.getLotIdentifier()).getMulti()).build();
            execution.getOrCreateTrade().addTradeLot(tradeLot == null ? Collections.emptyList() : Collections.singletonList(tradeLot));
            execution.getOrCreateTrade().addCounterparty(MapperS.of((Object)instruction).mapC("getCounterparty", executionInstruction -> executionInstruction.getCounterparty()).getMulti());
            execution.getOrCreateTrade().addAncillaryParty(MapperS.of((Object)instruction).mapC("getAncillaryParty", executionInstruction -> executionInstruction.getAncillaryParty()).getMulti());
            execution.getOrCreateTrade().addParty(MapperS.of((Object)instruction).mapC("getParties", executionInstruction -> executionInstruction.getParties()).getMulti());
            execution.getOrCreateTrade().addPartyRole(MapperS.of((Object)instruction).mapC("getPartyRoles", executionInstruction -> executionInstruction.getPartyRoles()).getMulti());
            execution.getOrCreateTrade().setExecutionDetails((ExecutionDetails)MapperS.of((Object)instruction).map("getExecutionDetails", executionInstruction -> executionInstruction.getExecutionDetails()).get());
            execution.getOrCreateTrade().setTradeDate((FieldWithMetaDate)MapperS.of((Object)instruction).map("getTradeDate", executionInstruction -> executionInstruction.getTradeDate()).get());
            execution.getOrCreateTrade().addTradeIdentifier(MapperS.of((Object)instruction).mapC("getTradeIdentifier", executionInstruction -> executionInstruction.getTradeIdentifier()).getMulti());
            execution.getOrCreateState().setPositionState(PositionStatusEnum.EXECUTED);
            execution.getOrCreateTrade().setCollateral((Collateral)MapperS.of((Object)instruction).map("getCollateral", executionInstruction -> executionInstruction.getCollateral()).get());
            return Optional.ofNullable(execution).map(o -> o.prune()).orElse(null);
        }
    }
}

