/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.processor;

import cdm.base.staticdata.asset.common.AssetIdTypeEnum;
import cdm.base.staticdata.asset.common.AssetIdentifier;
import com.regnosys.rosetta.common.translation.MappingContext;
import com.regnosys.rosetta.common.translation.MappingProcessor;
import com.regnosys.rosetta.common.translation.MappingProcessorUtils;
import com.regnosys.rosetta.common.translation.Path;
import com.regnosys.rosetta.common.util.PathUtils;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.metafields.FieldWithMetaString;
import java.util.List;

public class AssetIdentifierTypeMappingProcessor
extends MappingProcessor {
    public AssetIdentifierTypeMappingProcessor(RosettaPath modelPath, List<Path> synonymPaths, MappingContext context) {
        super(modelPath, synonymPaths, context);
    }

    public void map(Path synonymPath, RosettaModelObjectBuilder builder, RosettaModelObjectBuilder parent) {
        MappingProcessorUtils.getNonNullMappingForModelPath((List)this.getMappings(), (Path)PathUtils.toPath((RosettaPath)this.getModelPath().newSubPath("value"))).ifPresent(mapping -> {
            AssetIdentifier.AssetIdentifierBuilder assetIdentifierBuilder = (AssetIdentifier.AssetIdentifierBuilder)parent;
            FieldWithMetaString.FieldWithMetaStringBuilder assetIdentifierValueBuilder = (FieldWithMetaString.FieldWithMetaStringBuilder)builder;
            Path baseModelPath = mapping.getRosettaPath().getParent();
            this.updateSchemeAndSource(mapping.getXmlPath(), baseModelPath, assetIdentifierBuilder, assetIdentifierValueBuilder);
            if (assetIdentifierBuilder.getIdentifierType() == null) {
                assetIdentifierBuilder.setIdentifierType(AssetIdTypeEnum.OTHER);
            }
        });
    }

    protected void updateSchemeAndSource(Path xmlPath, Path baseModelPath, AssetIdentifier.AssetIdentifierBuilder assetIdentifierBuilder, FieldWithMetaString.FieldWithMetaStringBuilder assetIdentifierValueBuilder) {
        this.setSchemeAndIdentifierType(assetIdentifierBuilder, assetIdentifierValueBuilder, xmlPath.addElement("instrumentIdScheme"), baseModelPath);
        this.setSchemeAndIdentifierType(assetIdentifierBuilder, assetIdentifierValueBuilder, xmlPath.addElement("productIdScheme"), baseModelPath);
        this.setSchemeAndIdentifierType(assetIdentifierBuilder, assetIdentifierValueBuilder, xmlPath.addElement("indexIdScheme"), baseModelPath);
        this.setSchemeAndIdentifierType(assetIdentifierBuilder, assetIdentifierValueBuilder, xmlPath.addElement("indexNameScheme"), baseModelPath);
        if (xmlPath.endsWith(new String[]{"currency"})) {
            assetIdentifierBuilder.setIdentifierType(AssetIdTypeEnum.CURRENCY_CODE);
            this.setSchemeAndIdentifierType(assetIdentifierBuilder, assetIdentifierValueBuilder, xmlPath.addElement("currencyScheme"), baseModelPath);
        }
        if (xmlPath.endsWith(new String[]{"description"})) {
            assetIdentifierBuilder.setIdentifierType(AssetIdTypeEnum.NAME);
        }
    }

    private void setSchemeAndIdentifierType(AssetIdentifier.AssetIdentifierBuilder assetIdentifierBuilder, FieldWithMetaString.FieldWithMetaStringBuilder assetIdentifierValueBuilder, Path schemeSynonymPath, Path baseModelPath) {
        Path schemeModelPath = baseModelPath.addElement("meta").addElement("scheme");
        MappingProcessorUtils.setValueAndUpdateMappings((Path)schemeSynonymPath, xmlValue -> this.setSchemeAndIdentifierType(assetIdentifierBuilder, assetIdentifierValueBuilder, (String)xmlValue), (List)this.getMappings(), (RosettaPath)PathUtils.toRosettaPath((Path)schemeModelPath));
    }

    private void setSchemeAndIdentifierType(AssetIdentifier.AssetIdentifierBuilder assetIdentifierBuilder, FieldWithMetaString.FieldWithMetaStringBuilder assetIdentifierValueBuilder, String xmlValue) {
        assetIdentifierValueBuilder.getOrCreateMeta().setScheme(xmlValue);
        assetIdentifierBuilder.setIdentifierType(this.getSourceEnum(xmlValue));
    }

    protected AssetIdTypeEnum getSourceEnum(String scheme) {
        if (scheme.contains("CUSIP")) {
            return AssetIdTypeEnum.CUSIP;
        }
        if (scheme.contains("ISIN")) {
            return AssetIdTypeEnum.ISIN;
        }
        if (scheme.contains("RIC")) {
            return AssetIdTypeEnum.RIC;
        }
        if (scheme.contains("Bloomberg")) {
            return AssetIdTypeEnum.BBGID;
        }
        if (scheme.contains("commodity-reference-price")) {
            return AssetIdTypeEnum.ISDACRP;
        }
        if (scheme.contains("iso4914")) {
            return AssetIdTypeEnum.UPI;
        }
        return AssetIdTypeEnum.OTHER;
    }
}

