/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.math;

import cdm.base.math.DatedValue;
import cdm.base.math.meta.ScheduleMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Schedule", builder=ScheduleBuilderImpl.class, version="7.0.0-dev.50")
@RuneDataType(value="Schedule", model="cdm", builder=ScheduleBuilderImpl.class, version="7.0.0-dev.50")
public interface Schedule
extends RosettaModelObject {
    public static final ScheduleMeta metaData = new ScheduleMeta();

    public BigDecimal getValue();

    public List<? extends DatedValue> getDatedValue();

    public Schedule build();

    public ScheduleBuilder toBuilder();

    public static ScheduleBuilder builder() {
        return new ScheduleBuilderImpl();
    }

    default public RosettaMetaData<? extends Schedule> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Schedule> getType() {
        return Schedule.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.class, this.getDatedValue(), new AttributeMeta[0]);
    }

    public static class ScheduleBuilderImpl
    implements ScheduleBuilder {
        protected BigDecimal value;
        protected List<DatedValue.DatedValueBuilder> datedValue = new ArrayList<DatedValue.DatedValueBuilder>();

        @Override
        @RosettaAttribute(value="value", isRequired=true)
        @RuneAttribute(value="value", isRequired=true)
        public BigDecimal getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        @RuneAttribute(value="datedValue")
        public List<? extends DatedValue.DatedValueBuilder> getDatedValue() {
            return this.datedValue;
        }

        @Override
        public DatedValue.DatedValueBuilder getOrCreateDatedValue(int index) {
            if (this.datedValue == null) {
                this.datedValue = new ArrayList<DatedValue.DatedValueBuilder>();
            }
            return (DatedValue.DatedValueBuilder)this.getIndex(this.datedValue, index, () -> {
                DatedValue.DatedValueBuilder newDatedValue = DatedValue.builder();
                return newDatedValue;
            });
        }

        @Override
        @RosettaAttribute(value="value", isRequired=true)
        @RuneAttribute(value="value", isRequired=true)
        public ScheduleBuilder setValue(BigDecimal _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        @RuneAttribute(value="datedValue")
        public ScheduleBuilder addDatedValue(DatedValue _datedValue) {
            if (_datedValue != null) {
                this.datedValue.add(_datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public ScheduleBuilder addDatedValue(DatedValue _datedValue, int idx) {
            this.getIndex(this.datedValue, idx, () -> _datedValue.toBuilder());
            return this;
        }

        @Override
        public ScheduleBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="datedValue")
        public ScheduleBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList<DatedValue.DatedValueBuilder>() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        public Schedule build() {
            return new ScheduleImpl(this);
        }

        @Override
        public ScheduleBuilder toBuilder() {
            return this;
        }

        @Override
        public ScheduleBuilder prune() {
            this.datedValue = this.datedValue.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            return this;
        }

        public boolean hasData() {
            if (this.getValue() != null) {
                return true;
            }
            return this.getDatedValue() != null && this.getDatedValue().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData());
        }

        public ScheduleBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ScheduleBuilder o = (ScheduleBuilder)other;
            merger.mergeRosetta(this.getDatedValue(), o.getDatedValue(), this::getOrCreateDatedValue);
            merger.mergeBasic((Object)this.getValue(), (Object)o.getValue(), this::setValue, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Schedule _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            return ListEquals.listEquals(this.datedValue, _that.getDatedValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.datedValue != null ? this.datedValue.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ScheduleBuilder {value=" + this.value + ", datedValue=" + this.datedValue + '}';
        }
    }

    public static interface ScheduleBuilder
    extends Schedule,
    RosettaModelObjectBuilder {
        public DatedValue.DatedValueBuilder getOrCreateDatedValue(int var1);

        public List<? extends DatedValue.DatedValueBuilder> getDatedValue();

        public ScheduleBuilder setValue(BigDecimal var1);

        public ScheduleBuilder addDatedValue(DatedValue var1);

        public ScheduleBuilder addDatedValue(DatedValue var1, int var2);

        public ScheduleBuilder addDatedValue(List<? extends DatedValue> var1);

        public ScheduleBuilder setDatedValue(List<? extends DatedValue> var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.DatedValueBuilder.class, this.getDatedValue(), new AttributeMeta[0]);
        }

        public ScheduleBuilder prune();
    }

    public static class ScheduleImpl
    implements Schedule {
        private final BigDecimal value;
        private final List<? extends DatedValue> datedValue;

        protected ScheduleImpl(ScheduleBuilder builder) {
            this.value = builder.getValue();
            this.datedValue = Optional.ofNullable(builder.getDatedValue()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
        }

        @Override
        @RosettaAttribute(value="value", isRequired=true)
        @RuneAttribute(value="value", isRequired=true)
        public BigDecimal getValue() {
            return this.value;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        @RuneAttribute(value="datedValue")
        public List<? extends DatedValue> getDatedValue() {
            return this.datedValue;
        }

        @Override
        public Schedule build() {
            return this;
        }

        @Override
        public ScheduleBuilder toBuilder() {
            ScheduleBuilder builder = Schedule.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ScheduleBuilder builder) {
            Optional.ofNullable(this.getValue()).ifPresent(builder::setValue);
            Optional.ofNullable(this.getDatedValue()).ifPresent(builder::setDatedValue);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Schedule _that = this.getType().cast(o);
            if (!Objects.equals(this.value, _that.getValue())) {
                return false;
            }
            return ListEquals.listEquals(this.datedValue, _that.getDatedValue());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.value != null ? this.value.hashCode() : 0);
            _result = 31 * _result + (this.datedValue != null ? this.datedValue.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Schedule {value=" + this.value + ", datedValue=" + this.datedValue + '}';
        }
    }
}

