# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Product']


class Product(BaseDataClass):
    _CHOICE_ALIAS_MAP ={"economicTerms":[("TransferableProduct", rosetta_resolve_attr), ("NonTransferableProduct", rosetta_resolve_attr)]}
    """
    Enables either a TransferableProduct or a NonTransferableProduct to be used in an underlier.
    """
    TransferableProduct: Optional[cdm.product.template.TransferableProduct.TransferableProduct] = Field(None, description="A TransferableProduct is a type of financial product which can be held or transferred, represented as an Asset with the addition of specific EconomicTerms.")
    """
    A TransferableProduct is a type of financial product which can be held or transferred, represented as an Asset with the addition of specific EconomicTerms.
    """
    NonTransferableProduct: Optional[cdm.product.template.NonTransferableProduct.NonTransferableProduct] = Field(None, description="The non-transferable product data type represents a product that can be traded (as part of a TradableProduct) but cannot be transferred to others.")
    """
    The non-transferable product data type represents a product that can be traded (as part of a TradableProduct) but cannot be transferred to others.
    """
    
    @rosetta_condition
    def condition_0_Choice(self):
        item = self
        return rosetta_check_one_of(self, 'TransferableProduct', 'NonTransferableProduct', necessity=True)

import cdm 
import cdm.product.template.TransferableProduct
import cdm.product.template.NonTransferableProduct
