# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OptionStrike']


class OptionStrike(BaseDataClass):
    """
    Defines the strike price of an option.
    """
    strikePrice: Optional[cdm.observable.asset.Price.Price] = Field(None, description="Defines the strike of an option in the form of a price that could be a cash price, interestRate, or other types.")
    """
    Defines the strike of an option in the form of a price that could be a cash price, interestRate, or other types.
    """
    strikeReference: Optional[AttributeWithReference | cdm.product.asset.FixedRateSpecification.FixedRateSpecification] = Field(None, description="Defines the strike of an option in reference to the spread of the underlying swap (typical practice in the case of an option on a credit single name swaps).")
    """
    Defines the strike of an option in reference to the spread of the underlying swap (typical practice in the case of an option on a credit single name swaps).
    """
    referenceSwapCurve: Optional[cdm.observable.asset.ReferenceSwapCurve.ReferenceSwapCurve] = Field(None, description="Defines the strike of an option when expressed by reference to a swap curve (Typically the case for a convertible bond option).")
    """
    Defines the strike of an option when expressed by reference to a swap curve (Typically the case for a convertible bond option).
    """
    averagingStrikeFeature: Optional[cdm.product.template.AveragingStrikeFeature.AveragingStrikeFeature] = Field(None, description="Defines an option strike that is calculated from an average of observed market prices.")
    """
    Defines an  option strike that is calculated from an average of observed market prices.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'strikePrice', 'strikeReference', 'referenceSwapCurve', 'averagingStrikeFeature', necessity=True)

import cdm 
import cdm.observable.asset.Price
import cdm.product.asset.FixedRateSpecification
import cdm.observable.asset.ReferenceSwapCurve
import cdm.product.template.AveragingStrikeFeature
