# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ExerciseTerms']


class ExerciseTerms(BaseDataClass):
    """
    A class defining the exercise period for an option together with any rules governing the notional amount of the underlying which can be exercised on any given exercise date and any associated exercise fees.
    """
    style: Optional[cdm.product.template.OptionExerciseStyleEnum.OptionExerciseStyleEnum] = Field(None, description="Whether the option has a single exercise (european), multiple exercise dates (bermuda), or a continuous range of exercise (american).")
    """
    Whether the option has a single exercise (european), multiple exercise dates (bermuda), or a continuous range of exercise (american).
    """
    commencementDate: Optional[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field(None, description="The first day of the exercise period for an American style option.")
    """
    The first day of the exercise period for an American style option.
    """
    exerciseDates: Optional[cdm.base.datetime.AdjustableOrRelativeDates.AdjustableOrRelativeDates] = Field(None, description="The dates that define the Bermuda option exercise dates and the expiration date. The last specified date is assumed to be the expiration date. The dates can either be specified as a series of explicit dates and associated adjustments or as a series of dates defined relative to another schedule of dates, for example, the calculation period start dates. Where a relative series of dates are defined the first and last possible exercise dates can be separately specified.")
    """
    The dates that define the Bermuda option exercise dates and the expiration date. The last specified date is assumed to be the expiration date. The dates can either be specified as a series of explicit dates and associated adjustments or as a series of dates defined relative to another schedule of dates, for example, the calculation period start dates. Where a relative series of dates are defined the first and last possible exercise dates can be separately specified.
    """
    expirationDate: List[cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate] = Field([], description="The last day within an exercise period for an American style option. For a European style option it is the only day within the exercise period.")
    """
    The last day within an exercise period for an American style option. For a European style option it is the only day within the exercise period.
    """
    relevantUnderlyingDate: Optional[cdm.base.datetime.AdjustableOrRelativeDates.AdjustableOrRelativeDates] = Field(None, description="The effective date on the underlying product if the option is exercised. For example, for a swaption it is the swap effective date, for an option on an FX spot or forward it is the value date for settlement, and in an extendible/cancelable provision it is the swap termination date, which is the date on which the termination is effective.'")
    """
    The effective date on the underlying product if the option is exercised.  For example, for a swaption it is the swap effective date, for an option on an FX spot or forward it is the value date for settlement, and in an extendible/cancelable provision it is the swap termination date, which is the date on which the termination is effective.'
    """
    earliestExerciseTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The earliest time at which notice of exercise can be given by the buyer to the seller (or seller's agent) to, and including, the expiration date.")
    """
    The earliest time at which notice of exercise can be given by the buyer to the seller (or seller's agent) to, and including, the expiration date.
    """
    latestExerciseTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="For a Bermuda or American style option, the latest time on an exercise business day (excluding the expiration date) within the exercise period that notice can be given by the buyer to the seller or seller's agent. Notice of exercise given after this time will be deemed to have been given on the next exercise business day.")
    """
    For a Bermuda or American style option, the latest time on an exercise business day (excluding the expiration date) within the exercise period that notice can be given by the buyer to the seller or seller's agent. Notice of exercise given after this time will be deemed to have been given on the next exercise business day.
    """
    expirationTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The latest time for exercise on expirationDate. It is made mandatory given that for all option styles, this field is required.")
    """
    The latest time for exercise on expirationDate. It is made mandatory given that for all option styles, this field is required.
    """
    expirationTimeType: cdm.product.template.ExpirationTimeTypeEnum.ExpirationTimeTypeEnum = Field(..., description="The time of day at which the equity option expires, for example the official closing time of the exchange.")
    """
    The time of day at which the equity option expires, for example the official closing time of the exchange.
    """
    multipleExercise: Optional[cdm.product.template.MultipleExercise.MultipleExercise] = Field(None, description="As defined in the 2000 ISDA Definitions, Section 12.4. Multiple Exercise, the buyer of the option has the right to exercise all or less than all the unexercised notional amount of the underlying swap on one or more days in the exercise period, but on any such day may not exercise less than the minimum notional amount or more that the maximum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.")
    """
    As defined in the 2000 ISDA Definitions, Section 12.4. Multiple Exercise, the buyer of the option has the right to exercise all or less than all the unexercised notional amount of the underlying swap on one or more days in the exercise period, but on any such day may not exercise less than the minimum notional amount or more that the maximum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.
    """
    exerciseFeeSchedule: Optional[cdm.product.template.ExerciseFeeSchedule.ExerciseFeeSchedule] = Field(None, description="The fees associated with an exercise date. The fees are conditional on the exercise occurring. The fees can be specified as actual currency amounts or as percentages of the notional amount being exercised.")
    """
    The fees associated with an exercise date. The fees are conditional on the exercise occurring. The fees can be specified as actual currency amounts or as percentages of the notional amount being exercised.
    """
    exerciseProcedure: Optional[cdm.product.template.ExerciseProcedure.ExerciseProcedure] = Field(None, description="The set of parameters defining the procedure associated with the exercise, e.g. manual exercise.")
    """
    The set of parameters defining the procedure associated with the exercise, e.g. manual exercise.
    """
    exerciseFee: Optional[cdm.product.template.ExerciseFee.ExerciseFee] = Field(None, description="A fee to be paid on exercise. This could be represented as an amount or a rate and notional reference on which to apply the rate.")
    """
    A fee to be paid on exercise. This could be represented as an amount or a rate and notional reference on which to apply the rate.
    """
    partialExercise: Optional[cdm.product.template.PartialExercise.PartialExercise] = Field(None, description="As defined in the 2000 ISDA Definitions, Section 12.3. Partial Exercise, the buyer of the option has the right to exercise all or less than all the notional amount of the underlying swap on the expiration date, but may not exercise less than the minimum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.")
    """
    As defined in the 2000 ISDA Definitions, Section 12.3. Partial Exercise, the buyer of the option has the right to exercise all or less than all the notional amount of the underlying swap on the expiration date, but may not exercise less than the minimum notional amount, and if an integral multiple amount is specified, the notional amount exercised must be equal to, or be an integral multiple of, the integral multiple amount.
    """
    
    @rosetta_condition
    def condition_0_ExerciseDateExpirationDateChoice(self):
        """
        Required choice rule between exercise dates and expiration date. The exerciseDates field can be used to extract the expiration date of a bermuda option, while the expirationDate field refers to the expiration date of an american or european option.
        """
        item = self
        return rosetta_check_one_of(self, 'exerciseDates', 'expirationDate', necessity=True)
    
    @rosetta_condition
    def condition_1_CommencementAndExpirationDate(self):
        """
        Condition to check that expiration date is present when commencement date is present.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "expirationDate"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "commencementDate")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_2_AmericanExercise(self):
        """
        Condition to check that only fields expected for an american option are present.
        """
        item = self
        def _then_fn0():
            return (((rosetta_attr_exists(rosetta_resolve_attr(self, "commencementDate")) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "exerciseFee")))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "partialExercise")))) and all_elements(rosetta_count(rosetta_resolve_attr(self, "expirationDate")), "=", 1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "style"), "=", rosetta_resolve_attr(OptionExerciseStyleEnum, "AMERICAN")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_3_EuropeanExercise(self):
        """
        Condition to check that only fields expected for a european option are present.
        """
        item = self
        def _then_fn0():
            return ((((rosetta_attr_exists(rosetta_resolve_attr(self, "expirationDate")) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "exerciseFeeSchedule")))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "multipleExercise")))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "latestExerciseTime")))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "commencementDate"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "style"), "=", rosetta_resolve_attr(OptionExerciseStyleEnum, "EUROPEAN")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_4_BermudaExercise(self):
        """
        Condition to check that only fields expected for a bermuda option are present.
        """
        item = self
        def _then_fn0():
            return (((rosetta_attr_exists(rosetta_resolve_attr(self, "exerciseDates")) and rosetta_attr_exists(rosetta_resolve_attr(self, "earliestExerciseTime"))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "partialExercise")))) and (not rosetta_attr_exists(rosetta_resolve_attr(self, "exerciseFee"))))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "style"), "=", rosetta_resolve_attr(OptionExerciseStyleEnum, "BERMUDA")), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_5_ExpirationTimeChoice(self):
        """
        Condition to validate the correlation between expirationTime and expirationTimeType
        """
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "expirationTime"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return (all_elements(rosetta_resolve_attr(self, "expirationTimeType"), "=", rosetta_resolve_attr(ExpirationTimeTypeEnum, "SPECIFIC_TIME")) and if_cond_fn(all_elements(rosetta_resolve_attr(self, "expirationTimeType"), "=", rosetta_resolve_attr(ExpirationTimeTypeEnum, "SPECIFIC_TIME")), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(self, "expirationTime")), _then_fn0, _else_fn0)

import cdm 
import cdm.product.template.OptionExerciseStyleEnum
import cdm.base.datetime.AdjustableOrRelativeDate
import cdm.base.datetime.AdjustableOrRelativeDates
import cdm.base.datetime.BusinessCenterTime
import cdm.product.template.ExpirationTimeTypeEnum
import cdm.product.template.MultipleExercise
import cdm.product.template.ExerciseFeeSchedule
import cdm.product.template.ExerciseProcedure
import cdm.product.template.ExerciseFee
import cdm.product.template.PartialExercise
from cdm.product.template.OptionExerciseStyleEnum import OptionExerciseStyleEnum
from cdm.product.template.ExpirationTimeTypeEnum import ExpirationTimeTypeEnum
