# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Composite']


class Composite(BaseDataClass):
    """
    Specifies the conditions to be applied for converting into a reference currency when the actual currency rate is not determined upfront.
    """
    determinationMethod: Optional[cdm.observable.common.DeterminationMethodEnum.DeterminationMethodEnum] = Field(None, description="Specifies the method according to which an amount or a date is determined.")
    """
    Specifies the method according to which an amount or a date is determined.
    """
    relativeDate: Optional[cdm.base.datetime.RelativeDateOffset.RelativeDateOffset] = Field(None, description="A date specified as some offset to another date (the anchor date).")
    """
    A date specified as some offset to another date (the anchor date).
    """
    fxSpotRateSource: Optional[cdm.observable.asset.FxSpotRateSource.FxSpotRateSource] = Field(None, description="Specifies the methodology (reference source and, optionally, fixing time) to be used for determining a currency conversion rate.")
    """
    Specifies the methodology (reference source and, optionally, fixing time) to be used for determining a currency conversion rate.
    """
    fixingTime: Optional[cdm.base.datetime.BusinessCenterTime.BusinessCenterTime] = Field(None, description="The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.")
    """
    The time at which the spot currency exchange rate will be observed. It is specified as a time in a business day calendar location, e.g. 11:00am London time.
    """

import cdm 
import cdm.observable.common.DeterminationMethodEnum
import cdm.base.datetime.RelativeDateOffset
import cdm.observable.asset.FxSpotRateSource
import cdm.base.datetime.BusinessCenterTime
