# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.staticdata.asset.rates.FloatingRateIndexEnum import FloatingRateIndexEnum
from cdm.product.template.EconomicTerms import EconomicTerms

__all__ = ['Qualify_Transaction_OIS']


@replaceable
def Qualify_Transaction_OIS(economicTerms: EconomicTerms) -> bool:
    """
    Qualifies a product as having the Transaction classification OIS
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    floatingRateIndex = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "InterestRatePayout"), "rateSpecification"), "FloatingRateSpecification"), "rateOption"), "FloatingRateIndex"), "floatingRateIndex")
    is_product =  (((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((((all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "AUD_AONIA_OIS_COMPOUND")) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "AUD_AONIA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "AUD_AONIA_OIS_COMPOUND_SWAP_MARKER"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CAD_CORRA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CAD_CORRA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CHF_OIS_11_00_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CHF_SARON_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CHF_SARON_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CHF_TOIS_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CNY_SHIBOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CNY_SHIBOR_OIS_COMPOUNDING"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "COP_IBR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "COP_IBR_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "CZK_CZEONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "DKK_DESTR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "DKK_DKKOIS_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "DKK_TOM_NEXT_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_10_00_BGCANTOR"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_10_00_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_10_00_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_11_00_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_4_15_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EONIA_OIS_COMPOUND_BLOOMBERG"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EURONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EURONIA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "EUR_EURO_STR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_RONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_SONIA_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_SONIA_OIS_11_00_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_SONIA_OIS_11_00_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_SONIA_OIS_4_15_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_SONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_WMBA_RONIA_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "GBP_WMBA_SONIA_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "HKD_HONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "HKD_HONIX_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "HUF_HUFONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "ILS_SHIR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "INR_FBIL_MIBOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "INR_MIBOR_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "INR_MIBOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "INR_MIOIS"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "INR_MITOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "JPY_OIS_11_00_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "JPY_OIS_11_00_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "JPY_OIS_3_00_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "JPY_TONA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "JPY_TONA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "KRW_KOFR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "MXN_TIIE_ON_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "MYR_MYOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "NOK_NOWA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "NZD_NZIONA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "NZD_NZIONA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "PLN_POLONIA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "PLN_POLONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "PLN_WIRON_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "REPOFUNDS_RATE_FRANCE_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "REPOFUNDS_RATE_GERMANY_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "REPOFUNDS_RATE_ITALY_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "RUB_RUONIA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "RUB_RUONIA_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "SEK_SIOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "SEK_STIBOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "SEK_SWESTR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "SGD_SONAR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "SGD_SONAR_OIS_VWAP_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "SGD_SORA_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "SGD_SORA_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "THB_THOR_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "THB_THOR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "TRY_TLREF_OIS_COMPOUND_1"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "TRY_TLREF_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_FEDERAL_FUNDS_H_15_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_FEDERAL_FUNDS_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_OIS_11_00_BGCANTOR"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_OIS_11_00_LON_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_OIS_11_00_NY_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_OIS_11_00_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_OIS_3_00_BGCANTOR"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_OIS_3_00_NY_ICAP"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_OIS_4_00_TRADITION"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "USD_SOFR_OIS_COMPOUND"))) or all_elements(rosetta_resolve_attr(self, "floatingRateIndex"), "=", rosetta_resolve_attr(FloatingRateIndexEnum, "ZAR_ZARONIA_OIS_COMPOUND")))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
