# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.staticdata.asset.common.InstrumentTypeEnum import InstrumentTypeEnum
from cdm.base.staticdata.asset.common.FundProductTypeEnum import FundProductTypeEnum
from cdm.base.staticdata.asset.common.Instrument import Instrument

__all__ = ['Qualify_InstrumentTypeEquity']


@replaceable
def Qualify_InstrumentTypeEquity(instrument: Instrument) -> bool:
    """
    Qualifies that the security type, for all of the provided securities, is Equity-related.
    
    Parameters 
    ----------
    instrument : Instrument
    
    Returns
    -------
    is_equity : boolean
    
    """
    self = inspect.currentframe()
    
    
    instrumentType = rosetta_resolve_deep_attr(self, "instrumentType")
    is_equity =  (((all_elements(rosetta_resolve_attr(self, "instrumentType"), "=", rosetta_resolve_attr(InstrumentTypeEnum, "EQUITY")) or (all_elements(rosetta_resolve_attr(self, "instrumentType"), "=", rosetta_resolve_attr(InstrumentTypeEnum, "FUND")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instrument"), "Security"), "fundType"), "=", rosetta_resolve_attr(FundProductTypeEnum, "EXCHANGE_TRADED_FUND")))) or (all_elements(rosetta_resolve_attr(self, "instrumentType"), "=", rosetta_resolve_attr(InstrumentTypeEnum, "FUND")) and all_elements(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "instrument"), "Security"), "fundType"), "=", rosetta_resolve_attr(FundProductTypeEnum, "MUTUAL_FUND")))) or all_elements(rosetta_resolve_attr(self, "instrumentType"), "=", rosetta_resolve_attr(InstrumentTypeEnum, "WARRANT")))
    
    
    return is_equity

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
