# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.qualification.functions.Qualify_UnderlierObservable_Equity import Qualify_UnderlierObservable_Equity
from cdm.product.template.EconomicTerms import EconomicTerms

__all__ = ['Qualify_AssetClass_Equity']


@replaceable
def Qualify_AssetClass_Equity(economicTerms: EconomicTerms) -> bool:
    """
    
    Parameters 
    ----------
    economicTerms : EconomicTerms
    
    Returns
    -------
    is_product : boolean
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn0():
        return all_elements(Qualify_AssetClass_Equity(rosetta_resolve_deep_attr(self, "economicTerms")), "=", True)
    
    def _else_fn0():
        return False
    
    def _then_fn0():
        return all_elements(Qualify_AssetClass_Equity(rosetta_resolve_deep_attr(self, "economicTerms")), "=", True)
    
    def _else_fn0():
        return False
    
    optionUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "OptionPayout")), "underlier")
    settlementUnderlier = rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "SettlementPayout")), "underlier")
    is_product =  (((rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "PerformancePayout")) and all_elements(list(map(lambda item: Qualify_UnderlierObservable_Equity(item), rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout"), "PerformancePayout"), "underlier"), "Observable"))), "=", True)) or (rosetta_attr_exists(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout")), "OptionPayout")) and (Qualify_UnderlierObservable_Equity(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "Observable")) or if_cond_fn(rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "optionUnderlier"), "Product")), _then_fn0, _else_fn0)))) or (rosetta_attr_exists(rosetta_resolve_attr(get_only_element(rosetta_resolve_attr(rosetta_resolve_attr(self, "economicTerms"), "payout")), "SettlementPayout")) and (Qualify_UnderlierObservable_Equity(rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementUnderlier"), "Observable")) or if_cond_fn(rosetta_attr_exists(rosetta_resolve_deep_attr(self, "economicTerms")), _then_fn0, _else_fn0))))
    
    
    return is_product

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
