# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['ConcentrationLimitCriteria']

from cdm.product.collateral.CollateralCriteriaBase import CollateralCriteriaBase

class ConcentrationLimitCriteria(CollateralCriteriaBase):
    """
    Respresents a class to describe a set of criteria to describe specific assets that the concentration limits apply to.
    """
    concentrationLimitType: Optional[cdm.product.collateral.ConcentrationLimitTypeEnum.ConcentrationLimitTypeEnum] = Field(None, description="Specifies the type of concentration limit to be applied.")
    """
    Specifies the type of concentration limit to be applied.
    """
    averageTradingVolume: Optional[cdm.product.collateral.AverageTradingVolume.AverageTradingVolume] = Field(None, description="Specifies an average trading volume on an exchange in relation to Equity products.")
    """
    Specifies an average trading volume on an exchange in relation to Equity products.
    """
    
    @rosetta_condition
    def condition_0_ConcentrationLimitTypeChoice(self):
        """
        Either a limit type or limit criteria must be specified.
        """
        item = self
        return rosetta_check_one_of(self, 'concentrationLimitType', 'averageTradingVolume', 'collateralCriteria', necessity=True)

import cdm 
import cdm.product.collateral.ConcentrationLimitTypeEnum
import cdm.product.collateral.AverageTradingVolume
