# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['CollateralCriteriaBase']


class CollateralCriteriaBase(BaseDataClass):
    """
    Represents a set of criteria used to specify and describe collateral.
    """
    collateralCriteria: Optional[cdm.product.collateral.CollateralCriteria.CollateralCriteria] = Field(None, description="The specific criteria that applies. It can be created using AND, OR and NOT logic, and both asset and issuer characteristics.")
    """
    The specific criteria that applies. It can be created using AND, OR and NOT logic, and both asset and issuer characteristics.
    """
    appliesTo: List[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field([], description="Specifies which of the two counterparties the criteria applies to (either one or both counterparties). This attribute is optional, in case the applicable party is already specified elsewhere within a party election.")
    """
    Specifies which of the two counterparties the criteria applies to (either one or both counterparties). This attribute is optional, in case the applicable party is already specified elsewhere within a party election.
    """
    restrictTo: Optional[cdm.product.collateral.CollateralMarginTypeEnum.CollateralMarginTypeEnum] = Field(None, description="Restrict the criteria to only apply to a specific type of margin, ie IM or VM.")
    """
    Restrict the criteria to only apply to a specific type of margin, ie IM or VM.
    """
    ratingPriorityResolution: Optional[cdm.product.collateral.RatingPriorityResolutionEnum.RatingPriorityResolutionEnum] = Field(None, description="Denotes which Criteria has priority if more than one agency rating applies.")
    """
    Denotes which Criteria has priority if more than one agency rating applies.
    """

import cdm 
import cdm.product.collateral.CollateralCriteria
import cdm.base.staticdata.party.CounterpartyRoleEnum
import cdm.product.collateral.CollateralMarginTypeEnum
import cdm.product.collateral.RatingPriorityResolutionEnum
