# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['FloatingRateIndexDefinition']


class FloatingRateIndexDefinition(BaseDataClass):
    fro: cdm.observable.asset.fro.FloatingRateIndexIdentification.FloatingRateIndexIdentification = Field(..., description="The underlying FRO name and designated maturity.")
    """
    The underlying FRO name and designated maturity.
    """
    calculationDefaults: Optional[cdm.observable.asset.fro.FloatingRateIndexCalculationDefaults.FloatingRateIndexCalculationDefaults] = Field(None, description="Any calculation default values.")
    """
    Any calculation default values.
    """
    supportedDefinition: List[cdm.observable.asset.fro.ContractualDefinition.ContractualDefinition] = Field([], description="The definition version or versions supported by the FRO.")
    """
    The definition version or versions supported by the FRO.
    """
    definitionalSource: Optional[str] = Field(None, description="The source of an FRO, particularly if not a Contractual Definition (e.g. the broker rates matrix).")
    """
    The source of an FRO, particularly if not a Contractual Definition (e.g. the broker rates matrix).
    """
    designatedMaturityApplicable: Optional[bool] = Field(None, description="")
    mappings: Optional[cdm.observable.asset.fro.FloatingRateIndexMappings.FloatingRateIndexMappings] = Field(None, description="Any mappings to other FRos.")
    """
    Any mappings to other FRos.
    """
    externalMappings: Optional[cdm.observable.asset.fro.FloatingRateIndexExternalMappings.FloatingRateIndexExternalMappings] = Field(None, description="Any mappings to other codes for this index.")
    """
    Any mappings to other codes for this index.
    """
    inLoan: Optional[bool] = Field(None, description="YES / NO to flag FROs identified by the FpML Syndicated Loan WG as having underlying benchmark that may also be referenced in syndicated loans.")
    """
    YES / NO to flag FROs identified by the FpML Syndicated Loan WG as having underlying benchmark that may also be referenced in syndicated loans.
    """
    history: Optional[cdm.observable.asset.fro.FroHistory.FroHistory] = Field(None, description="FRO History")
    """
    FRO History
    """
    deprecationReason: Optional[str] = Field(None, description="Deprecation and Code Descriptions")
    """
    Deprecation and Code Descriptions
    """
    fpmlDescription: Optional[str] = Field(None, description="FpML Description")
    """
    FpML Description
    """

import cdm 
import cdm.observable.asset.fro.FloatingRateIndexIdentification
import cdm.observable.asset.fro.FloatingRateIndexCalculationDefaults
import cdm.observable.asset.fro.ContractualDefinition
import cdm.observable.asset.fro.FloatingRateIndexMappings
import cdm.observable.asset.fro.FloatingRateIndexExternalMappings
import cdm.observable.asset.fro.FroHistory
