# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['BusinessDayOffset']

from cdm.base.datetime.Period import Period

class BusinessDayOffset(Period):
    """
    This allows an offset to be specified as, for instance, N business days, with a business centers specified as included.
    """
    businessCenters: Optional[cdm.base.datetime.BusinessCenters.BusinessCenters] = Field(None, description="The business centers for the offset.")
    """
    The business centers for the offset.
    """
    fixingOffsetDefinition: Optional[str] = Field(None, description="Legal text that underlies the Fixing Offset. ISDA Fixing Offset Definition. (e.g. One day that is either a Sydney Business Day or a Melbourne Business Day following the Reset Date)")
    """
    Legal text that underlies the Fixing Offset. ISDA Fixing Offset Definition. (e.g. One day that is either a Sydney Business Day or a Melbourne Business Day following the Reset Date)
    """
    fixingOffsetReason: Optional[str] = Field(None, description="Fixing Offset Reason")
    """
    Fixing Offset Reason
    """

import cdm 
import cdm.base.datetime.BusinessCenters
