# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.product.qualification.functions.Qualify_ForeignExchange_Swap import Qualify_ForeignExchange_Swap
from cdm.product.qualification.functions.Qualify_ForeignExchange_NDS import Qualify_ForeignExchange_NDS
from cdm.margin.schedule.functions.AdjustableOrAdjustedOrRelativeDateResolution import AdjustableOrAdjustedOrRelativeDateResolution
from cdm.product.template.NonTransferableProduct import NonTransferableProduct
from cdm.product.template.SettlementPayout import SettlementPayout

__all__ = ['FXFarLeg']


@replaceable
def FXFarLeg(product: NonTransferableProduct) -> SettlementPayout:
    """
    Extracts the far leg of an FX swap (deliverable or not) based on two criteria: the forward payout with the latest value date or the forward payout with the latest settlement date.
    
    Parameters 
    ----------
    product : NonTransferableProduct
    
    Returns
    -------
    nearLegPayout : SettlementPayout
    
    """
    self = inspect.currentframe()
    
    
    def _then_fn1():
        return max(rosetta_resolve_attr(self, "settlementPayout"))
    
    def _else_fn1():
        return True
    
    def _then_fn0():
        return max(rosetta_resolve_attr(self, "settlementPayout"))
    
    def _else_fn0():
        return if_cond_fn(((Qualify_ForeignExchange_Swap(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms")) or Qualify_ForeignExchange_NDS(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementPayout"), "settlementTerms"), "settlementDate"), "adjustableOrRelativeDate"))), _then_fn1, _else_fn1)
    
    settlementPayout = rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"), "payout"), "SettlementPayout")
    nearLegPayout =  if_cond_fn(((Qualify_ForeignExchange_Swap(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms")) or Qualify_ForeignExchange_NDS(rosetta_resolve_attr(rosetta_resolve_attr(self, "product"), "economicTerms"))) and rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(rosetta_resolve_attr(self, "settlementPayout"), "settlementTerms"), "settlementDate"), "valueDate"))), _then_fn0, _else_fn0)
    
    
    return nearLegPayout

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
