# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['EscrowArrangement']


class EscrowArrangement(BaseDataClass):
    """
    Refers to the segregation deposit procedure parties may want to commmit into during the time a Disruption Event is effective
    """
    escrowArrangementIsApplicable: bool = Field(..., description="")
    maximumDaysOfDisruption: Optional[cdm.observable.asset.ValuationPostponement.ValuationPostponement] = Field(None, description="")
    bespokeEscrowArrangements: Optional[cdm.legaldocumentation.transaction.Clause.Clause] = Field(None, description="")
    
    @rosetta_condition
    def condition_0_SettlementPostponementExistence(self):
        item = self
        def _then_fn1():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "maximumDaysOfDisruption"))
        
        def _else_fn1():
            return True
        
        def _then_fn0():
            return ((not rosetta_attr_exists(rosetta_resolve_attr(self, "maximumDaysOfDisruption"))) and if_cond_fn(all_elements(rosetta_resolve_attr(self, "escrowArrangementIsApplicable"), "=", True), _then_fn1, _else_fn1))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "escrowArrangementIsApplicable"), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.observable.asset.ValuationPostponement
import cdm.legaldocumentation.transaction.Clause
