# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['PartyOptionTerminationCurrency']


class PartyOptionTerminationCurrency(BaseDataClass):
    """
    Specifies mechanism for Termination currency to be selected by the Non-defaulting Party/party which is not the Affected Party.
    """
    bothAffectedTermCurrencyOption: Optional[str] = Field(None, description="Specifies termination currency where there are two Affected Parties and they cannot agree on the termination currency.")
    """
    Specifies termination currency where there are two Affected Parties and they cannot agree on the termination currency.
    """
    terminationCurrencySpecifiedCondition: Optional[str] = Field(None, description="Specifies alternative conditions for selection of the termination currency.")
    """
    Specifies alternative conditions for selection of the termination currency.
    """
    terminationCurrencyCondition: cdm.legaldocumentation.common.TerminationCurrencyConditionEnum.TerminationCurrencyConditionEnum = Field(..., description="Specifies the enumerated conditions for selection of the termination currency.")
    """
    Specifies the enumerated conditions for selection of the termination currency.
    """
    
    @rosetta_condition
    def condition_0_TerminationCurrencyCondition(self):
        """
        A validation rule to ensure that Termination Currency alternative conditions are specified when required.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "terminationCurrencySpecifiedCondition"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "terminationCurrencyCondition"), "=", rosetta_resolve_attr(TerminationCurrencyConditionEnum, "SPECIFIED")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.common.TerminationCurrencyConditionEnum
from cdm.legaldocumentation.common.TerminationCurrencyConditionEnum import TerminationCurrencyConditionEnum
