# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ValueSecuritiesEnum']

class ValueSecuritiesEnum(Enum):
    """
    Details of how securities collateral is valued when resolving disputes.
    """
    BID_PRICE_PERCENTAGE = "Securities - Bid Price multiplied by Valuation Percentage"
    """
    Securities collateral is valued using the bid price multiplied by the valuation percentage.
    """
    BID_PRICE_PERCENTAGE_LESS_HAIRCUT = "Securities - Bid Price multiplied by (Valuation Percentage - FX Haircut)"
    """
    Securities collateral is valued using the bid price multiplied by the valuation percentage less the FX haircut.
    """
    MID_PRICE_PERCENTAGE = "Securities - Mid Price multiplied by Valuation Percentage"
    """
    Securities collateral is valued using the mid price multiplied by the valuation percentage.
    """
    MID_PRICE_PERCENTAGE_LESS_HAIRCUT = "Securities - Mid Price multiplied by (Valuation Percentage - FX Haircut)"
    """
    Securities collateral is valued using the mid price multiplied by the valuation percentage less the FX haircut.
    """
    OTHER = "Other"
    """
    Exception value.
    """
