# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['ValuationTimeEnum']

class ValuationTimeEnum(Enum):
    """
    The type of time specified for the Valuation Time.
    """
    AS_SELECTED = "AsSelected"
    """
    The valuation time should be as selected.
    """
    CLOSE_OF_BUSINESS = "CloseOfBusiness"
    """
    The valuation time should be at close of business.
    """
    SPECIFIC_TIME = "SpecificTime"
    """
    The valuation time should be at a specific time.
    """
