# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['OneWayProvisions']


class OneWayProvisions(BaseDataClass):
    """
    A class to specify whether One Way Provisions apply.
    """
    isApplicable: bool = Field(..., description="The determination of whether the One Way Provisions are applicable (true) or not applicable (false).")
    """
    The determination of whether the One Way Provisions are applicable (true) or not applicable (false).
    """
    postingParty: Optional[cdm.base.staticdata.party.CounterpartyRoleEnum.CounterpartyRoleEnum] = Field(None, description="The Posting Party for the purposes of One Way Provisions. It is specified in the case where the One Way Provision is deemed applicable.")
    """
    The Posting Party for the purposes of One Way Provisions. It is specified in the case where the One Way Provision is deemed applicable.
    """
    
    @rosetta_condition
    def condition_0_PostingPartyExists(self):
        """
        A data rule to enforce that the Posting Party must be specified in the case where the One Way Provision is deemed applicable.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "postingParty"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", True), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_PostingPartyAbsent(self):
        """
        A data rule to enforce that the Posting Party must not be specified in the case where the One Way Provision is not deemed applicable.
        """
        item = self
        def _then_fn0():
            return (not rosetta_attr_exists(rosetta_resolve_attr(self, "postingParty")))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", False), _then_fn0, _else_fn0)

import cdm 
import cdm.base.staticdata.party.CounterpartyRoleEnum
