# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['NumberOfRatingAgenciesEnum']

class NumberOfRatingAgenciesEnum(Enum):
    """
    The enumerated values to define the number of Rating Agencies that must be considered to meet the rating condition.
    """
    ALL = "All"
    """
    Ratings for all defined Rating Agencies will be considered.
    """
    ANY_ONE = "AnyOne"
    """
    Ratings for Any 1 stated Rating Agency will be applicable.
    """
    ANY_TWO = "AnyTwo"
    """
    Ratings for Any 2 stated Rating Agencies will be applicable.
    """
    OTHER = "Other"
    """
    Utilised where the clause data structure is not able to capture a material aspect of the clause.
    """
