# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['MinimumTransferAmount']


class MinimumTransferAmount(BaseDataClass):
    """
    A class to specify amount of exposure reached before collateral has to be posted or returned.
    """
    partyElection: List[cdm.legaldocumentation.csa.ElectiveAmountElection.ElectiveAmountElection] = Field([], description="The parties' minimum transfer amount elections.")
    """
    The parties' minimum transfer amount elections.
    """
    @rosetta_condition
    def cardinality_partyElection(self):
        return check_cardinality(self.partyElection, 2, None)
    

import cdm 
import cdm.legaldocumentation.csa.ElectiveAmountElection
