# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['MarginApproachEnum']

class MarginApproachEnum(Enum):
    """
    Values to specify the margin approach specific to Initial Margin agreements.
    """
    ALLOCATED = "Allocated"
    """
    Allocated Margin Flow (IM/IA) Approach.
    """
    DISTINCT = "Distinct"
    """
    Distinct Margin Flow (IM) Approach.
    """
    GREATER_OF = "GreaterOf"
    """
    Greater of Margin Flow (IM/IA) Approach.
    """
