# pylint: disable=missing-module-docstring, invalid-name, line-too-long
from enum import Enum

__all__ = ['LegacyResolutionAlternativeEnum']

class LegacyResolutionAlternativeEnum(Enum):
    """
    Details of the alternative dispute resolution procedure (if any).
    """
    ADDITIONAL_CONDITIONS = "AdditionalConditions"
    """
    Additional Conditions are defined.
    """
    NO_ALTERNATIVE = "NoAlternative"
    """
    No Alternative dispute resolution procedure is defined.
    """
    SPLIT_DIFFERENCE = "SplitDifference"
    """
    A split the difference resolution procedure applies.
    """
