# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyResolutionAlternative']


class LegacyResolutionAlternative(BaseDataClass):
    """
    Alternative procedures to those in the pre-print for resolving collateral related disputes.
    """
    resolutionAlternative: Optional[cdm.legaldocumentation.csa.LegacyResolutionAlternativeEnum.LegacyResolutionAlternativeEnum] = Field(None, description="Details of the alternative dispute resolution procedure (if any).")
    """
    Details of the alternative dispute resolution procedure (if any).
    """
    amount: Optional[cdm.observable.asset.Money.Money] = Field(None, description="The maximum amount to which the difference between the calculations by the valuation agent and disputing party can be split, where Split the Difference is elected.")
    """
    The maximum amount to which the difference between the calculations by the valuation agent and disputing party can be split, where Split the Difference is elected.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_AdditionalLanguage(self):
        """
        If no resolution alternative procedure is defined, additional language must be specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn((not rosetta_attr_exists(rosetta_resolve_attr(self, "resolutionAlternative"))), _then_fn0, _else_fn0)
    
    @rosetta_condition
    def condition_1_SplitDifferenceAmount(self):
        """
        If the resolution is to split the difference, then the amount concerned should be specified.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "amount"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "resolutionAlternative"), "=", rosetta_resolve_attr(LegacyResolutionAlternativeEnum, "SPLIT_DIFFERENCE")), _then_fn0, _else_fn0)

import cdm 
import cdm.legaldocumentation.csa.LegacyResolutionAlternativeEnum
import cdm.observable.asset.Money
from cdm.legaldocumentation.csa.LegacyResolutionAlternativeEnum import LegacyResolutionAlternativeEnum
