# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyDeliveryAmount']


class LegacyDeliveryAmount(BaseDataClass):
    """
    In respect of a Valuation Date, the amount of collateral which a party is entitled to demand to be transferred to it as a Delivery Amount.
    """
    legacyDeliveryAmount: cdm.legaldocumentation.csa.LegacyDeliveryReturnAmountEnum.LegacyDeliveryReturnAmountEnum = Field(..., description="Specifies whether the meaning of Delivery Amount follows the pre-print definition or deviates from this (either based on a rating or some other methodology).")
    """
    Specifies whether the meaning of Delivery Amount follows the pre-print definition or deviates from this (either based on a rating or some other methodology).
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """

import cdm 
import cdm.legaldocumentation.csa.LegacyDeliveryReturnAmountEnum
