# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['LegacyDefinition']


class LegacyDefinition(BaseDataClass):
    """
    Bespoke language removing the pre-print requirement to transfer legal title of securities collateral through written instructions to the relevant depository institution or other securities intermediaries solely for the purposes of the 1994 New York Law Credit Support Annex.
    """
    isApplicable: Optional[bool] = Field(None, description="A boolean flag to represent bespoke amendment to the pre-print definition of Transfer.")
    """
    A boolean flag to represent bespoke amendment to the pre-print definition of Transfer.
    """
    additionalLanguage: Optional[str] = Field(None, description="The additional language that might be specified by the parties to the legal agreement.")
    """
    The additional language that might be specified by the parties to the legal agreement.
    """
    
    @rosetta_condition
    def condition_0_ApplicableLanguage(self):
        """
        Additional language is required when a bespoke amendment is used.
        """
        item = self
        def _then_fn0():
            return rosetta_attr_exists(rosetta_resolve_attr(self, "additionalLanguage"))
        
        def _else_fn0():
            return True
        
        return if_cond_fn(all_elements(rosetta_resolve_attr(self, "isApplicable"), "=", False), _then_fn0, _else_fn0)

import cdm 
