# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['IneligibleCreditSupport']


class IneligibleCreditSupport(BaseDataClass):
    """
    A class to specify the parties to which the provisions of the Credit Support Annex for Variation Margin will apply to.
    """
    totalIneligibilityDate: Optional[str] = Field(None, description="Total Ineligibility Date has the meaning specified in Paragraph 11(g), unless otherwise specified here.")
    """
    Total Ineligibility Date has the meaning specified in Paragraph 11(g), unless otherwise specified here.
    """
    transferIneligibilityDate: Optional[str] = Field(None, description="Transfer Ineligibility Date has the meaning specified in Paragraph 11(g), unless otherwise specified here.")
    """
    Transfer Ineligibility Date has the meaning specified in Paragraph 11(g), unless otherwise specified here.
    """
    specifiedParty: List[AttributeWithReference | cdm.base.staticdata.party.Party.Party] = Field([], description="The parties to which the provisions of the CSA will apply to, as the Secured Party.")
    """
    The parties to which the provisions of the CSA will apply to, as the Secured Party.
    """

import cdm 
import cdm.base.staticdata.party.Party
